/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.client;

import com.bay4lly.photochat.PhotoChat;
import com.bay4lly.photochat.client.PhotoUploadTask;
import com.bay4lly.photochat.util.ImageUtils;
import com.bay4lly.photochat.util.Localization;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

@Environment(value=EnvType.CLIENT)
public class FilePathInputScreen
extends class_437 {
    private final class_437 parent;
    private class_342 pathInput;
    private class_4185 sendButton;
    private class_2561 statusMessage = class_2561.method_43473();

    public FilePathInputScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"text.photochat.enter_photo_path"));
        this.parent = parent;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int widgetWidth = 300;
        int widgetHeight = 20;
        this.pathInput = new class_342(this.field_22793, centerX - widgetWidth / 2, centerY - 30, widgetWidth, widgetHeight, (class_2561)class_2561.method_43471((String)"text.photochat.file_path"));
        this.pathInput.method_1852("");
        this.pathInput.method_47404((class_2561)class_2561.method_43471((String)"text.photochat.enter_or_paste_path"));
        this.pathInput.method_1880(Integer.MAX_VALUE);
        this.method_37063((class_364)this.pathInput);
        this.pathInput.method_25365(true);
        this.sendButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"text.photochat.send_button"), button -> this.sendFile()).method_46434(centerX - 155, centerY + 10, 150, widgetHeight).method_46431();
        this.method_37063((class_364)this.sendButton);
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"text.photochat.cancel_button"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX + 5, centerY + 10, 150, widgetHeight).method_46431();
        this.method_37063((class_364)cancelButton);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this.field_22790 / 2 - 60, 0xFFFFFF);
        class_5251 textColor = this.statusMessage.method_10866().method_10973();
        int color = textColor != null ? textColor.method_27716() : 0xFFFFFF;
        context.method_27534(this.field_22793, this.statusMessage, this.field_22789 / 2, this.field_22790 / 2 + 40, color);
        class_5250 infoText1 = class_2561.method_43471((String)"text.photochat.path_copying_instructions_windows").method_27692(class_124.field_1054);
        class_5250 infoText2 = class_2561.method_43471((String)"text.photochat.shift_right_click").method_27692(class_124.field_1080);
        class_5250 infoText3 = class_2561.method_43471((String)"text.photochat.copy_as_path").method_27692(class_124.field_1080);
        class_5250 infoText4 = class_2561.method_43471((String)"text.photochat.paste_with_ctrl_v").method_27692(class_124.field_1080);
        context.method_27534(this.field_22793, (class_2561)infoText1, this.field_22789 / 2, this.field_22790 / 2 + 70, 0xFFFFFF);
        context.method_27534(this.field_22793, (class_2561)infoText2, this.field_22789 / 2, this.field_22790 / 2 + 85, 0xAAAAAA);
        context.method_27534(this.field_22793, (class_2561)infoText3, this.field_22789 / 2, this.field_22790 / 2 + 100, 0xAAAAAA);
        context.method_27534(this.field_22793, (class_2561)infoText4, this.field_22789 / 2, this.field_22790 / 2 + 115, 0xAAAAAA);
        this.pathInput.method_25394(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void sendFile() {
        String rawPath = this.pathInput.method_1882().trim();
        String path = rawPath;
        if (path.startsWith("\"") && path.endsWith("\"")) {
            path = path.substring(1, path.length() - 1).trim();
        }
        File file = new File(path);
        if (path.isEmpty()) {
            this.setStatus((class_2561)class_2561.method_43471((String)"photochat.error.file_not_found").method_27692(class_124.field_1061));
            return;
        }
        if (!file.exists() || file.isDirectory()) {
            this.setStatus((class_2561)class_2561.method_43471((String)"photochat.error.file_not_found").method_27692(class_124.field_1061));
            return;
        }
        try {
            byte[] imageData = ImageUtils.readImage(file);
            new Thread(new PhotoUploadTask(imageData, file.getName())).start();
            this.setStatus((class_2561)class_2561.method_43470((String)"Photo upload started...").method_27692(class_124.field_1060));
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }
        catch (IOException e) {
            PhotoChat.LOGGER.error(Localization.translate("log.photo.read_failed", path), (Throwable)e);
            this.setStatus((class_2561)class_2561.method_43471((String)"photochat.error.read_error").method_27692(class_124.field_1061));
        }
        catch (IllegalArgumentException e) {
            PhotoChat.LOGGER.warn(Localization.translate("log.photo.validation_failed", e.getMessage()));
            this.setStatus((class_2561)class_2561.method_43471((String)e.getMessage()).method_27692(class_124.field_1061));
        }
    }

    private void setStatus(class_2561 message) {
        this.statusMessage = message;
    }

    public boolean onFilesDrop(List<Path> paths) {
        if (!paths.isEmpty()) {
            Path droppedPath = paths.get(0);
            File file = droppedPath.toFile();
            if (!file.isDirectory()) {
                this.pathInput.method_1852(droppedPath.toAbsolutePath().toString());
                this.setStatus((class_2561)class_2561.method_43470((String)"File path automatically filled.").method_27692(class_124.field_1054));
                return true;
            }
            this.setStatus((class_2561)class_2561.method_43470((String)"Error: Cannot drag-and-drop a directory.").method_27692(class_124.field_1061));
            return false;
        }
        return false;
    }

    public boolean method_25421() {
        return false;
    }
}

