/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.network;

import com.bay4lly.photochat.PhotoChat;
import com.bay4lly.photochat.network.PhotoAssembler;
import com.bay4lly.photochat.util.Localization;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class NetworkHandler {
    public static final class_2960 START_UPLOAD = new class_2960("photochat", "start_upload");
    public static final class_2960 UPLOAD_CHUNK = new class_2960("photochat", "upload_chunk");
    public static final class_2960 FINISH_UPLOAD = new class_2960("photochat", "finish_upload");
    public static final class_2960 RECEIVE_PHOTO = new class_2960("photochat", "receive_photo");
    public static final class_2960 START_DOWNLOAD = new class_2960("photochat", "start_download");
    public static final class_2960 DOWNLOAD_CHUNK = new class_2960("photochat", "download_chunk");
    public static final class_2960 FINISH_DOWNLOAD = new class_2960("photochat", "finish_download");

    public static void registerServer() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)START_UPLOAD, (server, player, handler, buf, responseSender) -> {
            UUID photoId = buf.method_10790();
            int totalChunks = buf.readInt();
            server.execute(() -> PhotoAssembler.onUploadStart(player, photoId, totalChunks));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)UPLOAD_CHUNK, (server, player, handler, buf, responseSender) -> {
            UUID photoId = buf.method_10790();
            int chunkIndex = buf.readInt();
            byte[] data = buf.method_10795();
            server.execute(() -> PhotoAssembler.onChunk(photoId, chunkIndex, data));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FINISH_UPLOAD, (server, player, handler, buf, responseSender) -> {
            UUID photoId = buf.method_10790();
            server.execute(() -> {
                byte[] fullImageData = PhotoAssembler.onUploadFinish(photoId);
                if (fullImageData != null) {
                    class_5250 clickableMessage = class_2561.method_43469((String)"text.photochat.sent_a_photo", (Object[])new Object[]{player.method_5477().getString()}).method_10852((class_2561)class_2561.method_43471((String)"text.photochat.click_to_see").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/photochat_open " + photoId.toString()))));
                    for (class_3222 p : server.method_3760().method_14571()) {
                        p.method_7353((class_2561)clickableMessage, false);
                        NetworkHandler.sendPhotoToClientChunked(p, photoId.toString(), fullImageData);
                    }
                    PhotoChat.LOGGER.info(Localization.translate("log.server.processed_broadcasted", photoId));
                } else {
                    PhotoChat.LOGGER.error(Localization.translate("log.server.reassemble_failed", photoId, player.method_5477().getString()));
                }
            });
        });
    }

    public static class_2540 createPhotoBuf(UUID photoUuid, byte[] data) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(photoUuid.toString());
        buf.method_10813(data);
        return buf;
    }

    private static void sendPhotoToClientChunked(class_3222 player, String photoId, byte[] data) {
        int CHUNK_SIZE = 921600;
        int totalChunks = (int)Math.ceil((double)data.length / (double)CHUNK_SIZE);
        class_2540 startBuf = new class_2540(Unpooled.buffer());
        startBuf.method_10814(photoId);
        startBuf.writeInt(totalChunks);
        ServerPlayNetworking.send((class_3222)player, (class_2960)START_DOWNLOAD, (class_2540)startBuf);
        for (int i = 0; i < totalChunks; ++i) {
            int start = i * CHUNK_SIZE;
            int length = Math.min(data.length - start, CHUNK_SIZE);
            byte[] chunkData = new byte[length];
            System.arraycopy(data, start, chunkData, 0, length);
            class_2540 chunkBuf = new class_2540(Unpooled.buffer());
            chunkBuf.method_10814(photoId);
            chunkBuf.writeInt(i);
            chunkBuf.method_10813(chunkData);
            ServerPlayNetworking.send((class_3222)player, (class_2960)DOWNLOAD_CHUNK, (class_2540)chunkBuf);
        }
        class_2540 finishBuf = new class_2540(Unpooled.buffer());
        finishBuf.method_10814(photoId);
        ServerPlayNetworking.send((class_3222)player, (class_2960)FINISH_DOWNLOAD, (class_2540)finishBuf);
    }
}

