/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.util;

import com.bay4lly.photochat.PhotoChat;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Localization {
    private static final Map<String, Map<String, String>> CACHE = new HashMap<String, Map<String, String>>();
    private static final Pattern ENTRY = Pattern.compile("\"(.*?)\"\\s*:\\s*\"(.*?)\"", 32);

    public static String translate(String key, Object ... args) {
        try {
            Class<?> mcClientClass = Class.forName("net.minecraft.client.MinecraftClient");
            Class<?> i18nClass = Class.forName("net.minecraft.client.resource.language.I18n");
            String translated = (String)i18nClass.getMethod("translate", String.class).invoke(null, key);
            if (args != null && args.length > 0) {
                return String.format(translated, args);
            }
            return translated;
        }
        catch (Throwable mcClientClass) {
            String value;
            String lang;
            String fileKey = switch (lang = System.getProperty("user.language", "en")) {
                case "tr" -> "tr_tr";
                case "de" -> "de_de";
                case "fr" -> "fr_fr";
                case "ru" -> "ru_ru";
                case "ja" -> "ja_jp";
                case "ko" -> "ko_kr";
                default -> "en_us";
            };
            Map map = CACHE.get(fileKey);
            if (map == null) {
                map = Localization.loadLangFile(fileKey);
                CACHE.put(fileKey, map);
            }
            if ((value = map.get(key)) == null) {
                if (!fileKey.equals("en_us")) {
                    map = CACHE.computeIfAbsent("en_us", Localization::loadLangFile);
                    value = map.getOrDefault(key, key);
                } else {
                    value = key;
                }
            }
            if (args != null && args.length > 0) {
                try {
                    return String.format(value, args);
                }
                catch (Exception e) {
                    return value;
                }
            }
            return value;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> loadLangFile(String fileKey) {
        HashMap<String, String> out = new HashMap<String, String>();
        String path = "/assets/photochat/lang/" + fileKey + ".json";
        try (InputStream is = Localization.class.getResourceAsStream(path);){
            if (is == null) {
                HashMap<String, String> hashMap = out;
                return hashMap;
            }
            StringBuilder sb = new StringBuilder();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                while ((line = r.readLine()) != null) {
                    sb.append(line).append('\n');
                }
            }
            String content = sb.toString();
            Matcher m = ENTRY.matcher(content);
            while (m.find()) {
                String k = m.group(1);
                String v = m.group(2);
                v = v.replaceAll("\\\\n", "\n").replaceAll("\\\\\"", "\"");
                out.put(k, v);
            }
            return out;
        }
        catch (Exception e) {
            PhotoChat.LOGGER.warn("Failed to load lang file: {}", (Object)fileKey);
        }
        return out;
    }
}

