/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.client;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;

@Environment(value=EnvType.CLIENT)
public class GifDecoder {
    private final List<class_1011> frames = new ArrayList<class_1011>();
    private final List<Integer> delays = new ArrayList<Integer>();

    public GifDecoder(byte[] gifData) throws Exception {
        try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(gifData));){
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("gif");
            if (!readers.hasNext()) {
                throw new IllegalStateException("No GIF ImageReader found");
            }
            ImageReader reader = readers.next();
            reader.setInput(stream);
            int numFrames = reader.getNumImages(true);
            BufferedImage canvas = null;
            for (int i = 0; i < numFrames; ++i) {
                String disposal;
                IIOMetadata metadata = reader.getImageMetadata(i);
                IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
                IIOMetadataNode gce = this.getNode(root, "GraphicControlExtension");
                IIOMetadataNode imgDesc = this.getNode(root, "ImageDescriptor");
                IIOMetadataNode appExts = this.getNode(root, "ApplicationExtensions");
                int delay = this.parseDelayMs(gce);
                this.delays.add(delay);
                int imageLeftPosition = this.parseInt(imgDesc, "imageLeftPosition", 0);
                int imageTopPosition = this.parseInt(imgDesc, "imageTopPosition", 0);
                int imageWidth = this.parseInt(imgDesc, "imageWidth", -1);
                int imageHeight = this.parseInt(imgDesc, "imageHeight", -1);
                if (canvas == null) {
                    int logicalWidth = reader.getWidth(0);
                    int logicalHeight = reader.getHeight(0);
                    canvas = new BufferedImage(logicalWidth, logicalHeight, 2);
                }
                BufferedImage src = reader.read(i);
                Graphics2D g = canvas.createGraphics();
                g.drawImage((Image)src, imageLeftPosition, imageTopPosition, null);
                g.dispose();
                this.frames.add(this.convertToNativeImage(canvas));
                String string = disposal = gce != null ? gce.getAttribute("disposalMethod") : "none";
                if ("restoreToBackgroundColor".equalsIgnoreCase(disposal)) {
                    Graphics2D gb = canvas.createGraphics();
                    gb.setComposite(AlphaComposite.Clear);
                    gb.fillRect(imageLeftPosition, imageTopPosition, imageWidth > 0 ? imageWidth : src.getWidth(), imageHeight > 0 ? imageHeight : src.getHeight());
                    gb.dispose();
                    continue;
                }
                if (!"restoreToPrevious".equalsIgnoreCase(disposal)) continue;
            }
            reader.dispose();
        }
    }

    private class_1011 convertToNativeImage(BufferedImage bufferedImage) throws Exception {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        class_1011 nativeImage = new class_1011(width, height, true);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = bufferedImage.getRGB(x, y);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int abgr = a << 24 | b << 16 | g << 8 | r;
                nativeImage.method_4305(x, y, abgr);
            }
        }
        return nativeImage;
    }

    private int parseDelayMs(IIOMetadataNode gce) {
        try {
            if (gce != null) {
                String delayTime = gce.getAttribute("delayTime");
                int delay = Integer.parseInt(delayTime);
                int ms = delay * 10;
                return ms <= 0 ? 100 : ms;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 100;
    }

    private IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            IIOMetadataNode node = (IIOMetadataNode)rootNode.item(i);
            if (!node.getNodeName().equalsIgnoreCase(nodeName)) continue;
            return node;
        }
        return null;
    }

    private int parseInt(IIOMetadataNode node, String attr, int def) {
        try {
            if (node != null) {
                return Integer.parseInt(node.getAttribute(attr));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public List<class_1011> getFrames() {
        return this.frames;
    }

    public List<Integer> getDelays() {
        return this.delays;
    }
}

