/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.client;

import com.bay4lly.photochat.PhotoChat;
import com.bay4lly.photochat.client.ClientImageManager;
import com.bay4lly.photochat.client.GifDecoder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ImageScreen
extends class_437 {
    private class_2960 textureId;
    private class_1043 texture;
    private final int originalWidth;
    private final int originalHeight;
    private class_1011 imageRef;
    private final boolean isGif;
    private byte[] originalGifData;
    private List<class_1011> gifFrames;
    private List<Integer> frameDelays;
    private int currentFrame = 0;
    private long lastFrameTime;

    public ImageScreen(ClientImageManager.ImageData imageData) {
        super((class_2561)class_2561.method_43471((String)"text.photochat.sent_photo"));
        this.isGif = imageData.isGif();
        if (this.isGif) {
            try {
                this.originalGifData = imageData.getGifData();
                GifDecoder decoder = new GifDecoder(imageData.getGifData());
                List<class_1011> originalFrames = decoder.getFrames();
                this.frameDelays = decoder.getDelays();
                this.gifFrames = new ArrayList<class_1011>();
                for (class_1011 frame : originalFrames) {
                    class_1011 copy = new class_1011(frame.method_4307(), frame.method_4323(), true);
                    copy.method_4317(frame);
                    this.gifFrames.add(copy);
                }
                class_1011 firstFrame = this.gifFrames.get(0);
                class_1011 initialImage = new class_1011(firstFrame.method_4307(), firstFrame.method_4323(), true);
                initialImage.method_4317(firstFrame);
                this.imageRef = initialImage;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.imageRef = imageData.getStaticImage();
                this.gifFrames = List.of(this.imageRef);
                this.frameDelays = List.of(Integer.valueOf(100));
            }
        } else {
            this.imageRef = imageData.getStaticImage();
        }
        this.originalWidth = this.imageRef.method_4307();
        this.originalHeight = this.imageRef.method_4323();
        this.lastFrameTime = System.currentTimeMillis();
        try {
            class_1011 textureImage = new class_1011(this.imageRef.method_4307(), this.imageRef.method_4323(), true);
            textureImage.method_4317(this.imageRef);
            class_1043 tex = new class_1043(textureImage);
            tex.method_4527(false, false);
            this.texture = tex;
            this.textureId = class_310.method_1551().method_1531().method_4617("photochat", tex);
        }
        catch (Exception e) {
            PhotoChat.LOGGER.error("Failed to create texture for image: " + e.getMessage());
            e.printStackTrace();
            try {
                class_1011 fallbackImage = new class_1011(1, 1, true);
                fallbackImage.method_4305(0, 0, -16777216);
                class_1043 tex = new class_1043(fallbackImage);
                tex.method_4527(false, false);
                this.texture = tex;
                this.textureId = class_310.method_1551().method_1531().method_4617("photochat_fallback", tex);
            }
            catch (Exception fallbackException) {
                PhotoChat.LOGGER.error("Failed to create fallback texture: " + fallbackException.getMessage());
                fallbackException.printStackTrace();
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        int buttonWidth = 20;
        int buttonHeight = 20;
        int x = (this.field_22789 - buttonWidth) / 2;
        int y = this.field_22790 - buttonHeight - 10;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2b07"), button -> this.saveImage()).method_46434(x, y, buttonWidth, buttonHeight).method_46431());
    }

    private void saveImage() {
        try {
            File mcFolder = class_310.method_1551().field_1697;
            File downloadFolder = new File(mcFolder, "photochat_downloads");
            if (!downloadFolder.exists()) {
                downloadFolder.mkdirs();
            }
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
            if (this.isGif && this.originalGifData != null) {
                File outFile = new File(downloadFolder, "photo_" + timestamp + ".gif");
                try (FileOutputStream fos = new FileOutputStream(outFile);){
                    fos.write(this.originalGifData);
                }
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"text.photochat.download_success", (Object[])new Object[]{outFile.getAbsolutePath()}), false);
                return;
            }
            File outFile = new File(downloadFolder, "photo_" + timestamp + ".png");
            this.imageRef.method_4325(outFile);
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"text.photochat.download_success", (Object[])new Object[]{outFile.getAbsolutePath()}), false);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"text.photochat.download_failed"), false);
            return;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        if (this.isGif && this.gifFrames != null && !this.gifFrames.isEmpty()) {
            this.updateGifFrame();
        }
        if (this.textureId == null || this.originalWidth <= 0 || this.originalHeight <= 0) {
            context.method_25300(this.field_22793, "Image not available", this.field_22789 / 2, this.field_22790 / 2, 0xFF0000);
            super.method_25394(context, mouseX, mouseY, delta);
            return;
        }
        int maxWidth = this.field_22789 - 80;
        int maxHeight = this.field_22790 - 80;
        boolean isFallback = this.originalWidth == 1 && this.originalHeight == 1;
        int newWidth = maxWidth;
        float aspectRatio = (float)this.originalWidth / (float)this.originalHeight;
        int newHeight = (int)((float)newWidth / aspectRatio);
        if (newHeight > maxHeight) {
            newHeight = maxHeight;
            newWidth = (int)((float)newHeight * aspectRatio);
        }
        int x = (this.field_22789 - newWidth) / 2;
        int y = (this.field_22790 - newHeight) / 2;
        try {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            context.method_25293(this.textureId, x, y, newWidth, newHeight, 0.0f, 0.0f, this.originalWidth, this.originalHeight, this.originalWidth, this.originalHeight);
            RenderSystem.disableBlend();
            if (isFallback) {
                context.method_25300(this.field_22793, "Image loading failed", this.field_22789 / 2, y + newHeight + 20, 0xFF8800);
            }
        }
        catch (Exception e) {
            PhotoChat.LOGGER.error("Failed to render texture: " + e.getMessage());
            context.method_25300(this.field_22793, "Failed to render image", this.field_22789 / 2, this.field_22790 / 2, 0xFF0000);
        }
        context.method_27534(this.field_22793, this.method_25440(), this.field_22789 / 2, 20, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void updateGifFrame() {
        if (this.gifFrames == null || this.gifFrames.size() <= 1) {
            return;
        }
        long now = System.currentTimeMillis();
        int delayMs = 100;
        if (this.frameDelays != null && !this.frameDelays.isEmpty()) {
            delayMs = this.frameDelays.get(Math.max(0, Math.min(this.currentFrame, this.frameDelays.size() - 1)));
        }
        if (now - this.lastFrameTime < (long)delayMs) {
            return;
        }
        this.lastFrameTime = now;
        this.currentFrame = (this.currentFrame + 1) % this.gifFrames.size();
        class_1011 frame = this.gifFrames.get(this.currentFrame);
        if (frame == null) {
            return;
        }
        try {
            if (frame.method_4307() <= 0 || frame.method_4323() <= 0) {
                PhotoChat.LOGGER.warn("Invalid frame dimensions, skipping frame update");
                return;
            }
            if (this.imageRef == null || this.imageRef.method_4307() != frame.method_4307() || this.imageRef.method_4323() != frame.method_4323()) {
                this.imageRef = new class_1011(frame.method_4307(), frame.method_4323(), true);
            }
            this.imageRef.method_4317(frame);
            if (this.texture != null) {
                class_1011 textureImage = new class_1011(frame.method_4307(), frame.method_4323(), true);
                textureImage.method_4317(frame);
                this.texture.method_4526(textureImage);
                this.texture.method_4524();
            } else {
                class_1011 textureImage = new class_1011(frame.method_4307(), frame.method_4323(), true);
                textureImage.method_4317(frame);
                this.texture = new class_1043(textureImage);
                this.texture.method_4527(false, false);
                this.textureId = class_310.method_1551().method_1531().method_4617("photochat_gif", this.texture);
            }
        }
        catch (IllegalStateException e) {
            PhotoChat.LOGGER.error("Failed to update GIF frame: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            PhotoChat.LOGGER.error("Unexpected error updating GIF frame: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void method_25419() {
        class_310.method_1551().method_1531().method_4615(this.textureId);
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }
}

