/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.api;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.api.ColorizeEventHandler;
import pl.panszelescik.colorize.common.api.RightClicker;
import pl.panszelescik.colorize.common.recipes.ColorizeRecipe;

public abstract class BaseBlockHandler {
    private final String key;
    private final Object2ObjectMap<RightClicker, class_2248> blocks;

    protected BaseBlockHandler(@NotNull String key, @NotNull Object2ObjectMap<RightClicker, class_2248> blocks) {
        this.key = key;
        this.blocks = blocks;
    }

    @NotNull
    protected Optional<class_2248> getOldBlock(@NotNull class_2680 state) {
        class_2248 block = state.method_26204();
        return this.blocks.containsValue((Object)block) ? Optional.of(block) : Optional.empty();
    }

    @NotNull
    protected Optional<class_2248> getNewBlock(@NotNull class_1799 stack) {
        return this.blocks.object2ObjectEntrySet().stream().filter(e -> ((RightClicker)e.getKey()).canUse(stack)).findFirst().map(Map.Entry::getValue);
    }

    protected boolean isDisabled() {
        return !ColorizeEventHandler.CONFIG.getBoolean("handlers." + this.key);
    }

    protected boolean requireSneaking() {
        return ColorizeEventHandler.CONFIG.getBoolean("sneaking." + this.key);
    }

    protected boolean consumeItem() {
        return ColorizeEventHandler.CONFIG.getBoolean("consume." + this.key);
    }

    @NotNull
    protected class_3414 getSound() {
        return class_3417.field_14658;
    }

    public boolean handle(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_1799 stack, @NotNull class_1657 player) {
        Optional<class_2248> oldBlock = this.getOldBlock(state);
        if (oldBlock.isEmpty()) {
            return false;
        }
        Optional<class_2248> newBlock = this.getNewBlock(stack);
        if (newBlock.isEmpty()) {
            return false;
        }
        if (oldBlock.equals(newBlock)) {
            return false;
        }
        boolean result = this.replace(level, pos, state, stack, newBlock.get().method_34725(state), player);
        if (result) {
            if (this.consumeItem()) {
                stack.method_7934(1);
            }
            if (!level.method_8608()) {
                level.method_8396(null, pos, this.getSound(), class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        return result;
    }

    protected boolean replace(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_1799 stack, @NotNull class_2680 newState, @NotNull class_1657 player) {
        level.method_8501(pos, newState);
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
        player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
        return true;
    }

    @NotNull
    public Stream<ColorizeRecipe> getRecipes() {
        return this.isDisabled() ? Stream.empty() : this.blocks.object2ObjectEntrySet().stream().filter(e -> !((RightClicker)e.getKey()).isEmpty()).map(entry -> {
            class_2248 block = (class_2248)entry.getValue();
            class_1799 result = new class_1799((class_1935)block);
            List<class_1799> item = ((RightClicker)entry.getKey()).asStackList();
            List<class_1799> validBlocks = this.blocks.object2ObjectEntrySet().stream().filter(e -> e.getValue() != block).map(Map.Entry::getValue).map(class_1799::new).toList();
            return new ColorizeRecipe(validBlocks, item, result, this.requireSneaking(), this.consumeItem());
        });
    }
}

