/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.api.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import pl.panszelescik.colorize.common.api.ColorizeConfig;
import pl.panszelescik.colorize.common.api.config.JsonUtils;

public class BasicConfig
implements ColorizeConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Object2BooleanMap<String> booleans;

    public BasicConfig(@NotNull File configDir) throws IOException {
        File file = new File(configDir, "colorize.json");
        this.booleans = file.exists() ? this.loadConfigFile(file) : this.loadFromJson(new JsonObject());
        this.saveConfig(file);
    }

    @NotNull
    private Object2BooleanMap<String> loadConfigFile(@NotNull File configFile) throws IOException {
        String string = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
        JsonObject json = JsonParser.parseString((String)string).getAsJsonObject();
        return this.loadFromJson(json);
    }

    @NotNull
    private @Unmodifiable Object2BooleanMap<String> loadFromJson(@NotNull JsonObject json) {
        String key;
        Object2BooleanOpenHashMap map = new Object2BooleanOpenHashMap();
        map.defaultReturnValue(false);
        JsonObject handlers = JsonUtils.getJsonObject(json, "handlers").orElseGet(JsonObject::new);
        for (String name : handlersNames) {
            String key2 = ColorizeConfig.formatPath(name);
            map.put((Object)("handlers." + key2), JsonUtils.getBoolean(handlers, key2).orElse(true).booleanValue());
            map.put((Object)("consume." + key2), JsonUtils.getBoolean(handlers, key2).orElse(true).booleanValue());
        }
        JsonObject sneaking = JsonUtils.getJsonObject(json, "sneaking").orElseGet(JsonObject::new);
        for (String name : sneakingFalseKeys) {
            key = ColorizeConfig.formatPath(name);
            map.put((Object)("sneaking." + key), JsonUtils.getBoolean(sneaking, key).orElse(false).booleanValue());
        }
        for (String name : sneakingTrueKeys) {
            key = ColorizeConfig.formatPath(name);
            map.put((Object)("sneaking." + key), JsonUtils.getBoolean(sneaking, key).orElse(true).booleanValue());
        }
        return Object2BooleanMaps.unmodifiable((Object2BooleanMap)map);
    }

    private void saveConfig(@NotNull File configFile) throws IOException {
        JsonObject json = new JsonObject();
        for (Object2BooleanMap.Entry entry : this.booleans.object2BooleanEntrySet()) {
            JsonObject object = json;
            String[] splitted = ((String)entry.getKey()).split("\\.");
            for (int i = 0; i < splitted.length; ++i) {
                String subKey = splitted[i];
                if (i == splitted.length - 1) {
                    object.addProperty(subKey, Boolean.valueOf(entry.getBooleanValue()));
                    continue;
                }
                Optional<JsonObject> subObject = JsonUtils.getJsonObject(object, subKey);
                if (subObject.isEmpty()) {
                    JsonObject newObject = new JsonObject();
                    object.add(subKey, (JsonElement)newObject);
                    object = newObject;
                    continue;
                }
                object = subObject.get();
            }
        }
        String string = GSON.toJson((JsonElement)json);
        FileUtils.writeStringToFile((File)configFile, (String)string, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public boolean getBoolean(@NotNull String key) {
        return this.booleans.getBoolean((Object)key);
    }
}

