/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.api;

import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.api.BaseBlockHandler;
import pl.panszelescik.colorize.common.api.ColorizeConfig;
import pl.panszelescik.colorize.common.api.Colors;
import pl.panszelescik.colorize.common.handler.BannerBlockHandler;
import pl.panszelescik.colorize.common.handler.BedBlockHandler;
import pl.panszelescik.colorize.common.handler.CandleBlockHandler;
import pl.panszelescik.colorize.common.handler.CandleCakeBlockHandler;
import pl.panszelescik.colorize.common.handler.CarpetBlockHandler;
import pl.panszelescik.colorize.common.handler.ConcreteBlockHandler;
import pl.panszelescik.colorize.common.handler.ConcretePowderBlockHandler;
import pl.panszelescik.colorize.common.handler.GlazedTerracottaBlockHandler;
import pl.panszelescik.colorize.common.handler.ShulkerBoxHandler;
import pl.panszelescik.colorize.common.handler.StainedGlassBlockHandler;
import pl.panszelescik.colorize.common.handler.StainedGlassPaneBlockHandler;
import pl.panszelescik.colorize.common.handler.TerracottaBlockHandler;
import pl.panszelescik.colorize.common.handler.WallBannerBlockHandler;
import pl.panszelescik.colorize.common.handler.WoolBlockHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyCobblestoneHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyCobblestoneSlabHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyCobblestoneStairsHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyCobblestoneWallHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyStoneBrickSlabHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyStoneBrickStairsHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyStoneBrickWallHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyStoneBricksHandler;
import pl.panszelescik.colorize.common.recipes.ColorizeRecipe;

public abstract class ColorizeEventHandler {
    public static ColorizeEventHandler INSTANCE;
    public static ColorizeConfig CONFIG;
    private final ObjectImmutableList<BaseBlockHandler> handlers;

    public ColorizeEventHandler(@NotNull ColorizeConfig config) {
        INSTANCE = this;
        CONFIG = config;
        this.handlers = ObjectImmutableList.of((Object[])new BaseBlockHandler[]{new BannerBlockHandler(), new BedBlockHandler(), new CandleBlockHandler(), new CandleCakeBlockHandler(), new CarpetBlockHandler(), new ConcreteBlockHandler(), new ConcretePowderBlockHandler(), new GlazedTerracottaBlockHandler(), new ShulkerBoxHandler(), new StainedGlassBlockHandler(), new StainedGlassPaneBlockHandler(), new TerracottaBlockHandler(), new WallBannerBlockHandler(), new WoolBlockHandler(), new MossyCobblestoneHandler(), new MossyCobblestoneSlabHandler(), new MossyCobblestoneStairsHandler(), new MossyCobblestoneWallHandler(), new MossyStoneBricksHandler(), new MossyStoneBrickSlabHandler(), new MossyStoneBrickStairsHandler(), new MossyStoneBrickWallHandler()});
    }

    public boolean handle(@NotNull Player player, @NotNull Level level, @NotNull InteractionHand hand, @NotNull BlockPos pos) {
        if (this.isForge() && level.isClientSide) {
            return false;
        }
        ItemStack stack = player.getItemInHand(hand);
        BlockState state = level.getBlockState(pos);
        for (BaseBlockHandler handler : this.handlers) {
            if (handler.isDisabled() || handler.requireSneaking() && !player.isShiftKeyDown() || !handler.handle(level, pos, state, stack, player)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Optional<Colors> getDyeColor(@NotNull ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeStack = (DyeItem)item;
            return Optional.of(Colors.getByDyeColor(dyeStack.getDyeColor()));
        }
        return Optional.empty();
    }

    @NotNull
    public abstract Ingredient getColorIngredient(@NotNull Colors var1);

    @NotNull
    public List<ColorizeRecipe> getRecipes() {
        return (List)this.handlers.stream().flatMap(BaseBlockHandler::getRecipes).collect(ObjectImmutableList.toList());
    }

    public boolean isForge() {
        return false;
    }
}

