/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.api;

import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.panszelescik.colorize.common.IngredientUtils;
import pl.panszelescik.colorize.common.api.ColorizeEventHandler;
import pl.panszelescik.colorize.common.api.Colors;

public class RightClicker {
    @Nullable
    private Item item;
    @Nullable
    private TagKey<Item> tag;
    @Nullable
    private Colors color;

    private RightClicker() {
    }

    @NotNull
    public static RightClicker of(@NotNull Item item) {
        RightClicker rightClicker = new RightClicker();
        rightClicker.item = item;
        return rightClicker;
    }

    @NotNull
    public static RightClicker of(@NotNull TagKey<Item> tag) {
        RightClicker rightClicker = new RightClicker();
        rightClicker.tag = tag;
        return rightClicker;
    }

    @NotNull
    public static RightClicker of(@NotNull Colors color) {
        RightClicker rightClicker = new RightClicker();
        rightClicker.color = color;
        return rightClicker;
    }

    public boolean canUse(@NotNull ItemStack stack) {
        if (this.item != null && stack.is(this.item)) {
            return true;
        }
        if (this.tag != null && stack.is(this.tag)) {
            return true;
        }
        if (this.color != null) {
            Optional<Colors> optional = ColorizeEventHandler.INSTANCE.getDyeColor(stack);
            return optional.isPresent() && optional.get() == this.color;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.item == null && this.tag == null && (this.color == null || this.color == Colors.CLEAR);
    }

    @NotNull
    public Ingredient asIngredient() {
        if (this.item != null) {
            return Ingredient.of((ItemLike)this.item);
        }
        if (this.tag != null) {
            return IngredientUtils.createIngredientFromTag(this.tag);
        }
        if (this.color != null) {
            return ColorizeEventHandler.INSTANCE.getColorIngredient(this.color);
        }
        return Ingredient.of((ItemLike[])new ItemLike[0]);
    }
}

