/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.recipes.jei;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.recipes.ColorizeRecipe;

public class ColorizeJEICategory
implements IRecipeCategory<ColorizeRecipe> {
    public static final RecipeType<ColorizeRecipe> RECIPE_TYPE = RecipeType.create((String)"colorize", (String)"colorize", ColorizeRecipe.class);
    private static final Component TITLE = Component.translatable((String)"gui.colorize.jei.name");
    private static final Component SNEAKING = Component.translatable((String)"gui.colorize.jei.sneaking").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    private static final Component CONSUME = Component.translatable((String)"gui.colorize.jei.consume").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    private static final String TEXTURE_GUI_PATH = "textures/jei/gui/";
    private static final String TEXTURE_GUI_VANILLA = "textures/jei/gui/gui_vanilla.png";
    private static final ResourceLocation RECIPE_GUI_VANILLA = ResourceLocation.fromNamespaceAndPath((String)"jei", (String)"textures/jei/gui/gui_vanilla.png");
    private final IDrawableStatic background;
    private final IDrawable icon;

    public ColorizeJEICategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(RECIPE_GUI_VANILLA, 0, 168, 125, 18);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Items.PINK_DYE));
    }

    @NotNull
    public RecipeType<ColorizeRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ColorizeRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotRichTooltipCallback callback = (recipeSlotView, tooltip) -> {
            if (recipe.sneaking()) {
                tooltip.add((FormattedText)SNEAKING);
            }
        };
        IRecipeSlotRichTooltipCallback callback2 = (recipeSlotView, tooltip) -> {
            callback.onRichTooltip(recipeSlotView, tooltip);
            if (recipe.consume()) {
                tooltip.add((FormattedText)CONSUME);
            }
        };
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 1, 1).setSlotName("input").addIngredients(recipe.validBlocks())).addRichTooltipCallback(callback);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 37, 1).setSlotName("item").addIngredients(recipe.item())).addRichTooltipCallback(callback2);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 1).setSlotName("output").addItemStack(recipe.result())).addRichTooltipCallback(callback);
    }
}

