/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.api;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.api.ColorizeEventHandler;
import pl.panszelescik.colorize.common.api.RightClicker;
import pl.panszelescik.colorize.common.recipes.ColorizeRecipe;

public abstract class BaseBlockHandler {
    private final String key;
    private final Object2ObjectMap<RightClicker, Block> blocks;

    protected BaseBlockHandler(@NotNull String key, @NotNull Object2ObjectMap<RightClicker, Block> blocks) {
        this.key = key;
        this.blocks = blocks;
    }

    @NotNull
    protected Optional<Block> getOldBlock(@NotNull BlockState state) {
        Block block = state.getBlock();
        return this.blocks.containsValue((Object)block) ? Optional.of(block) : Optional.empty();
    }

    @NotNull
    protected Optional<Block> getNewBlock(@NotNull ItemStack stack) {
        return this.blocks.object2ObjectEntrySet().stream().filter(e -> ((RightClicker)e.getKey()).canUse(stack)).findFirst().map(Map.Entry::getValue);
    }

    protected boolean isDisabled() {
        return !ColorizeEventHandler.CONFIG.getBoolean("handlers." + this.key);
    }

    protected boolean requireSneaking() {
        return ColorizeEventHandler.CONFIG.getBoolean("sneaking." + this.key);
    }

    protected boolean consumeItem() {
        return ColorizeEventHandler.CONFIG.getBoolean("consume." + this.key);
    }

    @NotNull
    protected SoundEvent getSound() {
        return SoundEvents.STONE_HIT;
    }

    public boolean handle(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ItemStack stack, @NotNull Player player) {
        Optional<Block> oldBlock = this.getOldBlock(state);
        if (oldBlock.isEmpty()) {
            return false;
        }
        Optional<Block> newBlock = this.getNewBlock(stack);
        if (newBlock.isEmpty()) {
            return false;
        }
        if (oldBlock.equals(newBlock)) {
            return false;
        }
        boolean result = this.replace(level, pos, state, stack, newBlock.get().withPropertiesOf(state), player);
        if (result) {
            if (this.consumeItem()) {
                stack.shrink(1);
            }
            if (!level.isClientSide()) {
                level.playSound(null, pos, this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return result;
    }

    protected boolean replace(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ItemStack stack, @NotNull BlockState newState, @NotNull Player player) {
        level.setBlockAndUpdate(pos, newState);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        return true;
    }

    @NotNull
    public Stream<ColorizeRecipe> getRecipes() {
        return this.isDisabled() ? Stream.empty() : this.blocks.object2ObjectEntrySet().stream().filter(e -> !((RightClicker)e.getKey()).isEmpty()).map(entry -> {
            Block block = (Block)entry.getValue();
            ItemStack result = new ItemStack((ItemLike)block);
            List<ItemStack> item = ((RightClicker)entry.getKey()).asStackList();
            List<ItemStack> validBlocks = this.blocks.object2ObjectEntrySet().stream().filter(e -> e.getValue() != block).map(Map.Entry::getValue).map(ItemStack::new).toList();
            return new ColorizeRecipe(validBlocks, item, result, this.requireSneaking(), this.consumeItem());
        });
    }
}

