/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.api;

import java.util.Arrays;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Colors {
    CLEAR(null),
    WHITE(DyeColor.WHITE),
    ORANGE(DyeColor.ORANGE),
    MAGENTA(DyeColor.MAGENTA),
    LIGHT_BLUE(DyeColor.LIGHT_BLUE),
    YELLOW(DyeColor.YELLOW),
    LIME(DyeColor.LIME),
    PINK(DyeColor.PINK),
    GRAY(DyeColor.GRAY),
    LIGHT_GRAY(DyeColor.LIGHT_GRAY),
    CYAN(DyeColor.CYAN),
    PURPLE(DyeColor.PURPLE),
    BLUE(DyeColor.BLUE),
    BROWN(DyeColor.BROWN),
    GREEN(DyeColor.GREEN),
    RED(DyeColor.RED),
    BLACK(DyeColor.BLACK);

    @Nullable
    private final DyeColor dyeColor;

    private Colors(DyeColor dyeColor) {
        this.dyeColor = dyeColor;
    }

    @NotNull
    public String getName() {
        DyeColor dyeColor = this.getDyeColor();
        if (dyeColor == null) {
            return "";
        }
        return dyeColor.getName();
    }

    @Nullable
    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    @Nullable
    public TagKey<Item> getCommonTag() {
        DyeColor dyeColor = this.getDyeColor();
        if (dyeColor == null) {
            return null;
        }
        return TagKey.create((ResourceKey)Registries.ITEM, (Identifier)Identifier.fromNamespaceAndPath((String)"c", (String)("dyes/" + dyeColor.getName())));
    }

    @NotNull
    public static Colors getByDyeColor(@Nullable DyeColor dyeColor) {
        return Arrays.stream(Colors.values()).filter(x -> x.getDyeColor() == dyeColor).findFirst().orElse(CLEAR);
    }
}

