/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.api;

import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.api.BaseBlockHandler;
import pl.panszelescik.colorize.common.api.ColorizeConfig;
import pl.panszelescik.colorize.common.api.Colors;
import pl.panszelescik.colorize.common.handler.BannerBlockHandler;
import pl.panszelescik.colorize.common.handler.BedBlockHandler;
import pl.panszelescik.colorize.common.handler.CandleBlockHandler;
import pl.panszelescik.colorize.common.handler.CandleCakeBlockHandler;
import pl.panszelescik.colorize.common.handler.CarpetBlockHandler;
import pl.panszelescik.colorize.common.handler.ConcreteBlockHandler;
import pl.panszelescik.colorize.common.handler.ConcretePowderBlockHandler;
import pl.panszelescik.colorize.common.handler.GlazedTerracottaBlockHandler;
import pl.panszelescik.colorize.common.handler.ShulkerBoxHandler;
import pl.panszelescik.colorize.common.handler.StainedGlassBlockHandler;
import pl.panszelescik.colorize.common.handler.StainedGlassPaneBlockHandler;
import pl.panszelescik.colorize.common.handler.TerracottaBlockHandler;
import pl.panszelescik.colorize.common.handler.WallBannerBlockHandler;
import pl.panszelescik.colorize.common.handler.WoolBlockHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyCobblestoneHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyCobblestoneSlabHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyCobblestoneStairsHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyCobblestoneWallHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyStoneBrickSlabHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyStoneBrickStairsHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyStoneBrickWallHandler;
import pl.panszelescik.colorize.common.handler.moss.MossyStoneBricksHandler;
import pl.panszelescik.colorize.common.recipes.ColorizeRecipe;

public abstract class ColorizeEventHandler {
    public static ColorizeEventHandler INSTANCE;
    public static ColorizeConfig CONFIG;
    private final ObjectImmutableList<BaseBlockHandler> handlers;

    public ColorizeEventHandler(@NotNull ColorizeConfig config) {
        INSTANCE = this;
        CONFIG = config;
        this.handlers = ObjectImmutableList.of((Object[])new BaseBlockHandler[]{new BannerBlockHandler(), new BedBlockHandler(), new CandleBlockHandler(), new CandleCakeBlockHandler(), new CarpetBlockHandler(), new ConcreteBlockHandler(), new ConcretePowderBlockHandler(), new GlazedTerracottaBlockHandler(), new ShulkerBoxHandler(), new StainedGlassBlockHandler(), new StainedGlassPaneBlockHandler(), new TerracottaBlockHandler(), new WallBannerBlockHandler(), new WoolBlockHandler(), new MossyCobblestoneHandler(), new MossyCobblestoneSlabHandler(), new MossyCobblestoneStairsHandler(), new MossyCobblestoneWallHandler(), new MossyStoneBricksHandler(), new MossyStoneBrickSlabHandler(), new MossyStoneBrickStairsHandler(), new MossyStoneBrickWallHandler()});
    }

    public boolean handle(@NotNull class_1657 player, @NotNull class_1937 level, @NotNull class_1268 hand, @NotNull class_2338 pos) {
        if (this.isForge() && level.method_8608()) {
            return false;
        }
        class_1799 stack = player.method_5998(hand);
        class_2680 state = level.method_8320(pos);
        for (BaseBlockHandler handler : this.handlers) {
            if (handler.isDisabled() || handler.requireSneaking() && !player.method_5715() || !handler.handle(level, pos, state, stack, player)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Optional<Colors> getDyeColor(@NotNull class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dyeStack = (class_1769)class_17922;
            return Optional.of(Colors.getByDyeColor(dyeStack.method_7802()));
        }
        return Optional.empty();
    }

    @NotNull
    public abstract List<class_1799> getColorItemStacks(@NotNull Colors var1);

    @NotNull
    public List<ColorizeRecipe> getRecipes() {
        return (List)this.handlers.stream().flatMap(BaseBlockHandler::getRecipes).collect(ObjectImmutableList.toList());
    }

    public boolean isForge() {
        return false;
    }
}

