package pl.panszelescik.colorize.forge;

import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.Colorize;

@Mod(Colorize.MODID)
public class ColorizeForge {

    private final ColorizeForgeHandler handler = new ColorizeForgeHandler(ColorizeForgeConfig.CONFIG);

    public ColorizeForge(FMLJavaModLoadingContext modLoadingContext) {
        PlayerInteractEvent.RightClickBlock.BUS.addListener(this::onRightClickBlock);

        modLoadingContext.registerConfig(ModConfig.Type.COMMON, ColorizeForgeConfig.SPEC);
    }

    private boolean onRightClickBlock(@NotNull PlayerInteractEvent.RightClickBlock event) {
        return this.handler.handle(event.getEntity(), event.getLevel(), event.getHand(), event.getPos());
    }
}
