/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.api;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.IngredientUtils;
import pl.panszelescik.colorize.common.api.ColorizeConfig;
import pl.panszelescik.colorize.common.api.ColorizeEventHandler;
import pl.panszelescik.colorize.common.api.Colors;

public class ColorizeCommonTagEventHandler
extends ColorizeEventHandler {
    private final Object2ObjectMap<Colors, TagKey<Item>> tags;

    public ColorizeCommonTagEventHandler(@NotNull ColorizeConfig config) {
        super(config);
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (Colors c : Colors.values()) {
            TagKey<Item> tag = c.getCommonTag();
            if (tag == null) continue;
            map.put((Object)c, tag);
        }
        this.tags = Object2ObjectMaps.unmodifiable((Object2ObjectMap)map);
    }

    @Override
    @NotNull
    protected Optional<Colors> getDyeColor(@NotNull ItemStack stack) {
        Optional<Colors> optional = super.getDyeColor(stack);
        if (optional.isPresent()) {
            return optional;
        }
        return this.tags.object2ObjectEntrySet().stream().filter(e -> stack.is((TagKey)e.getValue())).findFirst().map(Map.Entry::getKey);
    }

    @Override
    @NotNull
    public List<ItemStack> getColorItemStacks(@NotNull Colors color) {
        return this.tags.object2ObjectEntrySet().stream().filter(e -> e.getKey() == color).findFirst().stream().flatMap(t -> IngredientUtils.getItemStacksInTag((TagKey<Item>)((TagKey)t.getValue()))).toList();
    }
}

