/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.forge;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.api.ColorizeConfig;

public class ColorizeForgeConfig
implements ColorizeConfig {
    private final Object2ObjectMap<String, ForgeConfigSpec.BooleanValue> booleans;
    public static final ColorizeForgeConfig CONFIG;
    public static final ForgeConfigSpec SPEC;

    public ColorizeForgeConfig(@NotNull ForgeConfigSpec.Builder builder) {
        String key;
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        builder.comment("Handlers settings");
        builder.push("handlers");
        for (String name : sneakingFalseKeys) {
            key = ColorizeConfig.formatPath(name);
            map.put((Object)("handlers." + key), (Object)ColorizeForgeConfig.handler(builder, key, name));
        }
        for (String name : sneakingTrueKeys) {
            key = ColorizeConfig.formatPath(name);
            map.put((Object)("handlers." + key), (Object)ColorizeForgeConfig.handlerMossy(builder, key, name));
        }
        builder.pop();
        builder.comment("Sneaking settings");
        builder.push("sneaking");
        for (String name : sneakingFalseKeys) {
            key = ColorizeConfig.formatPath(name);
            map.put((Object)("sneaking." + key), (Object)ColorizeForgeConfig.sneaking(builder, key, name, false));
        }
        for (String name : sneakingTrueKeys) {
            key = ColorizeConfig.formatPath(name);
            map.put((Object)("sneaking." + key), (Object)ColorizeForgeConfig.sneaking(builder, key, name, true));
        }
        builder.pop();
        builder.comment("Consume item settings");
        builder.push("consume");
        for (String name : handlersNames) {
            key = ColorizeConfig.formatPath(name);
            map.put((Object)("consume." + key), (Object)ColorizeForgeConfig.consume(builder, key, name));
        }
        builder.pop();
        this.booleans = Object2ObjectMaps.unmodifiable((Object2ObjectMap)map);
    }

    @NotNull
    private static ForgeConfigSpec.BooleanValue handler(@NotNull ForgeConfigSpec.Builder builder, @NotNull String key, @NotNull String name) {
        return builder.comment("Enable colorizing " + name + " using one of valid dyes").define(key, true);
    }

    @NotNull
    private static ForgeConfigSpec.BooleanValue handlerMossy(@NotNull ForgeConfigSpec.Builder builder, @NotNull String key, @NotNull String name) {
        return builder.comment("Enable colorizing " + name + " to Mossy variant using Vines").define(key, true);
    }

    @NotNull
    private static ForgeConfigSpec.BooleanValue sneaking(@NotNull ForgeConfigSpec.Builder builder, @NotNull String key, @NotNull String name, boolean defaultValue) {
        return builder.comment("Require sneaking for colorizing " + name).define(key, defaultValue);
    }

    @NotNull
    private static ForgeConfigSpec.BooleanValue consume(@NotNull ForgeConfigSpec.Builder builder, @NotNull String key, @NotNull String name) {
        return builder.comment("Enable consuming item when colorizing " + name).define(key, true);
    }

    @Override
    public boolean getBoolean(@NotNull String key) {
        ForgeConfigSpec.BooleanValue value = (ForgeConfigSpec.BooleanValue)this.booleans.get((Object)key);
        return value != null ? (Boolean)value.get() : false;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ColorizeForgeConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (ColorizeForgeConfig)specPair.getLeft();
    }
}

