package pl.panszelescik.colorize.common.api;

import Z;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.recipes.ColorizeRecipe;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5712;

public abstract class BaseBlockHandler {

    private final String key;
    private final Object2ObjectMap<RightClicker, class_2248> blocks;

    protected BaseBlockHandler(@NotNull String key, @NotNull Object2ObjectMap<RightClicker, class_2248> blocks) {
        this.key = key;
        this.blocks = blocks;
    }

    protected @NotNull Optional<class_2248> getOldBlock(@NotNull class_2680 state) {
        var block = state.method_26204();
        return this.blocks.containsValue(block) ? Optional.of(block) : Optional.empty();
    }

    protected @NotNull Optional<class_2248> getNewBlock(@NotNull class_1799 stack) {
        return this.blocks
                .object2ObjectEntrySet()
                .stream()
                .filter(e -> e.getKey().canUse(stack))
                .findFirst()
                .map(Map.Entry::getValue);
    }

    protected boolean isDisabled() {
        return !ColorizeEventHandler.CONFIG.getBoolean("handlers." + key);
    }

    protected boolean requireSneaking() {
        return ColorizeEventHandler.CONFIG.getBoolean("sneaking." + key);
    }

    protected boolean consumeItem() {
        return ColorizeEventHandler.CONFIG.getBoolean("consume." + key);
    }

    protected @NotNull class_3414 getSound() {
        return class_3417.field_14658;
    }

    public boolean handle(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_1799 stack, @NotNull class_1657 player) {
        var oldBlock = this.getOldBlock(state);
        if (oldBlock.isEmpty()) {
            return false;
        }

        var newBlock = this.getNewBlock(stack);
        if (newBlock.isEmpty()) {
            return false;
        }

        if (oldBlock.equals(newBlock)) {
            return false;
        }

        var result = this.replace(level, pos, state, stack, newBlock.get().method_34725(state), player);
        if (result) {
            if (this.consumeItem()) {
                stack.method_7934(1);
            }
            if (!level.method_8608()) {
                level.method_8396(null, pos, this.getSound(), class_3419.field_15245, 1f, 1f);
            }
        }

        return result;
    }

    protected boolean replace(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_1799 stack, @NotNull class_2680 newState, @NotNull class_1657 player) {
        level.method_8501(pos, newState);
        level.method_33596(player, class_5712.field_28733, pos);

        player.method_7259(class_3468.field_15372.method_14956(stack.method_7909()));

        return true;
    }

    public @NotNull Stream<ColorizeRecipe> getRecipes() {
        return this.isDisabled() ? Stream.empty() : this.blocks
                .object2ObjectEntrySet()
                .stream()
                .filter(e -> !e.getKey().isEmpty())
                .map(entry -> {
                    var block = entry.getValue();
                    var result = new class_1799(block);
                    var item = entry.getKey().asStackList();
                    var validBlocks = this.blocks
                            .object2ObjectEntrySet()
                            .stream()
                            .filter(e -> e.getValue() != block)
                            .map(Map.Entry::getValue)
                            .map(class_1799::new)
                            .toList();

                    return new ColorizeRecipe(validBlocks, item, result, this.requireSneaking(), this.consumeItem());
                });
    }
}
