package pl.panszelescik.colorize.common.api;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.IngredientUtils;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6862;

public class ColorizeCommonTagEventHandler extends ColorizeEventHandler {

    private final Object2ObjectMap<Colors, class_6862<class_1792>> tags;

    public ColorizeCommonTagEventHandler(@NotNull ColorizeConfig config) {
        super(config);
        var map = new Object2ObjectOpenHashMap<Colors, class_6862<class_1792>>();

        for (var c : Colors.values()) {
            var tag = c.getCommonTag();
            if (tag == null) {
                continue;
            }

            map.put(c, tag);
        }

        this.tags = Object2ObjectMaps.unmodifiable(map);
    }

    @Override
    protected @NotNull Optional<Colors> getDyeColor(@NotNull class_1799 stack) {
        var optional = super.getDyeColor(stack);
        if (optional.isPresent()) {
            return optional;
        }

        return this.tags
                .object2ObjectEntrySet()
                .stream()
                .filter(e -> stack.method_31573(e.getValue()))
                .findFirst()
                .map(Map.Entry::getKey);
    }

    public @NotNull List<class_1799> getColorItemStacks(@NotNull Colors color) {
        return this.tags
                .object2ObjectEntrySet()
                .stream()
                .filter(e -> e.getKey() == color)
                .findFirst()
                .stream()
                .flatMap(t -> IngredientUtils.getItemStacksInTag(t.getValue()))
                .toList();
    }
}
