package pl.panszelescik.colorize.common.api;

import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.handler.*;
import pl.panszelescik.colorize.common.handler.moss.*;
import pl.panszelescik.colorize.common.recipes.ColorizeRecipe;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public abstract class ColorizeEventHandler {

    public static ColorizeEventHandler INSTANCE;
    public static ColorizeConfig CONFIG;
    private final ObjectImmutableList<BaseBlockHandler> handlers;

    public ColorizeEventHandler(@NotNull ColorizeConfig config) {
        INSTANCE = this;
        CONFIG = config;

        this.handlers = ObjectImmutableList.of(
                new BannerBlockHandler(),
                new BedBlockHandler(),
                new CandleBlockHandler(),
                new CandleCakeBlockHandler(),
                new CarpetBlockHandler(),
                new ConcreteBlockHandler(),
                new ConcretePowderBlockHandler(),
                new GlazedTerracottaBlockHandler(),
                new ShulkerBoxHandler(),
                new StainedGlassBlockHandler(),
                new StainedGlassPaneBlockHandler(),
                new TerracottaBlockHandler(),
                new WallBannerBlockHandler(),
                new WoolBlockHandler(),

                new MossyCobblestoneHandler(),
                new MossyCobblestoneSlabHandler(),
                new MossyCobblestoneStairsHandler(),
                new MossyCobblestoneWallHandler(),
                new MossyStoneBricksHandler(),
                new MossyStoneBrickSlabHandler(),
                new MossyStoneBrickStairsHandler(),
                new MossyStoneBrickWallHandler()
        );
    }

    public boolean handle(@NotNull class_1657 player, @NotNull class_1937 level, @NotNull class_1268 hand, @NotNull class_2338 pos) {
        if (this.isForge() && level.method_8608()) {
            return false;
        }

        var stack = player.method_5998(hand);
        var state = level.method_8320(pos);
        for (var handler : handlers) {
            if (handler.isDisabled()) {
                continue;
            }

            if (handler.requireSneaking() && !player.method_5715()) {
                continue;
            }

            if (handler.handle(level, pos, state, stack, player)) {
                return true;
            }
        }

        return false;
    }

    protected @NotNull Optional<Colors> getDyeColor(@NotNull class_1799 stack) {
        if (stack.method_7909() instanceof class_1769 dyeStack) {
            return Optional.of(Colors.getByDyeColor(dyeStack.method_7802()));
        }
        return Optional.empty();
    }

    public abstract @NotNull List<class_1799> getColorItemStacks(@NotNull Colors color);

    public @NotNull List<ColorizeRecipe> getRecipes() {
        return this.handlers
                .stream()
                .flatMap(BaseBlockHandler::getRecipes)
                .collect(ObjectImmutableList.toList());
    }

    public boolean isForge() {
        return false;
    }
}
