package pl.panszelescik.colorize.common.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public enum Colors {

    CLEAR(null),
    WHITE(class_1767.field_7952),
    ORANGE(class_1767.field_7946),
    MAGENTA(class_1767.field_7958),
    LIGHT_BLUE(class_1767.field_7951),
    YELLOW(class_1767.field_7947),
    LIME(class_1767.field_7961),
    PINK(class_1767.field_7954),
    GRAY(class_1767.field_7944),
    LIGHT_GRAY(class_1767.field_7967),
    CYAN(class_1767.field_7955),
    PURPLE(class_1767.field_7945),
    BLUE(class_1767.field_7966),
    BROWN(class_1767.field_7957),
    GREEN(class_1767.field_7942),
    RED(class_1767.field_7964),
    BLACK(class_1767.field_7963),
    ;

    private final @Nullable class_1767 dyeColor;

    Colors(@Nullable class_1767 dyeColor) {
        this.dyeColor = dyeColor;
    }

    public @NotNull String getName() {
        var dyeColor = this.getDyeColor();
        if (dyeColor == null) {
            return "";
        }
        return dyeColor.method_7792();
    }

    public @Nullable class_1767 getDyeColor() {
        return this.dyeColor;
    }

    public @Nullable class_6862<class_1792> getCommonTag() {
        var dyeColor = this.getDyeColor();
        if (dyeColor == null) {
            return null;
        }
        return class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("c", "dyes/" + dyeColor.method_7792()));
    }

    public static @NotNull Colors getByDyeColor(@Nullable class_1767 dyeColor) {
        return Arrays
                .stream(Colors.values())
                .filter(x -> x.getDyeColor() == dyeColor)
                .findFirst()
                .orElse(Colors.CLEAR);
    }
}
