package pl.panszelescik.colorize.common.api.handler;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.api.BaseBlockHandler;
import pl.panszelescik.colorize.common.api.RightClicker;

public abstract class BaseBlockEntityHandler<T extends class_2586> extends BaseBlockHandler {

    private final @NotNull Class<T> clazz;

    protected BaseBlockEntityHandler(@NotNull String key, @NotNull Object2ObjectMap<RightClicker, class_2248> blocks, @NotNull Class<T> clazz) {
        super(key, blocks);
        this.clazz = clazz;
    }

    @Override
    protected boolean replace(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_1799 stack, @NotNull class_2680 newState, @NotNull class_1657 player) {
        var blockEntity = level.method_8321(pos);
        if (this.clazz.isInstance(blockEntity)) {
            var components = blockEntity.method_57590();

            super.replace(level, pos, state, stack, newState.method_26204().method_34725(state), player);

            var newBlockEntity = level.method_8321(pos);
            if (this.clazz.isInstance(newBlockEntity)) {
                newBlockEntity.method_58685(components, class_9326.field_49588);
                newBlockEntity.method_5431();
                return true;
            }
        }

        return false;
    }
}
