package pl.panszelescik.colorize.common.handler;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.api.Colors;
import pl.panszelescik.colorize.common.api.RightClicker;
import pl.panszelescik.colorize.common.api.RightClicker2BlockMap;
import pl.panszelescik.colorize.common.api.handler.WoollyBlockHandler;

public class BedBlockHandler extends WoollyBlockHandler {

    public BedBlockHandler() {
        super("bed", BEDS);
    }

    @Override
    public boolean replace(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_1799 stack, @NotNull class_2680 newState, @NotNull class_1657 player) {
        var part = state.method_11654(class_2244.field_9967);
        var direction = state.method_11654(class_2244.field_11177);
        var pos2 = pos.method_10093(part == class_2742.field_12557 ? direction : direction.method_10153());

        var footPos = part == class_2742.field_12557 ? pos : pos2;
        var headPos = part == class_2742.field_12557 ? pos2 : pos;

        var footBlockState = level.method_8320(footPos);
        var headBlockState = level.method_8320(headPos);

        level.method_8650(headPos, false);
        level.method_8650(footPos, false);

        level.method_8652(footPos, newState.method_26204().method_34725(footBlockState), 0);
        level.method_8652(headPos, newState.method_26204().method_34725(headBlockState), 0);

        level.method_33596(player, class_5712.field_28733, headPos);
        level.method_33596(player, class_5712.field_28733, footPos);

        player.method_7259(class_3468.field_15372.method_14956(stack.method_7909()));

        return true;
    }

    private static final Object2ObjectMap<RightClicker, class_2248> BEDS;

    static {
        var map = new RightClicker2BlockMap(16);

        map.put(Colors.WHITE, class_2246.field_10120);
        map.put(Colors.ORANGE, class_2246.field_10410);
        map.put(Colors.MAGENTA, class_2246.field_10230);
        map.put(Colors.LIGHT_BLUE, class_2246.field_10621);
        map.put(Colors.YELLOW, class_2246.field_10356);
        map.put(Colors.LIME, class_2246.field_10180);
        map.put(Colors.PINK, class_2246.field_10610);
        map.put(Colors.GRAY, class_2246.field_10141);
        map.put(Colors.LIGHT_GRAY, class_2246.field_10326);
        map.put(Colors.CYAN, class_2246.field_10109);
        map.put(Colors.PURPLE, class_2246.field_10019);
        map.put(Colors.BLUE, class_2246.field_10527);
        map.put(Colors.BROWN, class_2246.field_10288);
        map.put(Colors.GREEN, class_2246.field_10561);
        map.put(Colors.RED, class_2246.field_10069);
        map.put(Colors.BLACK, class_2246.field_10461);

        BEDS = map.freeze();
    }
}
