package pl.panszelescik.colorize.common.handler;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.api.BaseBlockHandler;
import pl.panszelescik.colorize.common.api.Colors;
import pl.panszelescik.colorize.common.api.RightClicker;
import pl.panszelescik.colorize.common.api.RightClicker2BlockMap;
import pl.panszelescik.colorize.common.recipes.ColorizeRecipe;

import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class CandleCakeBlockHandler extends BaseBlockHandler {

    public CandleCakeBlockHandler() {
        super("candle", CANDLE_CAKES);
    }

    @Override
    protected @NotNull class_3414 getSound() {
        return class_3417.field_26957;
    }

    @Override
    public @NotNull Stream<ColorizeRecipe> getRecipes() {
        return Stream.empty(); // Don't duplicate recipes
    }

    private static final Object2ObjectMap<RightClicker, class_2248> CANDLE_CAKES;

    static {
        var map = new RightClicker2BlockMap(17);

        map.put(Colors.CLEAR, class_2246.field_27142);
        map.put(Colors.WHITE, class_2246.field_27143);
        map.put(Colors.ORANGE, class_2246.field_27144);
        map.put(Colors.MAGENTA, class_2246.field_27145);
        map.put(Colors.LIGHT_BLUE, class_2246.field_27146);
        map.put(Colors.YELLOW, class_2246.field_27147);
        map.put(Colors.LIME, class_2246.field_27148);
        map.put(Colors.PINK, class_2246.field_27149);
        map.put(Colors.GRAY, class_2246.field_27150);
        map.put(Colors.LIGHT_GRAY, class_2246.field_27151);
        map.put(Colors.CYAN, class_2246.field_27152);
        map.put(Colors.PURPLE, class_2246.field_27153);
        map.put(Colors.BLUE, class_2246.field_27154);
        map.put(Colors.BROWN, class_2246.field_27155);
        map.put(Colors.GREEN, class_2246.field_27156);
        map.put(Colors.RED, class_2246.field_27157);
        map.put(Colors.BLACK, class_2246.field_27158);

        CANDLE_CAKES = map.freeze();
    }
}
