package pl.panszelescik.colorize.common.handler;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.api.RightClicker;
import pl.panszelescik.colorize.common.api.handler.BaseBlockEntityHandler;
import pl.panszelescik.colorize.common.api.Colors;
import pl.panszelescik.colorize.common.api.RightClicker2BlockMap;
import pl.panszelescik.colorize.common.recipes.ColorizeRecipe;

import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2573;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class WallBannerBlockHandler extends BaseBlockEntityHandler<class_2573> {

    public WallBannerBlockHandler() {
        super("banner", WALL_BANNERS, class_2573.class);
    }

    @Override
    protected @NotNull class_3414 getSound() {
        return class_3417.field_14628;
    }

    @Override
    public @NotNull Stream<ColorizeRecipe> getRecipes() {
        return Stream.empty(); // Don't duplicate recipes
    }

    private static final Object2ObjectMap<RightClicker, class_2248> WALL_BANNERS;

    static {
        var map = new RightClicker2BlockMap(16);

        map.put(Colors.WHITE, class_2246.field_10202);
        map.put(Colors.ORANGE, class_2246.field_10599);
        map.put(Colors.MAGENTA, class_2246.field_10274);
        map.put(Colors.LIGHT_BLUE, class_2246.field_10050);
        map.put(Colors.YELLOW, class_2246.field_10139);
        map.put(Colors.LIME, class_2246.field_10318);
        map.put(Colors.PINK, class_2246.field_10531);
        map.put(Colors.GRAY, class_2246.field_10267);
        map.put(Colors.LIGHT_GRAY, class_2246.field_10604);
        map.put(Colors.CYAN, class_2246.field_10372);
        map.put(Colors.PURPLE, class_2246.field_10054);
        map.put(Colors.BLUE, class_2246.field_10067);
        map.put(Colors.BROWN, class_2246.field_10370);
        map.put(Colors.GREEN, class_2246.field_10594);
        map.put(Colors.RED, class_2246.field_10279);
        map.put(Colors.BLACK, class_2246.field_10537);

        WALL_BANNERS = map.freeze();
    }
}
