/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.api;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.panszelescik.colorize.common.IngredientUtils;
import pl.panszelescik.colorize.common.api.ColorizeEventHandler;
import pl.panszelescik.colorize.common.api.Colors;

public class RightClicker {
    @Nullable
    private class_1792 item;
    @Nullable
    private class_6862<class_1792> tag;
    @Nullable
    private Colors color;

    private RightClicker() {
    }

    @NotNull
    public static RightClicker of(@NotNull class_1792 item) {
        RightClicker rightClicker = new RightClicker();
        rightClicker.item = item;
        return rightClicker;
    }

    @NotNull
    public static RightClicker of(@NotNull class_6862<class_1792> tag) {
        RightClicker rightClicker = new RightClicker();
        rightClicker.tag = tag;
        return rightClicker;
    }

    @NotNull
    public static RightClicker of(@NotNull Colors color) {
        RightClicker rightClicker = new RightClicker();
        rightClicker.color = color;
        return rightClicker;
    }

    public boolean canUse(@NotNull class_1799 stack) {
        if (this.item != null && stack.method_31574(this.item)) {
            return true;
        }
        if (this.tag != null && stack.method_31573(this.tag)) {
            return true;
        }
        if (this.color != null) {
            Optional<Colors> optional = ColorizeEventHandler.INSTANCE.getDyeColor(stack);
            return optional.isPresent() && optional.get() == this.color;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.item == null && this.tag == null && (this.color == null || this.color == Colors.CLEAR);
    }

    @NotNull
    public List<class_1799> asStackList() {
        if (this.item != null) {
            return List.of(new class_1799((class_1935)this.item));
        }
        if (this.tag != null) {
            return IngredientUtils.getItemStacksInTag(this.tag).toList();
        }
        if (this.color != null) {
            return ColorizeEventHandler.INSTANCE.getColorItemStacks(this.color);
        }
        return List.of();
    }
}

