/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.api.handler;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import pl.panszelescik.colorize.common.api.BaseBlockHandler;
import pl.panszelescik.colorize.common.api.RightClicker;

public abstract class BaseBlockEntityHandler<T extends BlockEntity>
extends BaseBlockHandler {
    @NotNull
    private final Class<T> clazz;

    protected BaseBlockEntityHandler(@NotNull String key, @NotNull Object2ObjectMap<RightClicker, Block> blocks, @NotNull Class<T> clazz) {
        super(key, blocks);
        this.clazz = clazz;
    }

    @Override
    protected boolean replace(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ItemStack stack, @NotNull BlockState newState, @NotNull Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (this.clazz.isInstance(blockEntity)) {
            DataComponentMap components = blockEntity.collectComponents();
            super.replace(level, pos, state, stack, newState.getBlock().withPropertiesOf(state), player);
            BlockEntity newBlockEntity = level.getBlockEntity(pos);
            if (this.clazz.isInstance(newBlockEntity)) {
                newBlockEntity.applyComponents(components, DataComponentPatch.EMPTY);
                newBlockEntity.setChanged();
                return true;
            }
        }
        return false;
    }
}

