/*
 * Decompiled with CFR 0.152.
 */
package pl.panszelescik.colorize.common.recipes.jei;

import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import pl.panszelescik.colorize.common.recipes.ColorizeRecipe;

public class ColorizeJEICategory
extends AbstractRecipeCategory<ColorizeRecipe> {
    public static final IRecipeType<ColorizeRecipe> RECIPE_TYPE = IRecipeType.create((String)"colorize", (String)"colorize", ColorizeRecipe.class);
    private static final Component TITLE = Component.translatable((String)"gui.colorize.jei.name");
    private static final Component SNEAKING = Component.translatable((String)"gui.colorize.jei.sneaking").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    private static final Component CONSUME = Component.translatable((String)"gui.colorize.jei.consume").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);

    public ColorizeJEICategory(IGuiHelper guiHelper) {
        super(RECIPE_TYPE, TITLE, guiHelper.createDrawableItemLike((ItemLike)Items.PINK_DYE), 125, 18);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ColorizeRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotRichTooltipCallback callback = (recipeSlotView, tooltip) -> {
            if (recipe.sneaking()) {
                tooltip.add((FormattedText)SNEAKING);
            }
        };
        IRecipeSlotRichTooltipCallback callback2 = (recipeSlotView, tooltip) -> {
            callback.onRichTooltip(recipeSlotView, tooltip);
            if (recipe.consume()) {
                tooltip.add((FormattedText)CONSUME);
            }
        };
        List<ItemStack> leftInputs = recipe.validBlocks();
        List<ItemStack> rightInputs = recipe.item();
        ItemStack outputs = recipe.result();
        IRecipeSlotBuilder leftInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CRAFTING_STATION, 1, 1).setSlotName("input").addItemStacks(leftInputs)).addRichTooltipCallback(callback).setStandardSlotBackground();
        IRecipeSlotBuilder rightInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).setSlotName("item").addItemStacks(rightInputs)).addRichTooltipCallback(callback2).setStandardSlotBackground();
        IRecipeSlotBuilder outputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).setSlotName("output").add(outputs)).addRichTooltipCallback(callback).setStandardSlotBackground();
        if (leftInputs.size() == rightInputs.size() && leftInputs.size() == 1) {
            builder.createFocusLink(new IIngredientAcceptor[]{leftInputSlot, rightInputSlot, outputSlot});
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, ColorizeRecipe recipe, IFocusGroup focuses) {
        builder.addRecipePlusSign().setPosition(27, 3);
        builder.addRecipeArrow().setPosition(76, 1);
    }
}

