/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.util.Geometry;

public interface MultiblockMachineController {
    public List<class_2382> getCorePositions();

    public class_2350 getFacingForMultiblock();

    public class_2338 getPosForMultiblock();

    public class_1937 getWorldForMultiblock();

    public ArrayList<class_2338> getConnectedCores();

    public void setCoreQuality(float var1);

    public float getCoreQuality();

    public ItemApi.InventoryStorage getInventoryForMultiblock();

    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 var1);

    default public void addMultiblockToNbt(class_2487 nbt) {
        class_2499 posList = new class_2499();
        for (class_2338 pos : this.getConnectedCores()) {
            class_2487 posTag = new class_2487();
            posTag.method_10569("x", pos.method_10263());
            posTag.method_10569("y", pos.method_10264());
            posTag.method_10569("z", pos.method_10260());
            posList.add((Object)posTag);
        }
        nbt.method_10566("connectedCores", (class_2520)posList);
        nbt.method_10548("coreQuality", this.getCoreQuality());
    }

    default public void loadMultiblockNbtData(class_2487 nbt) {
        class_2499 posList = nbt.method_10554("connectedCores", 10);
        ArrayList<class_2338> coreBlocksConnected = this.getConnectedCores();
        for (class_2520 posTag : posList) {
            class_2487 posCompound = (class_2487)posTag;
            int x = posCompound.method_10550("x");
            int y = posCompound.method_10550("y");
            int z = posCompound.method_10550("z");
            class_2338 pos = new class_2338(x, y, z);
            coreBlocksConnected.add(pos);
        }
        this.setCoreQuality(nbt.method_10583("coreQuality"));
    }

    default public Boolean tryPlaceNextCore(class_1657 player) {
        class_2338 nextPosition;
        class_1799 heldStack = player.method_6118(class_1304.field_6173);
        class_1792 heldItem = heldStack.method_7909();
        if (!(heldItem instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)heldItem;
        if (blockItem.method_7711() instanceof MachineCoreBlock && (nextPosition = this.getNextMissingCore()) != null) {
            this.getWorldForMultiblock().method_8501(nextPosition, blockItem.method_7711().method_9564());
            if (!player.method_7337()) {
                heldStack.method_7934(1);
                if (heldStack.method_7947() == 0) {
                    player.method_6122(class_1268.field_5808, class_1799.field_8037);
                }
            }
            return true;
        }
        return false;
    }

    default public class_2338 getNextMissingCore() {
        class_1937 world = this.getWorldForMultiblock();
        class_2338 pos = this.getPosForMultiblock();
        class_2350 ownFacing = this.getFacingForMultiblock();
        List<class_2382> targetMachinePositions = this.getCorePositions();
        for (class_2382 targetMachinePosition : targetMachinePositions) {
            class_2382 rotatedPos = Geometry.rotatePosition(targetMachinePosition, ownFacing);
            class_2338 checkPos = pos.method_10081(rotatedPos);
            class_2680 checkState = Objects.requireNonNull(world).method_8320(checkPos);
            if (!checkState.method_27852(class_2246.field_10124) && !checkState.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"minecraft", (String)"replaceable")))) continue;
            return checkPos;
        }
        return null;
    }

    default public boolean initMultiblock(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)MultiblockMachine.ASSEMBLED)).booleanValue()) {
            return true;
        }
        class_1937 world = this.getWorldForMultiblock();
        class_2338 pos = this.getPosForMultiblock();
        ArrayList<class_2338> coreBlocksConnected = this.getConnectedCores();
        class_2350 ownFacing = this.getFacingForMultiblock();
        List<class_2382> targetMachinePositions = this.getCorePositions();
        ArrayList<MultiBlockElement> coreBlocks = new ArrayList<MultiBlockElement>(targetMachinePositions.size());
        float sumCoreQuality = 0.0f;
        for (class_2382 targetMachinePosition : targetMachinePositions) {
            class_2382 rotatedPos = Geometry.rotatePosition(targetMachinePosition, ownFacing);
            class_2338 checkPos = pos.method_10081(rotatedPos);
            class_2680 checkState = Objects.requireNonNull(world).method_8320(checkPos);
            class_2248 blockType = checkState.method_26204();
            if (blockType instanceof MachineCoreBlock) {
                MachineCoreBlock coreBlock = (MachineCoreBlock)blockType;
                if (!((Boolean)checkState.method_11654((class_2769)MachineCoreBlock.USED)).booleanValue()) {
                    coreBlocks.add(new MultiBlockElement(checkState, coreBlock, checkPos));
                    sumCoreQuality += coreBlock.getCoreQuality();
                    continue;
                }
            }
            this.highlightBlock(checkPos, world);
        }
        if (targetMachinePositions.size() == coreBlocks.size()) {
            for (MultiBlockElement core : coreBlocks) {
                class_2680 newState = (class_2680)core.state.method_11657((class_2769)MachineCoreBlock.USED, (Comparable)Boolean.valueOf(true));
                MachineCoreEntity coreEntity = (MachineCoreEntity)world.method_8321(core.pos());
                coreEntity.setControllerPos(pos);
                world.method_8501(core.pos, newState);
                coreBlocksConnected.add(core.pos);
            }
            float quality = sumCoreQuality / (float)coreBlocks.size();
            this.setCoreQuality(quality);
            Objects.requireNonNull(world).method_8501(pos, (class_2680)state.method_11657((class_2769)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    default public void onCoreBroken(class_2338 corePos) {
        class_1937 world = this.getWorldForMultiblock();
        class_2338 pos = this.getPosForMultiblock();
        ArrayList<class_2338> coreBlocksConnected = this.getConnectedCores();
        Objects.requireNonNull(world).method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(false)));
        for (class_2338 core : coreBlocksConnected) {
            class_2680 state;
            if (core.equals((Object)corePos) || !((state = world.method_8320(core)).method_26204() instanceof MachineCoreBlock)) continue;
            world.method_8501(core, (class_2680)state.method_11657((class_2769)MachineCoreBlock.USED, (Comparable)Boolean.valueOf(false)));
        }
        coreBlocksConnected.clear();
    }

    default public void onControllerBroken() {
        class_1937 world = this.getWorldForMultiblock();
        ArrayList<class_2338> coreBlocksConnected = this.getConnectedCores();
        for (class_2338 core : coreBlocksConnected) {
            class_2680 state = Objects.requireNonNull(world).method_8320(core);
            if (!(state.method_26204() instanceof MachineCoreBlock)) continue;
            world.method_8501(core, (class_2680)state.method_11657((class_2769)MachineCoreBlock.USED, (Comparable)Boolean.valueOf(false)));
        }
        coreBlocksConnected.clear();
    }

    private void highlightBlock(class_2338 block, class_1937 world) {
        ParticleContent.HIGHLIGHT_BLOCK.spawn(world, class_243.method_24954((class_2382)block), null);
    }

    public void triggerSetupAnimation();

    public record MultiBlockElement(class_2680 state, MachineCoreBlock coreBlock, class_2338 pos) {
    }
}

