/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.arcane;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.arcane.SpawnerControllerBlockEntity;

public class SpawnerControllerBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public SpawnerControllerBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        BlockEntity blockEntity;
        super.stepOn(world, pos, state, entity);
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof SpawnerControllerBlockEntity) {
            SpawnerControllerBlockEntity spawnerEntity = (SpawnerControllerBlockEntity)blockEntity;
            spawnerEntity.onEntitySteppedOn(entity);
        }
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        super.neighborChanged(state, world, pos, sourceBlock, sourcePos, notify);
        if (world.isClientSide) {
            return;
        }
        boolean isPowered = world.hasNeighborSignal(pos);
        SpawnerControllerBlockEntity entity = (SpawnerControllerBlockEntity)world.getBlockEntity(pos);
        entity.setRedstonePowered(isPowered);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return ((SpawnerControllerBlockEntity)world.getBlockEntity(pos)).getComparatorOutput();
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof SpawnerControllerBlockEntity) {
            SpawnerControllerBlockEntity spawnerEntity = (SpawnerControllerBlockEntity)blockEntity;
            spawnerEntity.onBlockInteracted(player);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SpawnerControllerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.spawner").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.spawner2").withStyle(ChatFormatting.GRAY));
    }
}

