/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.pipes.energy;

import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.block.blocks.pipes.GenericPipeDuctBlock;
import rearth.oritech.block.blocks.pipes.energy.EnergyPipeBlock;
import rearth.oritech.block.blocks.pipes.energy.EnergyPipeConnectionBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockContent;

public class EnergyPipeDuctBlock
extends GenericPipeDuctBlock {
    public EnergyPipeDuctBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public BlockState getConnectionBlock() {
        return this.getNormalBlock();
    }

    @Override
    public BlockState getNormalBlock() {
        return BlockContent.ENERGY_PIPE_DUCT_BLOCK.defaultBlockState();
    }

    @Override
    public String getPipeTypeName() {
        return "energy";
    }

    @Override
    public boolean connectToOwnBlockType(Block block) {
        return block instanceof EnergyPipeDuctBlock || block instanceof EnergyPipeBlock || block instanceof EnergyPipeConnectionBlock;
    }

    @Override
    public GenericPipeInterfaceEntity.PipeNetworkData getNetworkData(Level world) {
        return EnergyPipeBlock.ENERGY_PIPE_DATA.computeIfAbsent(world.dimension().location(), data -> new GenericPipeInterfaceEntity.PipeNetworkData());
    }
}

