/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.storage;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.entity.storage.SmallStorageBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.TooltipHelper;

public class SmallStorageBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty TARGET_DIR = DirectionProperty.create((String)"target_dir");

    public SmallStorageBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)TARGET_DIR, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TARGET_DIR});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)TARGET_DIR, (Comparable)ctx.getNearestLookingDirection().getOpposite());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SmallStorageBlockEntity(pos, state);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return ((ComparatorOutputProvider)world.getBlockEntity(pos)).getComparatorOutput();
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        super.neighborChanged(state, world, pos, sourceBlock, sourcePos, notify);
        if (world.isClientSide) {
            return;
        }
        boolean isPowered = world.hasNeighborSignal(pos);
        ExpandableEnergyStorageBlockEntity storageEntity = (ExpandableEnergyStorageBlockEntity)world.getBlockEntity(pos);
        storageEntity.setRedstonePowered(isPowered);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            BlockEntity entity = world.getBlockEntity(pos);
            if (!(entity instanceof MachineAddonController)) {
                return InteractionResult.SUCCESS;
            }
            MachineAddonController machineEntity = (MachineAddonController)entity;
            machineEntity.initAddons();
            ExtendedMenuProvider handler = (ExtendedMenuProvider)world.getBlockEntity(pos);
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)handler);
        }
        return InteractionResult.SUCCESS;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List droppedStacks = super.getDrops(state, builder);
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof SmallStorageBlockEntity) {
            SmallStorageBlockEntity storageEntity = (SmallStorageBlockEntity)blockEntity;
            droppedStacks.addAll(storageEntity.inventory.getHeldStacks());
            storageEntity.inventory.clearContent();
        }
        return droppedStacks;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return SmallStorageBlock.getStackWithData(world, pos);
    }

    @NotNull
    private static ItemStack getStackWithData(LevelReader world, BlockPos pos) {
        ItemStack stack = new ItemStack((ItemLike)BlockContent.SMALL_STORAGE_BLOCK.asItem());
        SmallStorageBlockEntity storageEntity = (SmallStorageBlockEntity)world.getBlockEntity(pos);
        if (storageEntity.getEnergyStorage(null).getAmount() > 0L) {
            stack.set(EnergyApi.ITEM.getEnergyComponent(), (Object)storageEntity.getEnergyStorage(null).getAmount());
        }
        return stack;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        Long storedEnergyInStack = (Long)itemStack.getOrDefault(EnergyApi.ITEM.getEnergyComponent(), (Object)0L);
        if (storedEnergyInStack > 0L) {
            ExpandableEnergyStorageBlockEntity storageEntity = (ExpandableEnergyStorageBlockEntity)world.getBlockEntity(pos);
            storageEntity.energyStorage.setAmount(storedEnergyInStack);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity entity;
        if (!world.isClientSide && (entity = world.getBlockEntity(pos)) instanceof MachineAddonController) {
            MachineAddonController machineEntity = (MachineAddonController)entity;
            machineEntity.resetAddons();
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        TooltipHelper.addMachineTooltip(tooltip, this, this);
    }
}

