/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.addons;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MachineAddonController;

public class SteamBoilerAddonBlockEntity
extends AddonBlockEntity
implements FluidApi.BlockProvider {
    private UpgradableGeneratorBlockEntity cachedController;

    public SteamBoilerAddonBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.STEAM_BOILER_ADDON_ENTITY, pos, state);
    }

    private boolean isConnected() {
        Boolean isUsed = (Boolean)this.getBlockState().getValue((Property)MachineAddonBlock.ADDON_USED);
        return isUsed != false && this.getCachedController() != null;
    }

    private MachineAddonController getCachedController() {
        if (this.cachedController != null) {
            return this.cachedController;
        }
        BlockEntity candidate = Objects.requireNonNull(this.level).getBlockEntity(this.getControllerPos());
        if (candidate instanceof UpgradableGeneratorBlockEntity) {
            UpgradableGeneratorBlockEntity generator;
            this.cachedController = generator = (UpgradableGeneratorBlockEntity)candidate;
        }
        return this.cachedController;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(Direction direction) {
        if (!this.isConnected()) {
            return null;
        }
        return this.cachedController.boilerStorage;
    }
}

