/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.arcane;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.wispforest.owo.util.VectorRandomUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.entity.arcane.EnchantmentCatalystBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.EnchanterScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EnchanterBlockEntity
extends NetworkedBlockEntity
implements ItemApi.BlockProvider,
EnergyApi.BlockProvider,
GeoBlockEntity,
ScreenProvider,
ExtendedMenuProvider {
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    public static final RawAnimation UNPOWERED = RawAnimation.begin().thenPlayAndHold("unpowered");
    public static final RawAnimation WORKING = RawAnimation.begin().thenPlay("working");
    @SyncField(value={SyncType.GUI_OPEN, SyncType.TICK})
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(50000L, 1000L, 0L, this::setChanged);
    public final InOutInventoryStorage inventory = new InOutInventoryStorage(2, this::setChanged, new InventorySlotAssignment(0, 1, 1, 1));
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final ResourceLocation NONE_SELECTED = ResourceLocation.parse((String)"o:empty");
    @SyncField(value={SyncType.GUI_OPEN, SyncType.TICK})
    @NotNull
    public ResourceLocation selectedEnchantment = NONE_SELECTED;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.TICK})
    public int progress;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.TICK})
    public int maxProgress = 10;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.TICK})
    public EnchanterStatistics statistics = EnchanterStatistics.EMPTY;
    private final List<EnchantmentCatalystBlockEntity> cachedCatalysts = new ArrayList<EnchantmentCatalystBlockEntity>();
    private String activeAnimation = "idle";

    public EnchanterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ENCHANTER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        int maxLevel;
        this.activeAnimation = "idle";
        if (world.getGameTime() % 80L == 0L) {
            this.triggerAnim("machine", this.activeAnimation);
        }
        this.statistics = EnchanterStatistics.EMPTY;
        ItemStack content = (ItemStack)this.inventory.heldStacks.get(0);
        if (content.isEmpty() || !this.inventory.getItem(1).isEmpty() || !content.getItem().isEnchantable(content) || this.selectedEnchantment.equals((Object)NONE_SELECTED) || !this.getSelectedEnchantment().isBound() || !((Enchantment)this.getSelectedEnchantment().value()).canEnchant(content)) {
            this.progress = 0;
            return;
        }
        int existingLevel = content.getEnchantments().getLevel(this.getSelectedEnchantment());
        if (existingLevel >= (maxLevel = ((Enchantment)this.getSelectedEnchantment().value()).getMaxLevel())) {
            return;
        }
        this.maxProgress = this.getEnchantmentCost((Enchantment)this.getSelectedEnchantment().value(), existingLevel + 1);
        if (this.canProgress(existingLevel + 1)) {
            this.setChanged();
            this.energyStorage.amount -= (long)this.getDisplayedEnergyUsage();
            ++this.progress;
            this.activeAnimation = "working";
            Vec3 center = pos.getCenter();
            Vec3 offset = VectorRandomUtils.getRandomOffset((Level)world, (Vec3)center, (double)4.0);
            ParticleContent.WEED_KILLER.spawn(world, center, (Object)new ParticleContent.LineData(center, offset));
            if (this.progress >= this.maxProgress) {
                this.progress = 0;
                this.finishEnchanting();
                ParticleContent.ASSEMBLER_WORKING.spawn(world, pos.getCenter(), (Object)(this.maxProgress + 10));
                this.activeAnimation = "idle";
            }
        }
    }

    @Override
    public void sendUpdate(SyncType type) {
        super.sendUpdate(type);
        this.triggerAnim("machine", this.activeAnimation);
    }

    public Holder<Enchantment> getSelectedEnchantment() {
        if (this.selectedEnchantment.equals((Object)NONE_SELECTED)) {
            return null;
        }
        Registry registry = this.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        return registry.wrapAsHolder((Object)((Enchantment)registry.get(this.selectedEnchantment)));
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putLong("energy", this.energyStorage.amount);
        nbt.putString("selected", this.selectedEnchantment.toString());
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        this.energyStorage.amount = nbt.getLong("energy");
        if (nbt.contains("selected")) {
            this.selectedEnchantment = ResourceLocation.parse((String)nbt.getString("selected"));
        }
    }

    private void finishEnchanting() {
        ItemStack content = (ItemStack)this.inventory.heldStacks.get(0);
        int existingLevel = content.getEnchantments().getLevel(this.getSelectedEnchantment());
        content.enchant(this.getSelectedEnchantment(), existingLevel + 1);
        this.inventory.heldStacks.set(0, (Object)ItemStack.EMPTY);
        this.inventory.heldStacks.set(1, (Object)content);
        this.statistics = new EnchanterStatistics(0, this.cachedCatalysts.size());
    }

    private int getRequiredCatalystCount(int targetLevel) {
        return ((Enchantment)this.getSelectedEnchantment().value()).getAnvilCost() + targetLevel;
    }

    private boolean canProgress(int targetLevel) {
        if ((float)this.energyStorage.amount <= this.getDisplayedEnergyUsage()) {
            this.activeAnimation = "unpowered";
            return false;
        }
        if (this.level.getGameTime() % 15L == 0L) {
            this.updateNearbyCatalysts();
        }
        int requiredCatalysts = this.getRequiredCatalystCount(targetLevel);
        this.statistics = new EnchanterStatistics(requiredCatalysts, this.cachedCatalysts.size());
        for (EnchantmentCatalystBlockEntity catalyst : this.cachedCatalysts) {
            ParticleContent.CATALYST_CONNECTION.spawn(this.level, this.worldPosition.getCenter(), (Object)new ParticleContent.LineData(catalyst.getBlockPos().getCenter(), this.worldPosition.above().getCenter()));
        }
        if (this.cachedCatalysts.size() < requiredCatalysts) {
            return false;
        }
        Collections.shuffle(this.cachedCatalysts);
        Optional<EnchantmentCatalystBlockEntity> usedOne = this.cachedCatalysts.stream().filter(elem -> elem.collectedSouls > 0).findFirst();
        if (usedOne.isEmpty()) {
            return false;
        }
        --usedOne.get().collectedSouls;
        this.setChanged();
        return true;
    }

    private int getEnchantmentCost(Enchantment enchantment, int targetLevel) {
        return enchantment.getAnvilCost() * targetLevel * Oritech.CONFIG.enchanterCostMultiplier() + 1;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 4, state -> PlayState.CONTINUE).triggerableAnim("working", WORKING).triggerableAnim("idle", IDLE).triggerableAnim("unpowered", UNPOWERED).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private void updateNearbyCatalysts() {
        int chunkRadius = 1;
        int startX = (this.worldPosition.getX() >> 4) - chunkRadius;
        int startZ = (this.worldPosition.getZ() >> 4) - chunkRadius;
        int endX = (this.worldPosition.getX() >> 4) + chunkRadius;
        int endZ = (this.worldPosition.getZ() >> 4) + chunkRadius;
        this.cachedCatalysts.clear();
        for (int chunkX = startX; chunkX <= endX; ++chunkX) {
            for (int chunkZ = startZ; chunkZ <= endZ; ++chunkZ) {
                ChunkAccess chunk = this.level.getChunk(chunkX, chunkZ, ChunkStatus.FULL, false);
                if (chunk == null) continue;
                Map entities = chunk.blockEntities;
                List<EnchantmentCatalystBlockEntity> catalysts = entities.values().stream().filter(elem -> {
                    if (!(elem instanceof EnchantmentCatalystBlockEntity)) return false;
                    EnchantmentCatalystBlockEntity catalyst = (EnchantmentCatalystBlockEntity)elem;
                    if (catalyst.collectedSouls <= 0) return false;
                    if (elem.getBlockPos().distManhattan((Vec3i)this.worldPosition) >= 16) return false;
                    return true;
                }).map(elem -> (EnchantmentCatalystBlockEntity)elem).toList();
                this.cachedCatalysts.addAll(catalysts);
            }
        }
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.writeBlockPos(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new EnchanterScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 52, 58), new ScreenProvider.GuiSlot(1, 108, 58, true));
    }

    @Override
    public ScreenProvider.ArrowConfiguration getIndicatorConfiguration() {
        return new ScreenProvider.ArrowConfiguration(Oritech.id("textures/gui/modular/arrow_empty.png"), Oritech.id("textures/gui/modular/arrow_full.png"), 73, 58, 29, 16, true);
    }

    @Override
    public ScreenProvider.BarConfiguration getEnergyConfiguration() {
        return new ScreenProvider.BarConfiguration(7, 7, 18, 71);
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 512.0f;
    }

    @Override
    public float getProgress() {
        return (float)this.progress / (float)this.maxProgress;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.ENCHANTER_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    public static void receiveEnchantmentSelection(SelectEnchantingPacket packet, Player player, RegistryAccess dynamicRegistryManager) {
        BlockEntity blockEntity = player.level().getBlockEntity(packet.self);
        if (blockEntity instanceof EnchanterBlockEntity) {
            EnchanterBlockEntity enchanterBlock = (EnchanterBlockEntity)blockEntity;
            enchanterBlock.selectedEnchantment = packet.enchantmentId;
        }
    }

    public record EnchanterStatistics(int requiredCatalysts, int availableCatalysts) {
        public static EnchanterStatistics EMPTY = new EnchanterStatistics(-1, -1);
    }

    public record SelectEnchantingPacket(BlockPos self, ResourceLocation enchantmentId) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SelectEnchantingPacket> PACKET_ID = new CustomPacketPayload.Type(Oritech.id("selected_enchant"));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

