/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.generators;

import dev.architectury.fluid.FluidStack;
import dev.architectury.platform.Platform;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.FluidMultiblockGeneratorBlockEntity;
import rearth.oritech.block.base.entity.MultiblockGeneratorBlockEntity;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class SteamEngineEntity
extends MultiblockGeneratorBlockEntity
implements FluidApi.BlockProvider {
    private static final int MAX_SPEED = 10;
    private static final int MAX_CHAIN_SIZE = 20;
    private static final float WATER_RATIO = 0.9f;
    public static float STEAM_AMOUNT_MULTIPLIER = Platform.isNeoForge() ? 0.05f : 4.0f;
    private static Fluid USED_STEAM_FLUID;
    public long masterHeartbeat;
    public SteamEngineEntity master;
    private final Set<SteamEngineEntity> slaves = new HashSet<SteamEngineEntity>();
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    public SteamEngineSyncPacket clientStats;

    public SteamEngineEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.STEAM_ENGINE_ENTITY, pos, state, Oritech.CONFIG.generators.steamEngineData.steamToRfRatio());
        this.clientStats = new SteamEngineSyncPacket(pos, 1.0f, 1.0f, 0L, 0L, 0);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        boolean hasInput;
        if (world.isClientSide || !this.isActive(state)) {
            return;
        }
        boolean slaved = this.inSlaveMode();
        boolean bl = hasInput = !this.boilerStorage.getInStack().isEmpty();
        if (world.getGameTime() % 80L == 0L && !slaved && hasInput) {
            this.setupMaster();
        }
        if (!slaved && hasInput) {
            this.tickMaster();
        }
        if (slaved) {
            this.tickSlave();
        }
        this.outputEnergy();
    }

    private void tickMaster() {
        FluidApi.SingleSlotStorage steamTank = this.boilerStorage.getInputContainer();
        FluidApi.SingleSlotStorage waterTank = this.boilerStorage.getOutputContainer();
        if (this.energyStorage.getAmount() >= this.energyStorage.getCapacity() && Oritech.CONFIG.generators.steamEngineData.stopOnEnergyFull()) {
            return;
        }
        if (waterTank.getStack().getAmount() >= waterTank.getCapacity() && Oritech.CONFIG.generators.steamEngineData.stopOnWaterFull()) {
            return;
        }
        if (this.currentRecipe == OritechRecipe.DUMMY || !this.currentRecipe.getFluidInput().matchesFluid(steamTank.getStack())) {
            Optional<RecipeHolder<OritechRecipe>> candidate = FluidMultiblockGeneratorBlockEntity.getRecipe(steamTank, this.level, this.getOwnRecipeType());
            candidate.ifPresent(recipe -> {
                this.currentRecipe = (OritechRecipe)recipe.value();
            });
            if (candidate.isEmpty()) {
                return;
            }
            this.currentRecipe = (OritechRecipe)candidate.get().value();
        }
        float speed = this.getSteamProcessingSpeed(steamTank);
        int workerCount = this.slaves.size() + 1;
        float consumedCount = (float)this.currentRecipe.getFluidInput().amount() * speed * (float)workerCount * STEAM_AMOUNT_MULTIPLIER;
        float producedCount = consumedCount * 0.9f;
        consumedCount = Math.max(consumedCount, 1.0f);
        producedCount = Math.max(producedCount, 1.0f);
        steamTank.extract(steamTank.getStack().copyWithAmount((long)consumedCount), false);
        waterTank.insert(FluidStack.create((Fluid)Fluids.WATER, (long)((long)producedCount)), false);
        float energyEfficiency = this.getSteamEnergyEfficiency(speed);
        float energyProduced = consumedCount * energyEfficiency * (float)this.energyPerTick / STEAM_AMOUNT_MULTIPLIER;
        this.energyStorage.insertIgnoringLimit((long)energyProduced, false);
        this.spawnParticles();
        this.lastWorkedAt = this.level.getGameTime();
        this.progress = (int)(speed * 100.0f);
        this.clientStats = new SteamEngineSyncPacket(this.worldPosition, speed, energyEfficiency, (long)energyProduced, (long)(consumedCount / STEAM_AMOUNT_MULTIPLIER), this.slaves.size());
        this.setChanged();
    }

    private void tickSlave() {
        SteamEngineSyncPacket masterStats = this.master.clientStats;
        if (masterStats == null) {
            return;
        }
        boolean wasWorking = this.master.isActivelyWorking();
        float speed = masterStats.speed();
        if (wasWorking) {
            this.spawnParticles();
            this.lastWorkedAt = this.level.getGameTime();
            this.setChanged();
        }
        this.progress = (int)(speed * 100.0f);
    }

    private void setupMaster() {
        this.slaves.clear();
        block0: for (int direction = -1; direction <= 1; ++direction) {
            if (direction == 0) continue;
            for (int i = 1; i <= 20; ++i) {
                Optional candidate;
                BlockPos checkPos = new BlockPos(Geometry.offsetToWorldPosition(this.getFacing(), new Vec3i(i * direction, 0, 0), (Vec3i)this.worldPosition));
                Optional coreCandidate = this.level.getBlockEntity(checkPos, BlockEntitiesContent.MACHINE_CORE_ENTITY);
                if (coreCandidate.isPresent() && ((MachineCoreEntity)coreCandidate.get()).getCachedController() != null) {
                    checkPos = ((MachineCoreEntity)coreCandidate.get()).getControllerPos();
                }
                if ((candidate = this.level.getBlockEntity(checkPos, BlockEntitiesContent.STEAM_ENGINE_ENTITY)).isEmpty() || !((SteamEngineEntity)candidate.get()).isActive(((SteamEngineEntity)candidate.get()).getBlockState()) || !((SteamEngineEntity)candidate.get()).boilerStorage.getInStack().isEmpty()) continue block0;
                SteamEngineEntity slave = (SteamEngineEntity)candidate.get();
                this.slaves.add(slave);
                slave.masterHeartbeat = this.level.getGameTime();
                slave.master = this;
            }
        }
    }

    public boolean inSlaveMode() {
        long heartbeatAge = this.level.getGameTime() - this.masterHeartbeat;
        return heartbeatAge <= 100L && this.master != null && !this.master.isRemoved();
    }

    @Override
    public boolean boilerAcceptsInput(Fluid fluid) {
        return fluid.equals(SteamEngineEntity.getUsedSteamFluid());
    }

    private void spawnParticles() {
        if ((double)this.level.random.nextFloat() > 0.5) {
            return;
        }
        Direction facing = this.getFacing();
        Vec3 offsetLocal = Geometry.rotatePosition(new Vec3(0.0, 0.0, -0.5), facing);
        Vec3 emitPosition = Vec3.atCenterOf((Vec3i)this.worldPosition).add(offsetLocal);
        ParticleContent.STEAM_ENGINE_WORKING.spawn(this.level, emitPosition, (Object)1);
    }

    private float getSteamEnergyEfficiency(float x) {
        return (float)((double)(0.5f - 0.1966667f * x) + 0.09166666865348816 * Math.pow(x, 2.0) - (double)0.0075f * Math.pow(x, 3.0)) + 0.4f;
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
    }

    private float getSteamProcessingSpeed(FluidApi.SingleSlotStorage usedTank) {
        float fillPercentage = (float)usedTank.getStack().getAmount() / (float)usedTank.getCapacity();
        return fillPercentage * 10.0f;
    }

    @Override
    protected float getAnimationSpeed() {
        if (this.progress == 0) {
            return 1.0f;
        }
        return (float)this.progress / 100.0f;
    }

    @Override
    public ScreenProvider.BarConfiguration getFluidConfiguration() {
        return new ScreenProvider.BarConfiguration(149, 10, 18, 64);
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.STEAM_ENGINE;
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 0, 0, 0);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of();
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.STEAM_ENGINE_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 0;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.generators.steamEngineData.energyCapacity();
    }

    @Override
    public long getDefaultExtractionRate() {
        return Oritech.CONFIG.generators.steamEngineData.maxEnergyExtraction();
    }

    @Override
    protected Set<Tuple<BlockPos, Direction>> getOutputTargets(BlockPos pos, Level world) {
        HashSet<Tuple<BlockPos, Direction>> res = new HashSet<Tuple<BlockPos, Direction>>();
        Direction facing = this.getFacingForAddon();
        Vec3i posA = new Vec3i(0, 0, 1);
        Vec3i posB = new Vec3i(-1, 0, 0);
        Vec3i posC = new Vec3i(1, 0, 0);
        Vec3i posD = new Vec3i(-1, 0, -1);
        Vec3i posE = new Vec3i(1, 0, -1);
        Vec3i posF = new Vec3i(0, 0, -2);
        BlockPos worldPosA = (BlockPos)Geometry.offsetToWorldPosition(facing, posA, (Vec3i)pos);
        BlockPos worldPosB = (BlockPos)Geometry.offsetToWorldPosition(facing, posB, (Vec3i)pos);
        BlockPos worldPosC = (BlockPos)Geometry.offsetToWorldPosition(facing, posC, (Vec3i)pos);
        BlockPos worldPosD = (BlockPos)Geometry.offsetToWorldPosition(facing, posD, (Vec3i)pos);
        BlockPos worldPosE = (BlockPos)Geometry.offsetToWorldPosition(facing, posE, (Vec3i)pos);
        BlockPos worldPosF = (BlockPos)Geometry.offsetToWorldPosition(facing, posF, (Vec3i)pos);
        res.add(new Tuple((Object)worldPosA, (Object)Geometry.fromVector(Geometry.getForward(facing))));
        res.add(new Tuple((Object)worldPosB, (Object)Geometry.fromVector(Geometry.getLeft(facing))));
        res.add(new Tuple((Object)worldPosC, (Object)Geometry.fromVector(Geometry.getRight(facing))));
        res.add(new Tuple((Object)worldPosD, (Object)Geometry.fromVector(Geometry.getLeft(facing))));
        res.add(new Tuple((Object)worldPosE, (Object)Geometry.fromVector(Geometry.getRight(facing))));
        res.add(new Tuple((Object)worldPosF, (Object)Geometry.fromVector(Geometry.getBackward(facing))));
        return res;
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of();
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 1, 0), new Vec3i(0, 0, -1), new Vec3i(0, 1, -1));
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable Direction direction) {
        if (this.inSlaveMode()) {
            return this.master.boilerStorage;
        }
        return this.boilerStorage;
    }

    public static Fluid getUsedSteamFluid() {
        if (USED_STEAM_FLUID == null) {
            USED_STEAM_FLUID = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)Oritech.CONFIG.generators.steamId()));
        }
        return USED_STEAM_FLUID;
    }

    public record SteamEngineSyncPacket(BlockPos position, float speed, float efficiency, long energyProduced, long steamConsumed, int slaves) {
    }
}

