/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import java.util.HashMap;
import net.minecraft.util.Tuple;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.generators.BigSolarPanelEntity;
import rearth.oritech.client.renderers.LaserArmModel;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;

public class SolarPanelModel<T extends BigSolarPanelEntity>
extends DefaultedBlockGeoModel<T> {
    private final HashMap<Long, Tuple<GeoBone, Float>> renderData = new HashMap();

    private Tuple<GeoBone, Float> getDataFromCache(long id) {
        return this.renderData.computeIfAbsent(id, s -> new Tuple((Object)this.getAnimationProcessor().getBone("pivotZ"), (Object)Float.valueOf(0.0f)));
    }

    public SolarPanelModel(String subpath) {
        super(Oritech.id(subpath));
    }

    public void setCustomAnimations(T solarEntity, long instanceId, AnimationState<T> animationState) {
        long timeOfDay = ((BigSolarPanelEntity)solarEntity).getAdjustedTimeOfDay();
        Tuple<GeoBone, Float> data = this.getDataFromCache(instanceId);
        if (timeOfDay > 13000L) {
            data.setB((Object)Float.valueOf(0.0f));
        }
        float directionPercent = (float)(timeOfDay - 6000L) / 6000.0f;
        int maxAngle = 45;
        float targetAngle = directionPercent * (float)maxAngle * ((float)Math.PI / 180);
        Float lastAngle = (Float)data.getB();
        float angle = LaserArmModel.lerp(lastAngle.floatValue(), targetAngle, 0.06f);
        GeoBone bone = (GeoBone)data.getA();
        bone.setRotZ(angle);
        data.setB((Object)Float.valueOf(angle));
    }
}

