/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BlockPreviewComponent
extends BaseComponent {
    private final Minecraft client = Minecraft.getInstance();
    private final BlockState state;
    @Nullable
    private final BlockEntity entity;
    private final Vec3i offset;
    private final float mouseRotationSpeed;
    private float mouseRotation;

    public BlockPreviewComponent(BlockState state, @Nullable BlockEntity entity, Vec3i offset, float mouseRotationSpeed) {
        this.state = state;
        this.entity = entity;
        this.offset = offset;
        this.mouseRotationSpeed = mouseRotationSpeed;
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        context.pose().pushPose();
        context.pose().translate((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, 400.0f);
        context.pose().scale((float)(40 * this.width) / 64.0f, (float)(-40 * this.height) / 64.0f, 40.0f);
        context.pose().mulPose(Axis.XP.rotationDegrees(30.0f));
        context.pose().mulPose(Axis.YP.rotationDegrees(225.0f + this.mouseRotation));
        this.mouseRotation += this.mouseRotationSpeed;
        context.pose().translate(-0.5 + (double)this.offset.getX(), -0.5 + (double)this.offset.getY(), -0.5 + (double)this.offset.getZ());
        RenderSystem.runAsFancy(() -> {
            BlockEntityRenderer entityRenderer;
            MultiBufferSource.BufferSource vertexConsumers = this.client.renderBuffers().bufferSource();
            if (this.state.getRenderShape() != RenderShape.ENTITYBLOCK_ANIMATED) {
                this.client.getBlockRenderer().renderSingleBlock(this.state, context.pose(), (MultiBufferSource)vertexConsumers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            if (this.entity != null && (entityRenderer = this.client.getBlockEntityRenderDispatcher().getRenderer(this.entity)) != null) {
                entityRenderer.render(this.entity, partialTicks, context.pose(), (MultiBufferSource)vertexConsumers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            RenderSystem.setShaderLights((Vector3f)new Vector3f(-1.5f, -0.5f, 0.0f), (Vector3f)new Vector3f(0.0f, -1.0f, 0.0f));
            vertexConsumers.endBatch();
            Lighting.setupFor3DItems();
        });
        context.pose().popPose();
    }
}

