/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicStatisticEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.storage.SmallStorageBlock;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.ItemContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.StackContext;

public abstract class ExpandableEnergyStorageBlockEntity
extends NetworkedBlockEntity
implements EnergyApi.BlockProvider,
ItemApi.BlockProvider,
MachineAddonController,
ScreenProvider,
ExtendedMenuProvider {
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> connectedAddons = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private final List<class_2338> openSlots = new ArrayList<class_2338>();
    @SyncField(value={SyncType.GUI_OPEN})
    private MachineAddonController.BaseAddonData addonData = MachineAddonController.BaseAddonData.DEFAULT_ADDON_DATA;
    @SyncField(value={SyncType.GUI_TICK})
    private boolean redstonePowered;
    @SyncField(value={SyncType.GUI_TICK})
    public DynamicStatisticEnergyStorage.EnergyStatistics currentStats;
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(1, this::method_5431);
    @SyncField(value={SyncType.GUI_TICK})
    public final DynamicStatisticEnergyStorage energyStorage = new DynamicStatisticEnergyStorage(this.getDefaultCapacity(), this.getDefaultInsertRate(), this.getDefaultExtractionRate(), this::method_5431);
    private final EnergyApi.EnergyStorage outputStorage = new DelegatingEnergyStorage(this, this.energyStorage, null){

        @Override
        public boolean supportsInsertion() {
            return false;
        }

        @Override
        public long insert(long amount, boolean simulate) {
            return 0L;
        }
    };
    private final EnergyApi.EnergyStorage inputStorage = new DelegatingEnergyStorage(this, this.energyStorage, null){

        @Override
        public boolean supportsExtraction() {
            return false;
        }

        @Override
        public long extract(long amount, boolean simulate) {
            return 0L;
        }
    };

    public ExpandableEnergyStorageBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        this.energyStorage.tick((int)world.method_8510());
        if (!this.redstonePowered) {
            this.outputEnergy();
        }
        this.inputFromCrystal();
    }

    private void inputFromCrystal() {
        if (this.energyStorage.amount >= this.energyStorage.capacity || this.inventory.method_5442()) {
            return;
        }
        if (!this.inventory.method_5438(0).method_7909().equals(ItemContent.OVERCHARGED_CRYSTAL)) {
            return;
        }
        this.energyStorage.amount = Math.min(this.energyStorage.capacity, this.energyStorage.amount + (long)Oritech.CONFIG.overchargedCrystalChargeRate());
    }

    private void outputEnergy() {
        if (this.energyStorage.amount <= 0L) {
            return;
        }
        this.chargeItems();
        class_3545<class_2350, class_2338> target = ExpandableEnergyStorageBlockEntity.getOutputPosition(this.field_11867, this.getFacing());
        EnergyApi.EnergyStorage candidate = EnergyApi.BLOCK.find(this.field_11863, (class_2338)target.method_15441(), ((class_2350)target.method_15442()).method_10153());
        if (candidate != null && candidate.supportsInsertion()) {
            EnergyApi.transfer(this.energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }

    private void chargeItems() {
        class_1799 heldStack = (class_1799)this.inventory.heldStacks.get(0);
        if (heldStack.method_7960() || heldStack.method_7947() > 1) {
            return;
        }
        StackContext stackRef = new StackContext(heldStack, updated -> this.inventory.heldStacks.set(0, updated));
        EnergyApi.EnergyStorage slotEnergyContainer = EnergyApi.ITEM.find(stackRef);
        if (slotEnergyContainer != null) {
            EnergyApi.transfer(this.energyStorage, slotEnergyContainer, Long.MAX_VALUE, false);
        }
    }

    public static class_3545<class_2350, class_2338> getOutputPosition(class_2338 pos, class_2350 facing) {
        class_2338 blockInFront = (class_2338)Geometry.offsetToWorldPosition(facing, new class_2382(-1, 0, 0), (class_2382)pos);
        class_2338 worldOffset = blockInFront.method_10059((class_2382)pos);
        class_2350 direction = class_2350.method_50026((int)worldOffset.method_10263(), (int)worldOffset.method_10264(), (int)worldOffset.method_10260());
        return new class_3545((Object)direction, (Object)blockInFront);
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.writeAddonToNbt(nbt);
        nbt.method_10544("energy_stored", this.energyStorage.amount);
        class_1262.method_5427((class_2487)nbt, this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        nbt.method_10556("redstone", this.redstonePowered);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.loadAddonNbtData(nbt);
        this.updateEnergyContainer();
        this.energyStorage.amount = nbt.method_10537("energy_stored");
        class_1262.method_5429((class_2487)nbt, this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.redstonePowered = nbt.method_10577("redstone");
    }

    @Override
    public void preNetworkUpdate(SyncType type) {
        super.preNetworkUpdate(type);
        this.currentStats = this.energyStorage.getCurrentStatistics(this.field_11863.method_8510());
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    public class_2350 getFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)SmallStorageBlock.TARGET_DIR);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        if (direction == null) {
            return this.energyStorage;
        }
        if (direction.equals((Object)this.getFacing())) {
            return this.outputStorage;
        }
        return this.inputStorage;
    }

    @Override
    public List<class_2338> getConnectedAddons() {
        return this.connectedAddons;
    }

    @Override
    public List<class_2338> getOpenAddonSlots() {
        return this.openSlots;
    }

    @Override
    public class_2350 getFacingForAddon() {
        class_2350 facing = (class_2350)Objects.requireNonNull(this.field_11863).method_8320(this.method_11016()).method_11654((class_2769)SmallStorageBlock.TARGET_DIR);
        if (facing.equals((Object)class_2350.field_11036) || facing.equals((Object)class_2350.field_11033)) {
            return class_2350.field_11043;
        }
        return facing;
    }

    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return this.inventory;
    }

    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }

    @Override
    public MachineAddonController.BaseAddonData getBaseAddonData() {
        return this.addonData;
    }

    @Override
    public void setBaseAddonData(MachineAddonController.BaseAddonData data) {
        this.addonData = data;
    }

    @Override
    public void updateEnergyContainer() {
        MachineAddonController.super.updateEnergyContainer();
        this.energyStorage.maxExtract = this.getDefaultExtractionRate() + this.addonData.energyBonusTransfer();
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    public abstract long getDefaultExtractionRate();

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 30, 42));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public class_2338 getPosForAddon() {
        return this.method_11016();
    }

    @Override
    public class_1937 getWorldForAddon() {
        return this.method_10997();
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.STORAGE_SCREEN;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public class_2769<class_2350> getBlockFacingProperty() {
        return SmallStorageBlock.TARGET_DIR;
    }

    public void setRedstonePowered(boolean isPowered) {
        this.redstonePowered = isPowered;
    }

    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }

    @Override
    public int receivedRedstoneSignal() {
        if (this.redstonePowered) {
            return 15;
        }
        return this.field_11863.method_49804(this.field_11867);
    }

    @Override
    public String currentRedstoneEffect() {
        if (this.receivedRedstoneSignal() > 0) {
            return "tooltip.oritech.redstone_disabled_storage";
        }
        return "tooltip.oritech.redstone_enabled_direct";
    }
}

