/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.accelerator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.NetworkedEventHandler;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.block.blocks.accelerator.AcceleratorPassthroughBlock;
import rearth.oritech.block.entity.accelerator.ParticleCollectorBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;

public class BlackHoleBlockEntity
extends NetworkedBlockEntity
implements NetworkedEventHandler {
    public class_2680 currentlyPulling;
    @SyncField
    public class_2338 currentlyPullingFrom;
    @SyncField
    public long pullingStartedAt;
    @SyncField
    public long pullTime;
    private int waitTicks;
    private final Map<class_2338, ParticleCollectorBlockEntity> cachedCollectors = new HashMap<class_2338, ParticleCollectorBlockEntity>();

    public BlackHoleBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.BLACK_HOLE_ENTITY, pos, state);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (this.waitTicks-- > 0) {
            return;
        }
        if (this.currentlyPullingFrom != null && this.pullingStartedAt + this.pullTime - 5L < world.method_8510()) {
            this.onPullingFinished();
            this.currentlyPullingFrom = null;
        }
        if (this.currentlyPullingFrom != null) {
            return;
        }
        int pullRange = Oritech.CONFIG.pullRange();
        for (class_2338 candidate : class_2338.method_25996((class_2338)pos, (int)pullRange, (int)pullRange, (int)pullRange)) {
            class_2680 candidateState = world.method_8320(candidate);
            if (candidate.equals((Object)pos) || candidateState.method_26215() || candidateState.method_26164(TagContent.BLACK_HOLE_BLACKLIST) || !candidateState.method_26227().method_15769() || candidateState.method_26204().equals(class_2246.field_10008) || candidateState.method_26204().equals(BlockContent.BLACK_HOLE_BLOCK)) continue;
            this.currentlyPullingFrom = candidate;
            this.currentlyPulling = candidateState;
            this.pullingStartedAt = world.method_8510();
            this.pullTime = (long)candidate.method_19455((class_2382)pos) * (long)Oritech.CONFIG.pullTimeMultiplier();
            world.method_8501(candidate, class_2246.field_10124.method_9564());
            this.method_5431();
            return;
        }
        if (this.currentlyPullingFrom == null) {
            this.waitTicks = Oritech.CONFIG.idleWaitTicks();
        }
    }

    private void onPullingFinished() {
        class_2338 from = this.currentlyPullingFrom;
        class_243 pulledDir = class_243.method_24954((class_2382)this.field_11867.method_10059((class_2382)from));
        pulledDir = pulledDir.method_1029();
        for (int i = 0; i < 5; ++i) {
            class_243 shootDir = pulledDir.method_49272(this.field_11863.method_8409(), 0.5f);
            class_2338 cacheKey = BlackHoleBlockEntity.getRayEnd(this.field_11867.method_46558(), shootDir.method_1029());
            ParticleCollectorBlockEntity cachedHit = this.tryGetCachedCollector(cacheKey);
            if (cachedHit != null) {
                ParticleContent.BLACK_HOLE_EMISSION.spawn(this.field_11863, this.field_11867.method_46558(), (Object)cachedHit.method_11016().method_46558());
                cachedHit.onParticleCollided();
                continue;
            }
            class_2338 impactPos = BlackHoleBlockEntity.basicRaycast(this.field_11867.method_46558().method_1019(pulledDir.method_1021(1.2)), shootDir, 12, this.field_11863);
            if (impactPos != null) {
                ParticleContent.BLACK_HOLE_EMISSION.spawn(this.field_11863, this.field_11867.method_46558(), (Object)impactPos.method_46558());
                class_2586 candidate = this.field_11863.method_8321(impactPos);
                if (!(candidate instanceof ParticleCollectorBlockEntity)) break;
                ParticleCollectorBlockEntity collectorEntity = (ParticleCollectorBlockEntity)candidate;
                collectorEntity.onParticleCollided();
                this.cachedCollectors.put(cacheKey, collectorEntity);
                continue;
            }
            ParticleContent.BLACK_HOLE_EMISSION.spawn(this.field_11863, this.field_11867.method_46558(), (Object)this.field_11867.method_46558().method_1019(shootDir.method_1021(15.0)));
            break;
        }
    }

    private static class_2338 getRayEnd(class_243 shotFrom, class_243 shotDirection) {
        return class_2338.method_49638((class_2374)shotFrom.method_1019(shotDirection.method_1021(12.0)));
    }

    private ParticleCollectorBlockEntity tryGetCachedCollector(class_2338 key) {
        ParticleCollectorBlockEntity cachedResult = this.cachedCollectors.get(key);
        if (cachedResult == null) {
            return null;
        }
        if (cachedResult.method_11015()) {
            this.cachedCollectors.remove(key);
            return null;
        }
        return cachedResult;
    }

    public static class_2338 basicRaycast(class_243 from, class_243 direction, int range, class_1937 world) {
        HashSet<class_2338> checkedPositions = new HashSet<class_2338>();
        for (float i = 0.0f; i < (float)range; i += 0.3f) {
            class_243 to = from.method_1019(direction.method_1021((double)i));
            class_2338 targetBlockPos = class_2338.method_49638((class_2374)to);
            if (checkedPositions.contains(targetBlockPos)) continue;
            checkedPositions.add(targetBlockPos);
            class_2680 targetState = world.method_8320(targetBlockPos);
            if (BlackHoleBlockEntity.canPassThrough(targetState, targetBlockPos)) continue;
            return targetBlockPos;
        }
        return null;
    }

    private static boolean canPassThrough(class_2680 state, class_2338 blockPos) {
        return state.method_26215() || !state.method_26227().method_15769() || state.method_26164(TagContent.LASER_PASSTHROUGH) || state.method_26204() instanceof AcceleratorPassthroughBlock;
    }

    @Override
    public void onNetworkUpdated() {
        if (this.currentlyPullingFrom != null) {
            this.currentlyPulling = this.field_11863.method_8320(this.currentlyPullingFrom);
        }
    }
}

