/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.Protection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_756;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.PortableLaserRenderer;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.TooltipHelper;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PortableLaserItem
extends class_1792
implements OritechEnergyItem,
GeoItem {
    public static final int ACTION_COOLDOWN = 24;
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation SHOOTING = RawAnimation.begin().thenPlay("shooting");
    private static final RawAnimation SINGLE_SHOT = RawAnimation.begin().thenPlay("singleshot");
    public static long lastSingleShot = 0L;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Map<class_1657, class_3545<class_2338, Integer>> blockBreakStats = new HashMap<class_1657, class_3545<class_2338, Integer>>();

    public PortableLaserItem(class_1792.class_1793 settings) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_3966 entityHitResult;
        class_1297 class_12972;
        class_243 endPos;
        class_1799 stack = player.method_5998(hand);
        int energyUsed = Oritech.CONFIG.portableLaserConfig.energyPerBoom();
        if (world.field_9236) {
            if (this.getStoredEnergy(stack) > (long)energyUsed && !player.method_5715() && !this.isMiningEnabled(stack)) {
                lastSingleShot = world.method_8510();
            }
            return class_1271.method_22428((Object)stack);
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof PortableLaserItem)) {
            return class_1271.method_22428((Object)stack);
        }
        PortableLaserItem laserItem = (PortableLaserItem)class_17922;
        if (player.method_5715()) {
            boolean lastMode = this.isMiningEnabled(stack);
            this.setMiningEnabled(stack, !lastMode);
            player.method_43496((class_2561)class_2561.method_43471((String)"tooltip.oritech.portable_laser.status.begin").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(!lastMode))));
            return class_1271.method_22428((Object)stack);
        }
        if (this.isMiningEnabled(stack)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"tooltip.oritech.portable_laser.status.shot_mining_error"));
            return class_1271.method_22430((Object)stack);
        }
        if (!laserItem.tryUseEnergy(stack, energyUsed, player)) {
            return class_1271.method_22430((Object)stack);
        }
        if (player.method_7357().method_7904((class_1792)this)) {
            return class_1271.method_22431((Object)stack);
        }
        player.method_7357().method_7906((class_1792)this, 24);
        class_239 hit = PortableLaserItem.getPlayerTargetRay(player);
        if (hit != null) {
            boolean canInteract = true;
            if (Platform.isModLoaded((String)"ftbchunks")) {
                boolean bl = canInteract = !FTBChunksAPI.api().getManager().shouldPreventInteraction((class_1297)player, hand, class_2338.method_49638((class_2374)hit.method_17784()), Protection.EDIT_AND_INTERACT_BLOCK, null);
            }
            if (canInteract) {
                world.method_46407(null, new class_1282((class_6880)world.method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42336), (class_1297)player), null, hit.method_17784(), (float)Oritech.CONFIG.portableLaserConfig.explosionStrength(), false, class_1937.class_7867.field_40890);
            }
            endPos = hit.method_17784();
        } else {
            class_243 startPos = player.method_33571();
            class_243 lookVec = player.method_5828(0.0f);
            endPos = startPos.method_1019(lookVec.method_1021(128.0));
        }
        if (hit instanceof class_3966 && (class_12972 = (entityHitResult = (class_3966)hit).method_17782()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            boolean canInteract = true;
            if (Platform.isModLoaded((String)"ftbchunks")) {
                boolean bl = canInteract = !FTBChunksAPI.api().getManager().shouldPreventInteraction((class_1297)player, hand, class_2338.method_49638((class_2374)hit.method_17784()), Protection.INTERACT_ENTITY, (class_1297)livingEntity);
            }
            if (canInteract) {
                PortableLaserItem.processEntityTarget(player, livingEntity, 20, stack, world);
            }
        }
        this.triggerAnim((class_1297)player, GeoItem.getId((class_1799)stack), "laser", "singleshot");
        world.method_8396(null, player.method_24515(), class_3417.field_38830, class_3419.field_15248, 0.8f, 1.0f);
        float yawRadians = (player.method_36454() + 90.0f) * (float)Math.PI / 180.0f;
        double rightX = -class_3532.method_15374((float)yawRadians);
        double rightZ = class_3532.method_15362((float)yawRadians);
        class_243 rightDir = new class_243(rightX, 0.0, rightZ).method_1029();
        class_243 startPos = player.method_33571().method_1019(endPos.method_1020(player.method_33571()).method_1021((double)0.4f)).method_1031(0.0, -0.5, 0.0).method_1019(rightDir.method_1021((double)0.3f));
        ParticleContent.LASER_BOOM.spawn(world, startPos, (Object)endPos);
        ParticleContent.MELTDOWN_IMMINENT.spawn(world, endPos, (Object)6);
        return class_1271.method_22428((Object)stack);
    }

    /*
     * Unable to fully structure code
     */
    public static void onUseTick(class_1657 player) {
        block16: {
            block15: {
                world = player.method_37908();
                stack = player.method_5998(class_1268.field_5808);
                var4_3 = stack.method_7909();
                if (!(var4_3 instanceof PortableLaserItem)) break block15;
                laserItem = (PortableLaserItem)var4_3;
                if (world != null) break block16;
            }
            return;
        }
        rfUsage = Oritech.CONFIG.portableLaserConfig.energyPerTick();
        if (!laserItem.tryUseEnergy(stack, rfUsage, player)) {
            return;
        }
        finalHit = PortableLaserItem.getPlayerTargetRay(player);
        laserItem.triggerAnim((class_1297)player, GeoItem.getId((class_1799)stack), "laser", "shooting");
        if (!(finalHit instanceof class_3965)) ** GOTO lbl-1000
        blockHitResult = (class_3965)finalHit;
        if (laserItem.isMiningEnabled(stack)) {
            blockPos = blockHitResult.method_17777();
            blockState = world.method_8320(blockPos);
            if (blockState.method_26215() || blockState.method_26164(TagContent.LASER_PASSTHROUGH)) {
                return;
            }
            canInteract = true;
            if (Platform.isModLoaded((String)"ftbchunks")) {
                v0 = canInteract = FTBChunksAPI.api().getManager().shouldPreventInteraction((class_1297)player, class_1268.field_5808, class_2338.method_49638((class_2374)finalHit.method_17784()), Protection.EDIT_AND_INTERACT_BLOCK, null) == false;
            }
            if (canInteract) {
                PortableLaserItem.processBlockBreaking(blockPos, blockState, world, player, stack, rfUsage);
            }
        } else if (finalHit instanceof class_3966) {
            entityHitResult = (class_3966)finalHit;
            target = entityHitResult.method_17782();
            if (!(target instanceof class_1309)) {
                return;
            }
            livingEntity = (class_1309)target;
            canInteract = true;
            if (Platform.isModLoaded((String)"ftbchunks")) {
                v1 = canInteract = FTBChunksAPI.api().getManager().shouldPreventInteraction((class_1297)player, class_1268.field_5808, class_2338.method_49638((class_2374)finalHit.method_17784()), Protection.EDIT_AND_INTERACT_BLOCK, target) == false;
            }
            if (canInteract) {
                PortableLaserItem.processEntityTarget(player, livingEntity, Oritech.CONFIG.portableLaserConfig.damageBase(), stack, world);
            }
        }
        if (finalHit != null && finalHit.method_17783() != class_239.class_240.field_1333 && laserItem.isMiningEnabled(stack)) {
            ParticleContent.LASER_BEAM_EFFECT.spawn(world, finalHit.method_17784());
        }
    }

    @Nullable
    public static class_239 getPlayerTargetRay(class_1657 player) {
        double entityDistance;
        class_239 blockHit = player.method_5745(128.0, 0.0f, true);
        class_243 startPos = player.method_33571();
        class_243 lookVec = player.method_5828(0.0f);
        class_243 endPos = startPos.method_1019(lookVec.method_1021(128.0));
        class_3966 entityHit = class_1675.method_18075((class_1297)player, (class_243)startPos, (class_243)endPos, (class_238)new class_238(startPos, endPos), entity -> !entity.method_7325() && entity.method_5732() && entity.method_5805() && entity != player, (double)16384.0);
        class_239 finalHit = null;
        double blockDistance = blockHit.method_17783() == class_239.class_240.field_1332 ? startPos.method_1025(blockHit.method_17784()) : Double.MAX_VALUE;
        double d = entityDistance = entityHit != null ? startPos.method_1025(entityHit.method_17784()) : Double.MAX_VALUE;
        if (blockDistance < entityDistance) {
            finalHit = blockHit;
        } else if (entityHit != null) {
            finalHit = entityHit;
        }
        return finalHit;
    }

    private static void processBlockBreaking(class_2338 blockPos, class_2680 blockState, class_1937 world, class_1657 player, class_1799 tool, int energyUsed) {
        MachineCoreEntity coreBlock;
        class_2586 blockEntity;
        if (blockState.method_26214((class_1922)world, blockPos) < 0.0f) {
            return;
        }
        class_3545 stats = blockBreakStats.getOrDefault(player, (class_3545<class_2338, Integer>)new class_3545((Object)class_2338.field_10980, (Object)0));
        stats = !blockPos.equals(stats.method_15442()) ? new class_3545((Object)blockPos, (Object)energyUsed) : new class_3545((Object)blockPos, (Object)((Integer)stats.method_15441() + energyUsed));
        if (blockState.method_26164(TagContent.LASER_ACCELERATED)) {
            blockState.method_26199((class_3218)world, blockPos, world.field_9229);
            ParticleContent.ACCELERATING.spawn(world, class_243.method_24954((class_2382)blockPos));
            stats = new class_3545((Object)blockPos, (Object)-1);
        }
        if ((blockEntity = world.method_8321(blockPos)) instanceof MachineCoreEntity && (coreBlock = (MachineCoreEntity)blockEntity).isEnabled()) {
            blockEntity = (class_2586)coreBlock.getCachedController();
        }
        if (blockEntity != null) {
            EnergyApi.EnergyStorage storageCandidate = EnergyApi.BLOCK.find(world, blockPos, blockState, null, null);
            if (storageCandidate == null && blockEntity instanceof EnergyApi.BlockProvider) {
                EnergyApi.BlockProvider provider = (EnergyApi.BlockProvider)blockEntity;
                storageCandidate = provider.getEnergyStorage(null);
            }
            if (storageCandidate instanceof DynamicEnergyStorage) {
                DynamicEnergyStorage dynamicStorage = (DynamicEnergyStorage)storageCandidate;
                long inserted = dynamicStorage.insertIgnoringLimit(energyUsed, false);
                if (inserted > 0L) {
                    dynamicStorage.update();
                }
                return;
            }
            if (storageCandidate != null) {
                long inserted = storageCandidate.insert(energyUsed, false);
                if (inserted > 0L) {
                    storageCandidate.update();
                }
                return;
            }
        }
        Integer currentInvestedEnergy = (Integer)stats.method_15441();
        int requiredBreakingEnergy = (int)(Math.sqrt(blockState.method_26214((class_1922)world, blockPos)) * (double)LaserArmBlockEntity.BLOCK_BREAK_ENERGY / (double)Oritech.CONFIG.portableLaserConfig.blockBreakSpeed());
        int efficiencyLevel = PortableLaserItem.getEnchantmentLevel(tool, (class_5321<class_1887>)class_1893.field_9131);
        if (efficiencyLevel > 0) {
            requiredBreakingEnergy /= efficiencyLevel + 1;
        }
        float currentProgress = (float)currentInvestedEnergy.intValue() / (float)requiredBreakingEnergy;
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            serverLevel.method_8517(0, blockPos, (int)(currentProgress * 10.0f));
        }
        if (currentInvestedEnergy > requiredBreakingEnergy) {
            stats = new class_3545((Object)blockPos, (Object)0);
            PortableLaserItem.finishBlockBreaking(blockPos, blockState, world, player, tool);
        }
        blockBreakStats.put(player, (class_3545<class_2338, Integer>)stats);
    }

    private static void finishBlockBreaking(class_2338 targetPos, class_2680 targetBlockState, class_1937 world, class_1657 player, class_1799 tool) {
        class_2586 targetEntity = world.method_8321(targetPos);
        List<class_1799> dropped = class_2248.method_9609((class_2680)targetBlockState, (class_3218)((class_3218)world), (class_2338)targetPos, (class_2586)targetEntity, (class_1297)player, (class_1799)tool);
        class_8786<OritechRecipe> blockRecipe = LaserArmBlockEntity.tryGetRecipeOfBlock(targetBlockState, world);
        if (blockRecipe != null) {
            OritechRecipe recipe = (OritechRecipe)blockRecipe.comp_1933();
            int farmedCount = 1;
            dropped = List.of(new class_1799((class_1935)recipe.getResults().get(0).method_7909(), farmedCount));
            ParticleContent.CHARGING.spawn(world, class_243.method_24954((class_2382)targetPos), (Object)1);
        }
        for (class_1799 stack : dropped) {
            if (player.method_31548().method_7394(stack)) continue;
            world.method_8649((class_1297)new class_1542(world, targetPos.method_46558().field_1352, targetPos.method_46558().field_1351, targetPos.method_46558().field_1350, stack));
        }
        try {
            targetBlockState.method_26204().method_9576(world, targetPos, targetBlockState, player);
        }
        catch (Exception exception) {
            Oritech.LOGGER.warn("Laser arm block break event failure when breaking " + String.valueOf(targetBlockState) + " at " + String.valueOf(targetPos) + ": " + exception.getLocalizedMessage());
        }
        world.method_31595(targetPos, world.method_8320(targetPos));
        world.method_8396(null, targetPos, targetBlockState.method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
        world.method_22352(targetPos, false);
    }

    private static void processEntityTarget(class_1657 player, class_1309 target, int damage, class_1799 tool, class_1937 world) {
        if (target.method_5864().equals(class_1299.field_6046) && !((Boolean)target.method_5841().method_12789(class_1548.field_7224)).booleanValue()) {
            target.method_5841().method_12778(class_1548.field_7224, (Object)true);
            return;
        }
        int sharpnessLevel = PortableLaserItem.getEnchantmentLevel(tool, (class_5321<class_1887>)class_1893.field_9118);
        damage = (int)((double)damage * Math.sqrt(sharpnessLevel + 1));
        target.method_5643(new class_1282((class_6880)world.method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42336), (class_1297)player), (float)damage);
    }

    public static int getEnchantmentLevel(class_1799 stack, class_5321<class_1887> enchantment) {
        class_9304 enchantments = (class_9304)stack.method_57825(class_9334.field_49633, (Object)class_9304.field_49385);
        for (class_6880 entry : enchantments.method_57534()) {
            if (!entry.method_40230().isPresent() || !((class_5321)entry.method_40230().get()).equals(enchantment)) continue;
            return enchantments.method_57536(entry);
        }
        return 0;
    }

    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(@NotNull class_1799 oldStack, @NotNull class_1799 newStack, boolean slotChanged) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(@NotNull class_1799 oldStack, @NotNull class_1799 newStack) {
        return false;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        String storedEnergy = TooltipHelper.getEnergyText(this.getStoredEnergy(stack));
        String capacity = TooltipHelper.getEnergyText(this.getEnergyCapacity(stack));
        class_5250 text = class_2561.method_43469((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{storedEnergy, capacity});
        tooltip.add((class_2561)text.method_27692(class_124.field_1065));
        class_5250 miningText = class_2561.method_43471((String)"tooltip.oritech.portable_laser.status.begin").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.isMiningEnabled(stack))).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43471((String)"tooltip.oritech.portable_laser.status.hint").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        tooltip.add((class_2561)miningText);
        boolean showExtra = class_437.method_25441();
        if (showExtra) {
            for (int i = 1; i <= 5; ++i) {
                tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.oritech.portable_laser." + i)).method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.item_extra_info").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        }
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public int method_7837() {
        return 10;
    }

    public boolean isMiningEnabled(class_1799 stack) {
        return (Boolean)stack.method_57825((class_9331)ComponentContent.IS_AOE_ACTIVE.get(), (Object)false);
    }

    public void setMiningEnabled(class_1799 stack, boolean status) {
        stack.method_57379((class_9331)ComponentContent.IS_AOE_ACTIVE.get(), (Object)status);
    }

    public int method_31569(class_1799 stack) {
        return Math.round((float)this.getStoredEnergy(stack) * 100.0f / (float)this.getEnergyCapacity(stack) * 13.0f) / 100;
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31571(class_1799 stack) {
        return 0xFF7007;
    }

    @Override
    public long getEnergyCapacity(class_1799 stack) {
        return Oritech.CONFIG.portableLaserConfig.energyCapacity();
    }

    @Override
    public long getEnergyMaxInput(class_1799 stack) {
        return Oritech.CONFIG.portableLaserConfig.energyCapacity() / 80L;
    }

    @Override
    public long getEnergyMaxOutput(class_1799 stack) {
        return Oritech.CONFIG.portableLaserConfig.energyCapacity() / 80L;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "laser", 0, state -> {
            if (state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                return state.setAndContinue(IDLE);
            }
            return PlayState.CONTINUE;
        }).triggerableAnim("idle", IDLE).triggerableAnim("singleshot", SINGLE_SHOT).triggerableAnim("shooting", SHOOTING).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private PortableLaserRenderer renderer;

            @NotNull
            public class_756 getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PortableLaserRenderer("portable_laser");
                }
                return this.renderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void receiveUsePacket(LaserPlayerUsePacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        PortableLaserItem.onUseTick(player);
    }

    public record LaserPlayerUsePacket() implements class_8710
    {
        public static final class_8710.class_9154<LaserPlayerUsePacket> PACKET_ID = new class_8710.class_9154(Oritech.id("laser_use"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

