/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.fluid.containers;

import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;

public class DelegatingFluidStorage
extends FluidApi.FluidStorage {
    protected final Supplier<FluidApi.FluidStorage> backingStorage;
    protected final BooleanSupplier validPredicate;

    public DelegatingFluidStorage(Supplier<FluidApi.FluidStorage> backingStorage, @Nullable BooleanSupplier validPredicate) {
        this.backingStorage = backingStorage;
        this.validPredicate = validPredicate == null ? () -> true : validPredicate;
    }

    public DelegatingFluidStorage(FluidApi.FluidStorage backingStorage, @Nullable BooleanSupplier validPredicate) {
        this(() -> backingStorage, validPredicate);
    }

    private boolean canUseBackend() {
        return this.validPredicate.getAsBoolean() && this.backingStorage.get() != null;
    }

    @Override
    public long insert(FluidStack toInsert, boolean simulate) {
        if (this.canUseBackend()) {
            return this.backingStorage.get().insert(toInsert, simulate);
        }
        return 0L;
    }

    @Override
    public long extract(FluidStack toExtract, boolean simulate) {
        if (this.canUseBackend()) {
            return this.backingStorage.get().extract(toExtract, simulate);
        }
        return 0L;
    }

    @Override
    public List<FluidStack> getContent() {
        if (this.canUseBackend()) {
            return this.backingStorage.get().getContent();
        }
        return List.of();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setContent(List<FluidStack> content) {
        if (!this.canUseBackend()) return;
        FluidApi.FluidStorage targetStorage = this.backingStorage.get();
        if (targetStorage instanceof FluidApi.SingleSlotStorage) {
            FluidApi.SingleSlotStorage singleSlotContainer = (FluidApi.SingleSlotStorage)targetStorage;
            if (content.size() == 1) {
                singleSlotContainer.setStack(content.getFirst());
                return;
            }
        }
        if (targetStorage instanceof FluidApi.MultiSlotStorage) {
            FluidApi.MultiSlotStorage multiSlotContainer = (FluidApi.MultiSlotStorage)targetStorage;
            if (content.size() == multiSlotContainer.getSlotCount()) {
                int i = 0;
                while (i < multiSlotContainer.getSlotCount()) {
                    multiSlotContainer.setStack(i, content.get(i));
                    ++i;
                }
                return;
            }
        }
        Oritech.LOGGER.error("Using invalid container / snapshot for Delegating Fluid Storage");
    }

    @Override
    public void update() {
        if (this.canUseBackend()) {
            this.backingStorage.get().update();
        }
    }

    @Override
    public long getCapacity() {
        if (this.canUseBackend()) {
            return this.backingStorage.get().getCapacity();
        }
        return 0L;
    }

    @Override
    public boolean supportsInsertion() {
        if (this.canUseBackend()) {
            return this.backingStorage.get().supportsInsertion();
        }
        return false;
    }

    @Override
    public boolean supportsExtraction() {
        if (this.canUseBackend()) {
            return this.backingStorage.get().supportsExtraction();
        }
        return false;
    }

    @Nullable
    public FluidApi.FluidStorage getBackend() {
        if (this.canUseBackend()) {
            return this.backingStorage.get();
        }
        return null;
    }
}

