/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.decorative;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.decorative.TechDoorBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.SoundContent;

public class TechDoorBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty OPENED = BooleanProperty.create((String)"open");
    public static final VoxelShape CLOSED_SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    public static final VoxelShape CLOSED_SHAPE_EAST = Block.box((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public TechDoorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)OPENED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OPENED});
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean isPowered;
        super.neighborChanged(state, world, pos, sourceBlock, sourcePos, notify);
        if (world.isClientSide) {
            return;
        }
        Boolean isOpen = (Boolean)state.getValue((Property)OPENED);
        boolean bl = isPowered = world.hasNeighborSignal(pos) || world.hasNeighborSignal(pos.above());
        if (isOpen == isPowered) {
            return;
        }
        BlockState aboveState = world.getBlockState(pos.above());
        if (!aboveState.getBlock().equals(BlockContent.TECH_DOOR_HINGE)) {
            return;
        }
        TechDoorBlockEntity entity = (TechDoorBlockEntity)world.getBlockEntity(pos);
        if (entity.shouldPlaySoundAgain()) {
            world.playSound(null, pos, SoundContent.PRESS, SoundSource.BLOCKS, Oritech.CONFIG.machineVolumeMultiplier() * 0.18f, 1.3f);
        }
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPENED, (Comparable)Boolean.valueOf(isPowered)));
        world.setBlockAndUpdate(pos.above(), (BlockState)aboveState.setValue((Property)OPENED, (Comparable)Boolean.valueOf(isPowered)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return TechDoorBlock.getClosedShape((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)OPENED)).booleanValue()) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, world, pos, context);
    }

    public static VoxelShape getClosedShape(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> CLOSED_SHAPE_NORTH;
            case Direction.EAST -> CLOSED_SHAPE_EAST;
            case Direction.SOUTH -> CLOSED_SHAPE_SOUTH;
            case Direction.WEST -> CLOSED_SHAPE_WEST;
            default -> Shapes.empty();
        };
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockState belowState = world.getBlockState(pos.below());
        BlockState aboveState = world.getBlockState(pos.above());
        boolean belowValid = belowState.isFaceSturdy((BlockGetter)world, pos.below(), Direction.UP);
        boolean aboveValid = aboveState.is(Blocks.AIR) || aboveState.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"replaceable")));
        return belowValid && aboveValid;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide) {
            world.setBlockAndUpdate(pos.above(), (BlockState)BlockContent.TECH_DOOR_HINGE.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))));
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide) {
            world.setBlockAndUpdate(pos.above(), Blocks.AIR.defaultBlockState());
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TechDoorBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

