/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.pipes.item;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.pipes.ItemFilterBlockEntity;
import rearth.oritech.util.Geometry;

public class ItemFilterBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty TARGET_DIR = DirectionProperty.create((String)"target_dir");
    private static final VoxelShape[] BOUNDING_SHAPES = new VoxelShape[Direction.values().length];

    public ItemFilterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)TARGET_DIR, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TARGET_DIR});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)super.getStateForPlacement(ctx).setValue((Property)TARGET_DIR, (Comparable)ctx.getClickedFace().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ItemFilterBlockEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            ExtendedMenuProvider handler = (ExtendedMenuProvider)world.getBlockEntity(pos);
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)handler);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_filter").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, options);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BOUNDING_SHAPES[((Direction)state.getValue((Property)TARGET_DIR)).get3DDataValue()];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide) {
            ItemFilterBlockEntity entity = (ItemFilterBlockEntity)world.getBlockEntity(pos);
            NonNullList stacks = entity.inventory.heldStacks;
            for (ItemStack stack : stacks) {
                if (stack.isEmpty()) continue;
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
                world.addFreshEntity((Entity)itemEntity);
            }
            entity.inventory.heldStacks.clear();
            entity.inventory.setChanged();
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    static {
        for (Direction facing : Direction.values()) {
            ItemFilterBlock.BOUNDING_SHAPES[facing.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape(Shapes.box((double)0.25, (double)0.25, (double)-0.00375, (double)0.75, (double)0.75, (double)0.125), facing, AttachFace.FLOOR), (VoxelShape[])new VoxelShape[]{Geometry.rotateVoxelShape(Shapes.box((double)0.0, (double)0.375, (double)0.375, (double)0.125, (double)0.625, (double)0.625), facing, AttachFace.FLOOR), Geometry.rotateVoxelShape(Shapes.box((double)0.375, (double)0.875, (double)0.375, (double)0.625, (double)1.0, (double)0.625), facing, AttachFace.FLOOR), Geometry.rotateVoxelShape(Shapes.box((double)0.875, (double)0.375, (double)0.375, (double)1.0, (double)0.625, (double)0.625), facing, AttachFace.FLOOR), Geometry.rotateVoxelShape(Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.125, (double)0.625), facing, AttachFace.FLOOR), Geometry.rotateVoxelShape(Shapes.box((double)0.375, (double)0.375, (double)0.875, (double)0.625, (double)0.625, (double)1.0), facing, AttachFace.FLOOR), Geometry.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.1875, (double)0.1875, (double)0.8125, (double)0.8125, (double)0.8125), facing, AttachFace.FLOOR), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.1875, (double)-0.03125, (double)0.5625, (double)0.8125, (double)0.1875), facing, AttachFace.FLOOR), Geometry.rotateVoxelShape(Shapes.box((double)0.1875, (double)0.4375, (double)-0.03125, (double)0.8125, (double)0.5625, (double)0.1875), facing, AttachFace.FLOOR), Geometry.rotateVoxelShape(Shapes.box((double)0.125, (double)0.4375, (double)0.4375, (double)0.875, (double)0.5625, (double)0.5625), facing, AttachFace.FLOOR), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.125, (double)0.4375, (double)0.5625, (double)0.875, (double)0.5625), facing, AttachFace.FLOOR), Geometry.rotateVoxelShape(Shapes.box((double)0.4375, (double)0.4375, (double)0.8125, (double)0.5625, (double)0.5625, (double)0.875), facing, AttachFace.FLOOR)});
        }
    }
}

