/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class AtomicForgeBlockEntity
extends MultiblockMachineEntity {
    public AtomicForgeBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ATOMIC_FORGE_ENTITY, pos, state, Oritech.CONFIG.processingMachines.atomicForgeData.energyPerTick());
    }

    @Override
    protected boolean canProceed(OritechRecipe value) {
        return this.hasEnoughEnergy() && super.canProceed(value);
    }

    @Override
    protected boolean hasEnoughEnergy() {
        return this.energyStorage.getCapacity() > 10L && this.energyStorage.getAmount() >= this.energyStorage.getCapacity();
    }

    @Override
    protected boolean checkCraftingFinished(OritechRecipe activeRecipe) {
        return this.progress > 0;
    }

    @Override
    protected void useEnergy() {
        this.energyStorage.amount = 0L;
    }

    @Override
    protected Optional<RecipeHolder<OritechRecipe>> getRecipe() {
        Optional<RecipeHolder<OritechRecipe>> result = super.getRecipe();
        if (result.isPresent()) {
            this.energyStorage.setCapacity((long)Oritech.CONFIG.processingMachines.atomicForgeData.energyPerTick() * (long)((OritechRecipe)result.get().value()).getTime());
        } else {
            this.energyStorage.setCapacity(1L);
            this.energyStorage.setAmount(1L);
        }
        return result;
    }

    @Override
    public void updateEnergyContainer() {
    }

    @Override
    public boolean canEnergyStorageChangeWhileGUIOpen() {
        return true;
    }

    @Override
    public ScreenProvider.BarConfiguration getEnergyConfiguration() {
        return new ScreenProvider.BarConfiguration(7, 7, 18, 71);
    }

    @Override
    public float getProgress() {
        return (float)this.energyStorage.getAmount() / (float)this.energyStorage.getCapacity();
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.atomicForgeData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.atomicForgeData.maxEnergyInsertion();
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.ATOMIC_FORGE;
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 3, 3, 1);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38), new ScreenProvider.GuiSlot(1, 83, 21), new ScreenProvider.GuiSlot(2, 83, 54), new ScreenProvider.GuiSlot(3, 117, 36, true));
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.ATOMIC_FORGE_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(Direction direction) {
        return null;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(1, 0, 1), new Vec3i(1, 0, 0), new Vec3i(1, 0, -1), new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, -1));
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return new ArrayList<Vec3i>();
    }

    @Override
    public void saveExtraData(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.worldPosition);
    }
}

