/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.reactor;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleCraftingInventory;

public class ReactorFuelPortEntity
extends BlockEntity
implements ExtendedMenuProvider,
ScreenProvider,
ItemApi.BlockProvider {
    private final InOutInventoryStorage inventory = new InOutInventoryStorage(2, () -> ((ReactorFuelPortEntity)this).setChanged(), new InventorySlotAssignment(0, 1, 1, 0)){

        @Override
        public int insertToSlot(ItemStack addedStack, int slot, boolean simulate) {
            SimpleCraftingInventory craftingInv = new SimpleCraftingInventory(addedStack);
            Optional recipeCandidate = ReactorFuelPortEntity.this.level.getRecipeManager().getRecipeFor((RecipeType)RecipeContent.REACTOR, (RecipeInput)craftingInv, ReactorFuelPortEntity.this.level);
            if (recipeCandidate.isEmpty()) {
                return 0;
            }
            return super.insertToSlot(addedStack, slot, simulate);
        }
    };
    @SyncField(value={SyncType.GUI_TICK})
    public int availableFuel;
    @SyncField(value={SyncType.GUI_TICK})
    public int currentFuelOriginalCapacity;

    public ReactorFuelPortEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.REACTOR_FUEL_PORT_BLOCK_ENTITY, pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("available", this.availableFuel);
        nbt.putInt("capacity", this.currentFuelOriginalCapacity);
        ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.availableFuel = nbt.getInt("available");
        this.currentFuelOriginalCapacity = nbt.getInt("capacity");
        ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
    }

    public boolean tryConsumeFuel(int amount, boolean disabled) {
        int capacity;
        if (this.availableFuel >= amount) {
            this.availableFuel -= amount;
            return true;
        }
        if (disabled) {
            return false;
        }
        ItemStack inputStack = this.inventory.getItem(0);
        if (inputStack.isEmpty()) {
            return false;
        }
        SimpleCraftingInventory craftingInv = new SimpleCraftingInventory(inputStack);
        Optional recipeCandidate = this.level.getRecipeManager().getRecipeFor((RecipeType)RecipeContent.REACTOR, (RecipeInput)craftingInv, this.level);
        if (recipeCandidate.isEmpty()) {
            return false;
        }
        this.currentFuelOriginalCapacity = capacity = ((OritechRecipe)((RecipeHolder)recipeCandidate.get()).value()).getTime();
        this.availableFuel = capacity - amount;
        inputStack.shrink(1);
        this.playLoadingSound();
        return true;
    }

    private void playLoadingSound() {
        float variation = this.level.random.nextFloat() * 0.6f - 0.2f;
        this.level.playSound(null, this.worldPosition, SoundContent.REACTOR_LOADING, SoundSource.BLOCKS, 0.5f, 0.8f + variation);
    }

    public void updateNetwork() {
        RegistryFriendlyByteBuf usedBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), this.level.registryAccess());
        int fieldCount = NetworkManager.encodeFields(this, SyncType.GUI_TICK, (ByteBuf)usedBuf, this.level);
        if (fieldCount == 0) {
            return;
        }
        NetworkManager.sendBlockHandle(this, new NetworkManager.MessagePayload(this.worldPosition, BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)this.getType()), SyncType.GUI_TICK, usedBuf.array()));
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.nullToEmpty((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 55, 35));
    }

    @Override
    public boolean showEnergy() {
        return false;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.FUEL_PORT_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }
}

