/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.recipes;

import dev.architectury.fluid.FluidStack;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.SimpleCraftingInventory;

public class OritechRecipe
implements Recipe<RecipeInput> {
    protected final OritechRecipeType type;
    protected final List<Ingredient> inputs;
    protected final List<ItemStack> results;
    protected final FluidIngredient fluidInput;
    protected final List<FluidStack> fluidOutputs;
    protected final int time;
    public static final OritechRecipe DUMMY = new OritechRecipe(-1, (List<Ingredient>)NonNullList.withSize((int)1, (Object)Ingredient.of((ItemStack[])new ItemStack[]{Items.IRON_INGOT.getDefaultInstance()})), (List<ItemStack>)NonNullList.withSize((int)1, (Object)Items.IRON_BLOCK.getDefaultInstance()), RecipeContent.PULVERIZER, FluidIngredient.EMPTY, FluidStack.empty());

    public OritechRecipe(int time, List<Ingredient> inputs, List<ItemStack> results, OritechRecipeType type, @Nullable FluidIngredient fluidInput, @Nullable FluidStack fluidOutput) {
        this(time, inputs, results, type, fluidInput, fluidOutput == null || fluidOutput.isEmpty() ? List.of() : List.of(fluidOutput));
    }

    public OritechRecipe(int time, List<Ingredient> inputs, List<ItemStack> results, OritechRecipeType type, @Nullable FluidIngredient fluidInput, List<FluidStack> fluidOutputs) {
        this.type = type;
        this.results = results;
        this.inputs = inputs;
        this.time = time;
        if (fluidInput == null) {
            fluidInput = FluidIngredient.EMPTY;
        }
        this.fluidInput = fluidInput.withAmount(fluidInput.amount());
        this.fluidOutputs = fluidOutputs;
    }

    public OritechRecipe(int time, List<Ingredient> inputs, List<ItemStack> results, OritechRecipeType type, @Nullable FluidIngredient fluidInput, Fluid outVariant, long outAmount) {
        this(time, inputs, results, type, fluidInput, FluidStack.create((Fluid)outVariant, (long)outAmount));
    }

    public OritechRecipe(int time, List<Ingredient> inputs, List<ItemStack> results, OritechRecipeType type, Fluid inVariant, long inAmount, Fluid outVariant, long outAmount) {
        this(time, inputs, results, type, new FluidIngredient().withContent(inVariant).withAmount(inAmount), FluidStack.create((Fluid)outVariant, (long)outAmount));
    }

    public boolean matches(RecipeInput input, Level world) {
        if (world.isClientSide) {
            return false;
        }
        if (this.inputs.size() > 1) {
            return this.complexMatch(input);
        }
        if (input.size() < this.inputs.size()) {
            return false;
        }
        List<Ingredient> ingredients = this.getInputs();
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient entry = ingredients.get(i);
            if (entry.test(input.getItem(i))) continue;
            return false;
        }
        return true;
    }

    private boolean complexMatch(RecipeInput input) {
        if (!(input instanceof SimpleCraftingInventory)) {
            return false;
        }
        SimpleCraftingInventory simpleInventory = (SimpleCraftingInventory)input;
        ItemStack[] copiedInv = (ItemStack[])simpleInventory.getItems().stream().map(ItemStack::copy).toArray(ItemStack[]::new);
        for (Ingredient ingredient : this.getInputs()) {
            boolean found = false;
            for (ItemStack heldStack : copiedInv) {
                if (!ingredient.test(heldStack)) continue;
                heldStack.shrink(1);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider lookup) {
        return null;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registriesLookup) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return this.type;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeType<?> getType() {
        return this.type;
    }

    public String toString() {
        return "OritechRecipe{type=" + String.valueOf((Object)this.type) + ", inputs=" + String.valueOf(this.inputs) + ", results=" + String.valueOf(this.results) + ", fluidInput=" + String.valueOf(this.fluidInput) + ", time=" + this.time + "}";
    }

    public int getTime() {
        return this.time;
    }

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])this.inputs.toArray(Ingredient[]::new)));
    }

    public List<ItemStack> getResults() {
        return this.results;
    }

    public OritechRecipeType getOriType() {
        return this.type;
    }

    @Nullable
    public FluidIngredient getFluidInput() {
        return this.fluidInput;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }
}

