/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.world.features.oil;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import rearth.oritech.Oritech;
import rearth.oritech.init.world.features.oil.OilSpringFeatureConfig;

public class OilSpringFeature
extends Feature<OilSpringFeatureConfig> {
    public OilSpringFeature(Codec<OilSpringFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<OilSpringFeatureConfig> context) {
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        if (world.isClientSide()) {
            return false;
        }
        BlockPos testPos = new BlockPos((Vec3i)origin);
        for (int y = 0; y < world.getHeight(); ++y) {
            if (!world.getBlockState(testPos = testPos.above()).is(BlockTags.DIRT) && !world.getBlockState(testPos).is(BlockTags.SAND) || !world.getBlockState(testPos.above()).is(Blocks.AIR)) continue;
            this.placeStructure(testPos, context);
            return true;
        }
        return false;
    }

    private void placeStructure(BlockPos surfacePos, FeaturePlaceContext<OilSpringFeatureConfig> context) {
        int i;
        RandomSource random = context.random();
        OilSpringFeatureConfig config = (OilSpringFeatureConfig)context.config();
        BlockState state = ((Block)BuiltInRegistries.BLOCK.get(config.blockId())).defaultBlockState();
        WorldGenLevel world = context.level();
        int variation = random.nextIntBetweenInclusive((int)((float)(-config.number()) * 0.5f), config.number());
        int height = Math.max(config.number() + variation, 13);
        int depth = height * 2;
        BlockPos bottomEnd = surfacePos.below(depth);
        BlockPos center = bottomEnd.offset(random.nextIntBetweenInclusive(-2, 2), random.nextIntBetweenInclusive(-3, 3), random.nextIntBetweenInclusive(0, height / 2));
        ImprovedNoise perlinSampler = new ImprovedNoise(random);
        for (int x = 0; x < depth + 2; ++x) {
            for (int y = 0; y < depth + 2; ++y) {
                for (int z = 0; z < depth + 2; ++z) {
                    double noiseOffset;
                    BlockPos point = new BlockPos(x - height, y - height, z - height).offset((Vec3i)bottomEnd);
                    double distance = Math.sqrt(point.distSqr((Vec3i)center));
                    if (distance <= (double)height + (noiseOffset = perlinSampler.noise((double)x, (double)y, (double)z)) - 2.0) {
                        world.setBlock(point, state, 16);
                        continue;
                    }
                    if (!(distance <= (double)height + noiseOffset)) continue;
                    world.setBlock(point, Blocks.STONE.defaultBlockState(), 16);
                }
            }
        }
        if (Oritech.CONFIG.easyFindFeatures()) {
            for (i = 0; i < height; ++i) {
                world.setBlock(surfacePos.above(i), state, 16);
            }
        }
        for (i = 1; i < depth + 5; ++i) {
            world.setBlock(surfacePos.below(i), state, 16);
        }
    }
}

