/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.armor;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleItemFluidStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.LaserArmRenderer;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.FluidContent;
import rearth.oritech.item.tools.armor.JetpackItem;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.TooltipHelper;

public interface BaseJetpackItem
extends OritechEnergyItem,
FluidApi.ItemProvider {
    public boolean requireUpward();

    public int getRfUsage();

    public int getFuelUsage();

    public long getFuelCapacity();

    public float getSpeed();

    default public boolean requireTakeoff() {
        return true;
    }

    default public void tickJetpack(ItemStack stack, Entity entity, Level world) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean isEquipped = player.getItemBySlot(EquipmentSlot.CHEST).equals(stack);
        if (!isEquipped) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        boolean up = client.options.keyJump.isDown();
        boolean forward = client.options.keyUp.isDown();
        boolean backward = client.options.keyDown.isDown();
        boolean left = client.options.keyLeft.isDown();
        boolean right = client.options.keyRight.isDown();
        boolean horizontal = forward || backward || left || right;
        boolean upOnly = up && !horizontal;
        boolean isActive = up;
        if (!this.requireUpward()) {
            boolean bl = isActive = up || horizontal;
        }
        if (this.requireTakeoff() && !BaseJetpackItem.isJetpackStarted(player, world, up)) {
            return;
        }
        if (!isActive || player.onGround() || player.isUnderWater()) {
            return;
        }
        float powerMultiplier = this.getSpeed();
        if (this.tryUseFluid(stack)) {
            powerMultiplier *= 2.5f;
        } else if (!this.tryUseEnergy(stack, this.getRfUsage(), player)) {
            return;
        }
        if (up) {
            BaseJetpackItem.processUpwardsMotion(player, powerMultiplier, upOnly);
        } else {
            powerMultiplier *= 0.7f;
        }
        if (forward || backward) {
            BaseJetpackItem.processForwardMotion(player, forward, powerMultiplier);
        }
        if (left || right) {
            BaseJetpackItem.processSideMotion(player, right, powerMultiplier);
        }
        FluidStack fluidStack = this.getStoredFluid(stack);
        ResourceLocation fluid = BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid());
        NetworkManager.sendToServer(new JetpackItem.JetpackUsageUpdatePacket(this.getStoredEnergy(stack), fluid.toString(), fluidStack.getAmount()));
        Vec3 playerForward = player.getForward();
        Vec3 playerRight = playerForward.normalize().yRot(-90.0f);
        Vec3 particleCenter = player.getEyePosition().add(0.0, -1.1, 0.0).subtract(playerForward.scale((double)0.2f));
        Vec3 particlePosA = particleCenter.add(playerRight.scale((double)0.4f));
        Vec3 particlePosB = particleCenter.add(playerRight.scale((double)-0.4f));
        Vec3 direction = new Vec3(0.0, -1.0, 0.0);
        if (forward) {
            direction = playerForward.normalize().scale(-1.0).add(0.0, -1.0, 0.0);
        }
        ParticleContent.JETPACK_EXHAUST.spawn(world, particlePosA, (Object)direction);
        ParticleContent.JETPACK_EXHAUST.spawn(world, particlePosB, (Object)direction);
    }

    private static boolean isJetpackStarted(Player player, Level world, boolean up) {
        boolean grounded;
        boolean bl = grounded = player.onGround() || player.isUnderWater();
        if (grounded) {
            JetpackItem.LAST_GROUND_CONTACT = world.getGameTime();
            JetpackItem.PRESSED_SPACE = false;
            return false;
        }
        long flightTime = world.getGameTime() - JetpackItem.LAST_GROUND_CONTACT;
        if (flightTime < 5L) {
            return false;
        }
        if (up) {
            JetpackItem.PRESSED_SPACE = true;
        }
        return JetpackItem.PRESSED_SPACE;
    }

    private static void processUpwardsMotion(Player player, float powerMultiplier, boolean upOnly) {
        Vec3 velocity = player.getKnownMovement();
        double verticalMultiplier = LaserArmRenderer.lerp(powerMultiplier, 1.0, (double)0.6f);
        double power = (double)0.13f * verticalMultiplier;
        float dampeningFactor = 1.7f;
        if (!upOnly) {
            power *= (double)0.7f;
        }
        double speed = Math.max(velocity.y, 0.8);
        double addedVelocity = power / Math.pow(speed, dampeningFactor);
        player.setDeltaMovement(velocity.add(0.0, addedVelocity, 0.0));
    }

    private static void processSideMotion(Player player, boolean right, float powerMultiplier) {
        int modifier = right ? 1 : -1;
        float power = 0.04f * powerMultiplier;
        Vec3 movement = player.getKnownMovement();
        Vec3 horizontalMovement = new Vec3(movement.x, 0.0, movement.z);
        Vec3 playerForward = player.getForward();
        playerForward = new Vec3(playerForward.x, 0.0, playerForward.z).normalize();
        Vec3 playerRight = playerForward.yRot(-90.0f);
        horizontalMovement = horizontalMovement.add(playerRight.scale((double)((float)modifier * power)));
        player.setDeltaMovement(horizontalMovement.x, movement.y, horizontalMovement.z);
    }

    private static void processForwardMotion(Player player, boolean forward, float powerMultiplier) {
        double modifier = forward ? 1.0 : -0.4;
        float power = 0.06f * powerMultiplier;
        Vec3 movement = player.getKnownMovement();
        Vec3 horizontalMovement = new Vec3(movement.x, 0.0, movement.z);
        Vec3 playerForward = player.getForward();
        playerForward = new Vec3(playerForward.x, 0.0, playerForward.z).normalize();
        horizontalMovement = horizontalMovement.add(playerForward.scale(modifier * (double)power));
        player.setDeltaMovement(horizontalMovement.x, movement.y, horizontalMovement.z);
    }

    default public boolean tryUseFluid(ItemStack stack) {
        FluidStack fluidStack = this.getStoredFluid(stack);
        if (fluidStack.getAmount() < (long)this.getFuelUsage() || !this.isValidFuel(fluidStack.getFluid())) {
            return false;
        }
        FluidStack res = FluidStack.create((Fluid)fluidStack.getFluid(), (long)(fluidStack.getAmount() - (long)this.getFuelUsage()));
        stack.set((DataComponentType)ComponentContent.STORED_FLUID.get(), (Object)res);
        return true;
    }

    default public FluidStack getStoredFluid(ItemStack stack) {
        return (FluidStack)stack.getOrDefault((DataComponentType)ComponentContent.STORED_FLUID.get(), (Object)FluidStack.empty());
    }

    default public void addJetpackTooltip(ItemStack stack, List<Component> tooltip, boolean includeEnergy) {
        MutableComponent text = Component.translatable((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{TooltipHelper.getEnergyText(this.getStoredEnergy(stack)), TooltipHelper.getEnergyText(this.getEnergyCapacity(stack))});
        if (includeEnergy) {
            tooltip.add((Component)text.withStyle(ChatFormatting.GOLD));
        }
        FluidStack container = this.getStoredFluid(stack);
        MutableComponent fluidText = Component.translatable((String)"tooltip.oritech.jetpack_fuel", (Object[])new Object[]{container.getAmount() * 1000L / FluidStackHooks.bucketAmount(), this.getFuelCapacity() * 1000L / FluidStackHooks.bucketAmount(), FluidStackHooks.getName((FluidStack)container).getString()});
        tooltip.add((Component)fluidText);
    }

    default public int getJetpackBarColor(ItemStack stack) {
        FluidStack fluidStack = this.getStoredFluid(stack);
        if (fluidStack.getAmount() > (long)this.getFuelUsage() && this.isValidFuel(fluidStack.getFluid())) {
            return 12254211;
        }
        return 0xFF7007;
    }

    default public int getJetpackBarStep(ItemStack stack) {
        FluidStack fluidStack = this.getStoredFluid(stack);
        if (fluidStack.getAmount() > (long)this.getFuelUsage() && this.isValidFuel(fluidStack.getFluid())) {
            long fillPercent = fluidStack.getAmount() * 100L / this.getFuelCapacity();
            return Math.round(fillPercent * 13L) / 100;
        }
        return Math.round((float)this.getStoredEnergy(stack) * 100.0f / (float)this.getEnergyCapacity(stack) * 13.0f) / 100;
    }

    default public boolean isValidFuel(Fluid variant) {
        return variant.isSame((Fluid)FluidContent.STILL_FUEL.get());
    }

    @Override
    default public FluidApi.SingleSlotStorage getFluidStorage(ItemStack stack) {
        return new SimpleItemFluidStorage(this.getFuelCapacity(), stack){

            @Override
            public long insert(FluidStack toInsert, boolean simulate) {
                boolean valid = BaseJetpackItem.this.isValidFuel(toInsert.getFluid());
                if (!valid) {
                    return 0L;
                }
                return super.insert(toInsert, simulate);
            }
        };
    }
}

