/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.recipe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.init.recipes.AugmentDataRecipe;
import rearth.oritech.init.recipes.AugmentDataRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.SizedIngredient;

public class AugmentRecipeBuilder {
    private final AugmentDataRecipeType type;
    private final String resourcePath;
    private boolean toggleable;
    private List<SizedIngredient> researchCosts;
    private List<SizedIngredient> applyCosts;
    private List<ResourceLocation> requirements;
    private ResourceLocation requiredStation;
    private int uiX;
    private int uiY;
    private int time;
    private long rfCost;
    @Nullable
    private AugmentDataRecipe.EffectDefinition effectDefinition;
    @Nullable
    private AugmentDataRecipe.ModifierDefinition modifierDefinition;
    @Nullable
    private AugmentDataRecipe.CustomAugmentDefinition customAugmentDefinition;

    private AugmentRecipeBuilder(AugmentDataRecipeType type, String resourcePath) {
        this.type = type;
        this.resourcePath = resourcePath;
    }

    public static AugmentRecipeBuilder build() {
        return new AugmentRecipeBuilder(RecipeContent.AUGMENT_DATA, "augment");
    }

    public AugmentRecipeBuilder researchCost(List<SizedIngredient> researchCosts) {
        if (this.researchCosts == null) {
            this.researchCosts = new ArrayList<SizedIngredient>();
        }
        this.researchCosts.addAll(researchCosts);
        return this;
    }

    public AugmentRecipeBuilder researchCost(SizedIngredient researchCost) {
        if (this.researchCosts == null) {
            this.researchCosts = new ArrayList<SizedIngredient>();
        }
        this.researchCosts.add(researchCost);
        return this;
    }

    public AugmentRecipeBuilder researchCost(Ingredient researchCost, int count) {
        return this.researchCost(new SizedIngredient(count, researchCost));
    }

    public AugmentRecipeBuilder researchCost(Ingredient researchCost) {
        return this.researchCost(researchCost, 1);
    }

    public AugmentRecipeBuilder researchCost(TagKey<Item> researchCostTag, int count) {
        return this.researchCost(Ingredient.of(researchCostTag), count);
    }

    public AugmentRecipeBuilder researchCost(TagKey<Item> researchCostTag) {
        return this.researchCost(researchCostTag, 1);
    }

    public AugmentRecipeBuilder researchCost(ItemLike researchCost, int count) {
        return this.researchCost(Ingredient.of((ItemLike[])new ItemLike[]{researchCost}), count);
    }

    public AugmentRecipeBuilder researchCost(ItemLike researchCost) {
        return this.researchCost(researchCost, 1);
    }

    public AugmentRecipeBuilder applyCost(List<SizedIngredient> applyCost) {
        if (this.applyCosts == null) {
            this.applyCosts = new ArrayList<SizedIngredient>();
        }
        this.applyCosts.addAll(applyCost);
        return this;
    }

    public AugmentRecipeBuilder applyCost(SizedIngredient applyCost) {
        if (this.applyCosts == null) {
            this.applyCosts = new ArrayList<SizedIngredient>();
        }
        this.applyCosts.add(applyCost);
        return this;
    }

    public AugmentRecipeBuilder applyCost(Ingredient applyCost, int count) {
        return this.applyCost(new SizedIngredient(count, applyCost));
    }

    public AugmentRecipeBuilder applyCost(Ingredient applyCost) {
        return this.applyCost(applyCost, 1);
    }

    public AugmentRecipeBuilder applyCost(TagKey<Item> applyCostTag, int count) {
        return this.applyCost(Ingredient.of(applyCostTag), count);
    }

    public AugmentRecipeBuilder applyCost(TagKey<Item> applyCostTag) {
        return this.applyCost(applyCostTag, 1);
    }

    public AugmentRecipeBuilder applyCost(ItemLike applyCost, int count) {
        return this.applyCost(Ingredient.of((ItemLike[])new ItemLike[]{applyCost}), count);
    }

    public AugmentRecipeBuilder applyCost(ItemLike applyCost) {
        return this.applyCost(applyCost, 1);
    }

    public AugmentRecipeBuilder requirement(List<ResourceLocation> requirements) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<ResourceLocation>();
        }
        this.requirements.addAll(requirements);
        return this;
    }

    public AugmentRecipeBuilder requirement(ResourceLocation requirement) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<ResourceLocation>();
        }
        this.requirements.add(requirement);
        return this;
    }

    public AugmentRecipeBuilder requiredStation(ResourceLocation requiredStation) {
        this.requiredStation = requiredStation;
        return this;
    }

    public AugmentRecipeBuilder uiX(int uiX) {
        this.uiX = uiX;
        return this;
    }

    public AugmentRecipeBuilder uiY(int uiY) {
        this.uiY = uiY;
        return this;
    }

    public AugmentRecipeBuilder time(int time) {
        this.time = time;
        return this;
    }

    public AugmentRecipeBuilder rfCost(long rfCost) {
        this.rfCost = rfCost;
        return this;
    }

    public AugmentRecipeBuilder toggleable(boolean toggleable) {
        this.toggleable = toggleable;
        return this;
    }

    public AugmentRecipeBuilder toggleable() {
        this.toggleable = true;
        return this;
    }

    public AugmentRecipeBuilder effectDefinition(Holder<MobEffect> entry, int amplifier) {
        this.effectDefinition = new AugmentDataRecipe.EffectDefinition(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)entry.value())), amplifier);
        return this;
    }

    public AugmentRecipeBuilder modifierDefinition(Holder<Attribute> entry, float amount, AttributeModifier.Operation op) {
        this.modifierDefinition = new AugmentDataRecipe.ModifierDefinition(BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)entry.value())), op.id(), amount);
        return this;
    }

    public AugmentRecipeBuilder customAugmentDefinition(ResourceLocation customAugmentId) {
        this.customAugmentDefinition = new AugmentDataRecipe.CustomAugmentDefinition(customAugmentId);
        return this;
    }

    private void validate(ResourceLocation id) throws IllegalStateException {
        if (this.researchCosts == null || this.researchCosts.isEmpty()) {
            throw new IllegalStateException("Research costs expected for recipe " + String.valueOf(id) + " (type " + String.valueOf((Object)this.type) + ")");
        }
        if (this.applyCosts == null || this.applyCosts.isEmpty()) {
            throw new IllegalStateException("Apply costs expected for recipe " + String.valueOf(id) + " (type " + String.valueOf((Object)this.type) + ")");
        }
        if (this.requiredStation == null) {
            throw new IllegalStateException("required station expected for recipe " + String.valueOf(id) + " (type " + String.valueOf((Object)this.type) + ")");
        }
        if ((this.effectDefinition != null ? 1 : 0) + (this.modifierDefinition != null ? 1 : 0) + (this.customAugmentDefinition != null ? 1 : 0) != 1) {
            throw new IllegalStateException("Exactly one of effectDefinition, modifierDefinition, or customAugmentDefinition must be set for recipe " + String.valueOf(id) + " (type " + String.valueOf((Object)this.type) + ")");
        }
    }

    public void export(RecipeOutput exporter, String suffix) {
        ResourceLocation id = Oritech.id(this.resourcePath + "/" + suffix);
        this.validate(id);
        exporter.accept(id, (Recipe)new AugmentDataRecipe(this.type, this.toggleable, this.researchCosts, this.applyCosts, this.requirements != null ? this.requirements : List.of(), this.requiredStation, this.uiX, this.uiY, this.time, this.rfCost, this.effectDefinition, this.modifierDefinition, this.customAugmentDefinition), null);
    }
}

