/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.recipe;

import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import rearth.oritech.Oritech;
import rearth.oritech.api.recipe.AssemblerRecipeBuilder;
import rearth.oritech.api.recipe.AtomicForgeRecipeBuilder;
import rearth.oritech.api.recipe.AugmentRecipeBuilder;
import rearth.oritech.api.recipe.BioGeneratorRecipeBuilder;
import rearth.oritech.api.recipe.CentrifugeFluidRecipeBuilder;
import rearth.oritech.api.recipe.CentrifugeRecipeBuilder;
import rearth.oritech.api.recipe.CoolerRecipeBuilder;
import rearth.oritech.api.recipe.DeepDrillRecipeBuilder;
import rearth.oritech.api.recipe.FoundryRecipeBuilder;
import rearth.oritech.api.recipe.FuelGeneratorRecipeBuilder;
import rearth.oritech.api.recipe.GrinderRecipeBuilder;
import rearth.oritech.api.recipe.LaserRecipeBuilder;
import rearth.oritech.api.recipe.LavaGeneratorRecipeBuilder;
import rearth.oritech.api.recipe.ParticleCollisionRecipeBuilder;
import rearth.oritech.api.recipe.PulverizerRecipeBuilder;
import rearth.oritech.api.recipe.ReactorGeneratorRecipeBuilder;
import rearth.oritech.api.recipe.RefineryRecipeBuilder;
import rearth.oritech.api.recipe.SteamGeneratorRecipeBuilder;
import rearth.oritech.api.recipe.util.MetalProcessingChainBuilder;
import rearth.oritech.api.recipe.util.RecipeHelpers;
import rearth.oritech.block.entity.augmenter.api.CustomAugmentsCollection;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.FluidContent;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.ToolsContent;
import rearth.oritech.util.TagUtils;

public class OritechRecipeGenerator
extends RecipeProvider {
    public OritechRecipeGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, registriesFuture);
    }

    public void buildRecipes(RecipeOutput exporter) {
        this.addDeepDrillOres(exporter);
        this.addFuels(exporter);
        this.addFluidProcessing(exporter);
        this.addBiomass(exporter);
        this.addEquipment(exporter);
        this.addMachines(exporter);
        this.addComponents(exporter);
        this.addOreChains(exporter);
        this.addAlloys(exporter);
        this.addParticleCollisions(exporter);
        this.addDusts(exporter);
        this.addDecorative(exporter);
        this.addVanillaAdditions(exporter);
        this.addDyes(exporter);
        this.addCompactingRecipes(exporter);
        this.addReactorFuels(exporter);
        this.addLaserTransformations(exporter);
        this.addUraniumProcessing(exporter);
        this.addReactorBlocks(exporter);
        this.addAugmentRecipes(exporter);
    }

    private void addVanillaAdditions(RecipeOutput exporter) {
        AssemblerRecipeBuilder.build().input((ItemLike)Items.HONEYCOMB).input(TagContent.BIOMASS).input(TagContent.BIOMASS).input(TagContent.BIOMASS).result(Items.SLIME_BALL).timeMultiplier(0.8f).export(exporter, "slime");
        AssemblerRecipeBuilder.build().input((ItemLike)Items.GUNPOWDER).input((ItemLike)Items.BLAZE_POWDER).input((TagKey<Item>)ItemTags.COALS).input((TagKey<Item>)ItemTags.COALS).result(Items.FIRE_CHARGE, 4).timeMultiplier(0.8f).export(exporter, "fireball");
        AssemblerRecipeBuilder.build().input((ItemLike)Items.BLAZE_POWDER).input((ItemLike)Items.BLAZE_POWDER).input((ItemLike)Items.BLAZE_POWDER).input((ItemLike)Items.BLAZE_POWDER).result(Items.BLAZE_ROD).timeMultiplier(0.8f).export(exporter, "blazerod");
        CentrifugeRecipeBuilder.build().input((ItemLike)Items.SCULK).result(ItemContent.ENDERIC_COMPOUND).timeMultiplier(4.0f).export(exporter, "endericsculk");
        AssemblerRecipeBuilder.build().input(TagUtils.cItemTag("gems/amethyst")).input(TagUtils.cItemTag("gems/amethyst")).input((ItemLike)ItemContent.ENDERIC_COMPOUND).input((ItemLike)ItemContent.OVERCHARGED_CRYSTAL).result(Items.BUDDING_AMETHYST).time(160).export(exporter, "amethystbud");
        FoundryRecipeBuilder.build().input(TagUtils.cItemTag("ingots/gold")).input((ItemLike)Items.NETHERITE_SCRAP).result(Items.NETHERITE_INGOT).export(exporter, "netherite");
        AssemblerRecipeBuilder.build().input((ItemLike)Items.PAPER).input((ItemLike)Items.PAPER).input((ItemLike)Items.PAPER).input(TagUtils.cItemTag("leathers")).result(Items.BOOK, 2).timeMultiplier(0.8f).export(exporter, "book");
        AtomicForgeRecipeBuilder.build().input((ItemLike)Items.DEEPSLATE).input((ItemLike)ItemContent.DURATIUM_INGOT).input((ItemLike)ItemContent.DURATIUM_INGOT).result(Items.REINFORCED_DEEPSLATE).time(100).export(exporter, "reinfdeepslate");
        PulverizerRecipeBuilder.build().input(TagUtils.cItemTag("cobblestones")).result(Items.GRAVEL).addToGrinder().export(exporter, "gravel");
        PulverizerRecipeBuilder.build().input((ItemLike)Items.GRAVEL).result(Items.SAND).addToGrinder().export(exporter, "sand");
        PulverizerRecipeBuilder.build().input(TagUtils.cItemTag("sandstone/blocks")).result(Items.SAND).addToGrinder().export(exporter, "sand_from_sandstone");
        PulverizerRecipeBuilder.build().input(TagUtils.cItemTag("sandstone/red_blocks")).result(Items.RED_SAND).addToGrinder().export(exporter, "red_sand");
        CentrifugeFluidRecipeBuilder.build().input((TagKey<Item>)ItemTags.DIRT).result(Items.CLAY).fluidInput((Fluid)Fluids.WATER, 0.25f).export(exporter, "clay");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DIRT, (int)2).define(Character.valueOf('s'), ItemTags.SAND).define(Character.valueOf('b'), TagContent.BIOMASS).pattern("sb").pattern("bs").unlockedBy("has_biomass", OritechRecipeGenerator.has(TagContent.BIOMASS)).save(exporter, Oritech.id("dirt_from_sand_and_biomass"));
        PulverizerRecipeBuilder.build().input((ItemLike)Items.DRIPSTONE_BLOCK).result(Items.POINTED_DRIPSTONE, 4).addToGrinder().export(exporter, "dripstone");
        AssemblerRecipeBuilder.build().input((TagKey<Item>)ItemTags.LOGS).input((ItemLike)Items.GLOWSTONE).input((ItemLike)Items.GLOWSTONE).input((ItemLike)Items.GLOWSTONE).result(Items.SHROOMLIGHT).timeMultiplier(0.8f).export(exporter, "shroomlight");
        PulverizerRecipeBuilder.build().input((ItemLike)Items.PRISMARINE_SHARD).result(Items.PRISMARINE_CRYSTALS, 2).addToGrinder().export(exporter, "prismarine");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_NETHERITE_SCRAP).result(Items.NETHERITE_SCRAP).addToGrinder().export(exporter, "recycle/netherite_scrap");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_DIAMOND).result(Items.DIAMOND).addToGrinder().export(exporter, "recycle/diamond");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_IRON_DUST).result(ItemContent.IRON_DUST).addToGrinder().export(exporter, "recycle/iron_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_SMALL_IRON_DUST).result(ItemContent.SMALL_IRON_DUST).export(exporter, "recycle/small_iron_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_GOLD_DUST).result(ItemContent.GOLD_DUST).export(exporter, "recycle/gold_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_SMALL_GOLD_DUST).result(ItemContent.SMALL_GOLD_DUST).export(exporter, "recycle/small_gold_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_COPPER_DUST).result(ItemContent.COPPER_DUST).export(exporter, "recycle/copper_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_SMALL_COPPER_DUST).result(ItemContent.SMALL_COPPER_DUST).export(exporter, "recycle/small_copper_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_2_QUARTZ_DUST).result(ItemContent.QUARTZ_DUST, 2).export(exporter, "recycle/2_quartz_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_4_QUARTZ_DUST).result(ItemContent.QUARTZ_DUST, 4).export(exporter, "recycle/4_quartz_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_REDSTONE_DUST).result(Items.REDSTONE).export(exporter, "recycle/redstone_dust");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_GRAVEL).result(Items.GRAVEL).export(exporter, "recycle/gravel");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_SAND).result(Items.SAND).export(exporter, "recycle/sand");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_RED_SAND).result(Items.RED_SAND).export(exporter, "recycle/red_sand");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_STRING).result(Items.STRING, 3).export(exporter, "recycle/string");
        PulverizerRecipeBuilder.build().input(TagContent.RECYCLES_TO_BIOMASS).result(ItemContent.BIOMASS).export(exporter, "recycle/biomass");
    }

    private void addDyes(RecipeOutput exporter) {
        PulverizerRecipeBuilder.build().input(TagContent.RAW_WHITE_DYE).result(Items.WHITE_DYE).addToGrinder().export(exporter, "dyes/white");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_LIGHT_GRAY_DYE).result(Items.LIGHT_GRAY_DYE).addToGrinder().export(exporter, "dyes/light_gray");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_BLACK_DYE).result(Items.BLACK_DYE).addToGrinder().export(exporter, "dyes/black");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_RED_DYE).result(Items.RED_DYE).addToGrinder().export(exporter, "dyes/red");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_ORANGE_DYE).result(Items.ORANGE_DYE).addToGrinder().export(exporter, "dyes/orange");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_YELLOW_DYE).result(Items.YELLOW_DYE).addToGrinder().export(exporter, "dyes/yellow");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_CYAN_DYE).result(Items.CYAN_DYE).addToGrinder().export(exporter, "dyes/cyan");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_BLUE_DYE).result(Items.BLUE_DYE).addToGrinder().export(exporter, "dyes/blue");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_MAGENTA_DYE).result(Items.MAGENTA_DYE).addToGrinder().export(exporter, "dyes/magenta");
        PulverizerRecipeBuilder.build().input(TagContent.RAW_PINK_DYE).result(Items.PINK_DYE).addToGrinder().export(exporter, "dyes/pink");
    }

    private void addDeepDrillOres(RecipeOutput exporter) {
        DeepDrillRecipeBuilder.build().input((ItemLike)BlockContent.RESOURCE_NODE_REDSTONE).result(Items.REDSTONE).export(exporter, "redstone");
        DeepDrillRecipeBuilder.build().input((ItemLike)BlockContent.RESOURCE_NODE_LAPIS).result(Items.LAPIS_LAZULI).export(exporter, "lapis");
        DeepDrillRecipeBuilder.build().input((ItemLike)BlockContent.RESOURCE_NODE_IRON).result(Items.RAW_IRON).export(exporter, "iron");
        DeepDrillRecipeBuilder.build().input((ItemLike)BlockContent.RESOURCE_NODE_COAL).result(Items.COAL).export(exporter, "coal");
        DeepDrillRecipeBuilder.build().input((ItemLike)BlockContent.RESOURCE_NODE_COPPER).result(Items.RAW_COPPER).export(exporter, "copper");
        DeepDrillRecipeBuilder.build().input((ItemLike)BlockContent.RESOURCE_NODE_GOLD).result(Items.RAW_GOLD).export(exporter, "gold");
        DeepDrillRecipeBuilder.build().input((ItemLike)BlockContent.RESOURCE_NODE_EMERALD).result(Items.EMERALD).export(exporter, "emerald");
        DeepDrillRecipeBuilder.build().input((ItemLike)BlockContent.RESOURCE_NODE_DIAMOND).result(Items.DIAMOND).export(exporter, "diamond");
        DeepDrillRecipeBuilder.build().input((ItemLike)BlockContent.RESOURCE_NODE_NICKEL).result(ItemContent.RAW_NICKEL).export(exporter, "nickel");
        DeepDrillRecipeBuilder.build().input((ItemLike)BlockContent.RESOURCE_NODE_PLATINUM).result(ItemContent.RAW_PLATINUM).export(exporter, "platinum");
        DeepDrillRecipeBuilder.build().input((ItemLike)BlockContent.RESOURCE_NODE_URANIUM).result(ItemContent.RAW_URANIUM).export(exporter, "uranium");
    }

    private void addFuels(RecipeOutput exporter) {
        BioGeneratorRecipeBuilder.build().input(TagContent.BIOMATTER).timeInSeconds(15).export(exporter, "rawbio");
        BioGeneratorRecipeBuilder.build().input((ItemLike)ItemContent.PACKED_WHEAT).timeInSeconds(200).export(exporter, "packedwheat");
        BioGeneratorRecipeBuilder.build().input(TagContent.BIOMASS).timeInSeconds(25).export(exporter, "biomass");
        BioGeneratorRecipeBuilder.build().input((ItemLike)ItemContent.SOLID_BIOFUEL).timeInSeconds(160).export(exporter, "solidbiomass");
        BioGeneratorRecipeBuilder.build().input(TagContent.BIOMASS_BLOCK).timeInSeconds(270).export(exporter, "biomassblock");
        BioGeneratorRecipeBuilder.build().input((ItemLike)ItemContent.RAW_BIOPOLYMER).timeInSeconds(300).export(exporter, "polymer");
        BioGeneratorRecipeBuilder.build().input((ItemLike)ItemContent.UNHOLY_INTELLIGENCE).timeInSeconds(3000).export(exporter, "vex");
        LavaGeneratorRecipeBuilder.build().fluidInput((Fluid)Fluids.LAVA, 0.1f).timeInSeconds(6).export(exporter, "lava");
        LavaGeneratorRecipeBuilder.build().fluidInput((Fluid)FluidContent.STILL_SHEOL_FIRE.get(), 0.1f).timeInSeconds(40).export(exporter, "sheolfire");
        FuelGeneratorRecipeBuilder.build().fluidInput(TagUtils.cFluidTag("oil"), 0.1f).timeInSeconds(1).export(exporter, "crude");
        FuelGeneratorRecipeBuilder.build().fluidInput((Fluid)FluidContent.STILL_HEAVY_OIL.get(), 0.1f).timeInSeconds(2).export(exporter, "heavyoil");
        FuelGeneratorRecipeBuilder.build().fluidInput(TagContent.DIESEL, 0.1f).timeInSeconds(4).export(exporter, "diesel");
        FuelGeneratorRecipeBuilder.build().fluidInput(TagContent.NAPHTHA, 0.1f).timeInSeconds(2).export(exporter, "naptha");
        FuelGeneratorRecipeBuilder.build().fluidInput(TagContent.TURBOFUEL, 0.1f).timeInSeconds(16).export(exporter, "fuel");
        SteamGeneratorRecipeBuilder.build().specificFluidInput((Fluid)FluidContent.STILL_STEAM.get(), 32L).time(1).export(exporter, "steameng");
    }

    private void addFluidProcessing(RecipeOutput exporter) {
        RefineryRecipeBuilder.build().fluidInput(TagUtils.cFluidTag("oil")).fluidOutput((Fluid)FluidContent.STILL_HEAVY_OIL.get(), 0.5f).fluidOutput((Fluid)FluidContent.STILL_NAPHTHA.get(), 0.25f).fluidOutput((Fluid)FluidContent.STILL_SULFURIC_ACID.get(), 0.25f).export(exporter, "oilbase");
        RefineryRecipeBuilder.build().input((ItemLike)ItemContent.CLAY_CATALYST_BEADS).fluidInput(TagUtils.cFluidTag("oil")).fluidOutput((Fluid)FluidContent.STILL_DIESEL.get(), 0.5f).fluidOutput((Fluid)FluidContent.STILL_NAPHTHA.get(), 0.5f).fluidOutput((Fluid)FluidContent.STILL_SULFURIC_ACID.get(), 0.5f).timeMultiplier(1.6f).export(exporter, "oilalt");
        RefineryRecipeBuilder.build().input((TagKey<Item>)ItemTags.SAND).fluidInput((Fluid)FluidContent.STILL_HEAVY_OIL.get()).fluidOutput((Fluid)FluidContent.STILL_DIESEL.get(), 1.0f).fluidOutput((Fluid)FluidContent.STILL_NAPHTHA.get(), 0.25f).fluidOutput((Fluid)FluidContent.STILL_SULFURIC_ACID.get(), 0.25f).export(exporter, "heavyoil");
        RefineryRecipeBuilder.build().fluidInput((Fluid)Fluids.LAVA).fluidOutput(FluidStack.create((Fluid)((Fluid)FluidContent.STILL_STEAM.get()), (long)4000L)).fluidOutput((Fluid)FluidContent.STILL_SULFURIC_ACID.get(), 0.1f).fluidOutput((Fluid)FluidContent.STILL_SHEOL_FIRE.get(), 0.2f).export(exporter, "lava");
        RefineryRecipeBuilder.build().input((ItemLike)ItemContent.ENDERIC_COMPOUND).fluidInput((Fluid)Fluids.LAVA).fluidOutput((Fluid)FluidContent.STILL_SULFURIC_ACID.get(), 1.0f).fluidOutput((Fluid)FluidContent.STILL_SHEOL_FIRE.get(), 0.25f).fluidOutput((Fluid)FluidContent.STILL_STRANGE_MATTER.get(), 0.1f).timeMultiplier(1.6f).export(exporter, "lavaalt");
        RefineryRecipeBuilder.build().input((ItemLike)ItemContent.CLAY_CATALYST_BEADS).fluidInput(TagContent.BIOFUEL).fluidOutput((Fluid)FluidContent.STILL_DIESEL.get(), 0.5f).fluidOutput((Fluid)FluidContent.STILL_NAPHTHA.get(), 0.2f).export(exporter, "biodiesel");
        CentrifugeFluidRecipeBuilder.build().input((ItemLike)ItemContent.FLUXITE).fluidInput(TagContent.DIESEL).fluidOutput((Fluid)FluidContent.STILL_FUEL.get()).export(exporter, "fuel");
        CentrifugeFluidRecipeBuilder.build().input(TagContent.BIOMASS).fluidInput((Fluid)Fluids.WATER, 0.25f).fluidOutput((Fluid)FluidContent.STILL_BIOFUEL.get(), 0.1f).timeMultiplier(0.2f).export(exporter, "biofuel");
        CentrifugeFluidRecipeBuilder.build().input(TagContent.QUARTZ_DUSTS).fluidInput(TagContent.NAPHTHA).fluidOutput((Fluid)FluidContent.STILL_SILICON_WASH.get(), 1.0f).export(exporter, "siliconwash");
        CentrifugeFluidRecipeBuilder.build().input((ItemLike)Items.GRAVEL).fluidInput(TagContent.NAPHTHA).fluidOutput((Fluid)FluidContent.STILL_SILICON_WASH.get(), 0.05f).timeMultiplier(1.6f).export(exporter, "siliconwashbad");
        this.offerManualFluidApplication(exporter, ItemContent.POLYMER_RESIN, RecipeHelpers.of((ItemLike)FluidContent.STILL_NAPHTHA_BUCKET.get()), RecipeHelpers.of((TagKey<Item>)ItemTags.SAND), "manualresin");
        CentrifugeFluidRecipeBuilder.build().input((TagKey<Item>)ItemTags.SAND).fluidInput(TagContent.NAPHTHA, 0.1f).result(ItemContent.POLYMER_RESIN, 2).export(exporter, "naptharesin");
        CentrifugeFluidRecipeBuilder.build().input(TagContent.STEEL_INGOTS).fluidInput(TagContent.SULFURIC_ACID).result(ItemContent.BASIC_BATTERY, 2).export(exporter, "batteryacid");
        CentrifugeFluidRecipeBuilder.build().input((ItemLike)ItemContent.DUBIOS_CONTAINER).fluidInput(TagContent.SULFURIC_ACID).result(ItemContent.ADVANCED_BATTERY, 8).timeMultiplier(2.0f).export(exporter, "advbatteryacid");
        RefineryRecipeBuilder.build().input((TagKey<Item>)ItemTags.SAND).fluidInput((Fluid)FluidContent.STILL_SILICON_WASH.get()).result(ItemContent.SILICON, 4).timeMultiplier(2.0f).export(exporter, "siliconwashing");
        CentrifugeFluidRecipeBuilder.build().input((ItemLike)ItemContent.CARBON_FIBRE_STRANDS).fluidInput((Fluid)FluidContent.STILL_SILICON_WASH.get()).result(ItemContent.SILICON_WAFER, 4).timeMultiplier(2.0f).export(exporter, "siliconwafers");
        RefineryRecipeBuilder.build().input((ItemLike)ItemContent.CLAY_CATALYST_BEADS).fluidInput((Fluid)FluidContent.STILL_MINERAL_SLURRY.get(), 0.25f).result(Items.QUARTZ).timeMultiplier(2.0f).export(exporter, "quartz");
        RefineryRecipeBuilder.build().input((ItemLike)ItemContent.CARBON_FIBRE_STRANDS).fluidInput(TagContent.NAPHTHA, 0.5f).result(ItemContent.REINFORCED_CARBON_SHEET).timeMultiplier(3.0f).export(exporter, "carbonsheet");
        CentrifugeFluidRecipeBuilder.build().input((ItemLike)ItemContent.DUBIOS_CONTAINER).fluidInput((Fluid)FluidContent.STILL_STRANGE_MATTER.get()).result(ItemContent.UNHOLY_INTELLIGENCE, 1).timeMultiplier(8.0f).export(exporter, "unholyai");
    }

    private void addBiomass(RecipeOutput exporter) {
        PulverizerRecipeBuilder.build().input(TagContent.BIOMATTER).result(ItemContent.BIOMASS).addToGrinder().export(exporter, "biobasic");
        PulverizerRecipeBuilder.build().input((ItemLike)ItemContent.PACKED_WHEAT).result(ItemContent.BIOMASS, 16).addToGrinder().export(exporter, "packagedwheatbio");
        PulverizerRecipeBuilder.build().input(TagUtils.cItemTag("storage_blocks/wheat")).result(ItemContent.BIOMASS, 16).addToGrinder().export(exporter, "hay_block");
        AssemblerRecipeBuilder.build().input(TagContent.BIOMASS).input(TagContent.BIOMASS).input(TagContent.BIOMASS).input((TagKey<Item>)ItemTags.PLANKS).result(ItemContent.SOLID_BIOFUEL).timeMultiplier(0.8f).export(exporter, "solidbiofuel");
    }

    private void addEquipment(RecipeOutput exporter) {
        this.offerDrillRecipe(exporter, ToolsContent.HAND_DRILL, RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)ItemContent.ENDERIC_COMPOUND), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), "handdrill");
        this.offerChainsawRecipe(exporter, ToolsContent.CHAINSAW, RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)ItemContent.ENDERIC_COMPOUND), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), "chainsaw");
        this.offerAxeRecipe(exporter, ToolsContent.PROMETHIUM_AXE, RecipeHelpers.of((ItemLike)ItemContent.PROMETHEUM_INGOT), RecipeHelpers.of((ItemLike)BlockContent.DESTROYER_BLOCK.asItem()), "promaxe");
        this.offerPickaxeRecipe(exporter, ToolsContent.PROMETHIUM_PICKAXE, RecipeHelpers.of((ItemLike)ItemContent.PROMETHEUM_INGOT), RecipeHelpers.of((ItemLike)BlockContent.DESTROYER_BLOCK.asItem()), "prompick");
        this.offerChainsawRecipe(exporter, ToolsContent.PORTABLE_LASER, RecipeHelpers.of((ItemLike)ItemContent.ADVANCED_BATTERY), RecipeHelpers.of((ItemLike)BlockContent.ACCELERATOR_MOTOR), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), RecipeHelpers.of((ItemLike)BlockContent.LASER_ARM_BLOCK), "portablelaser");
        this.offerDrillRecipe(exporter, ToolsContent.ELECTRIC_MACE, RecipeHelpers.of((ItemLike)ItemContent.ADVANCED_BATTERY), RecipeHelpers.of((ItemLike)ItemContent.CARBON_FIBRE_STRANDS), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), RecipeHelpers.of((ItemLike)Items.HEAVY_CORE), "_emace");
        this.offerDrillRecipe(exporter, ItemContent.TARGET_DESIGNATOR, RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), RecipeHelpers.of(TagContent.PLASTIC_PLATES), "designator");
        this.offerDrillRecipe(exporter, ItemContent.WEED_KILLER, RecipeHelpers.of(TagUtils.cItemTag("foods/food_poisoning")), RecipeHelpers.of(TagUtils.cItemTag("foods/food_poisoning")), RecipeHelpers.of((ItemLike)ItemContent.RAW_BIOPOLYMER), RecipeHelpers.of((ItemLike)Items.GLASS_BOTTLE), "weedex");
        this.offerWrenchRecipe(exporter, ItemContent.WRENCH, RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of(TagContent.NICKEL_INGOTS), "wrench");
        this.offerHelmetRecipe(exporter, ToolsContent.EXO_HELMET, RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.ENDERIC_LENS), "exohelm");
        this.offerChestplateRecipe(exporter, ToolsContent.EXO_CHESTPLATE, RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.ADVANCED_BATTERY), "exochest");
        this.offerLegsRecipe(exporter, ToolsContent.EXO_LEGGINGS, RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), "exolegs");
        this.offerFeetRecipe(exporter, ToolsContent.EXO_BOOTS, RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of(TagContent.SILICON), "exoboots");
        this.offerParticleMotorRecipe(exporter, ToolsContent.JETPACK, RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of(TagUtils.cItemTag("leathers")), RecipeHelpers.of((ItemLike)ItemContent.ADVANCED_BATTERY), RecipeHelpers.of((ItemLike)Items.GUNPOWDER), "basicjetpack");
        this.offerParticleMotorRecipe(exporter, ToolsContent.JETPACK, RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of(TagUtils.cItemTag("leathers")), RecipeHelpers.of((ItemLike)Items.REDSTONE_BLOCK), RecipeHelpers.of((ItemLike)Items.BLAZE_POWDER), "basicjetpackalt");
        this.offerGeneratorRecipe(exporter, ToolsContent.EXO_JETPACK, RecipeHelpers.of((ItemLike)ToolsContent.JETPACK), RecipeHelpers.of((ItemLike)BlockContent.SMALL_TANK_BLOCK), RecipeHelpers.of((ItemLike)ToolsContent.EXO_CHESTPLATE), RecipeHelpers.of((ItemLike)ItemContent.ION_THRUSTER), "exojetpack");
        this.offerGeneratorRecipe(exporter, ToolsContent.JETPACK_ELYTRA, RecipeHelpers.of((ItemLike)Items.ELYTRA), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), RecipeHelpers.of((ItemLike)ToolsContent.JETPACK), RecipeHelpers.of((ItemLike)Items.GUNPOWDER), "boostedelytra");
        this.offerGeneratorRecipe(exporter, ToolsContent.JETPACK_EXO_ELYTRA, RecipeHelpers.of((ItemLike)ToolsContent.EXO_JETPACK), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), RecipeHelpers.of((ItemLike)Items.ELYTRA), RecipeHelpers.of((ItemLike)Items.GUNPOWDER), "exoboostedelytra");
        this.offerGeneratorRecipe(exporter, ToolsContent.JETPACK_EXO_ELYTRA, RecipeHelpers.of((ItemLike)ToolsContent.EXO_CHESTPLATE), RecipeHelpers.of((ItemLike)BlockContent.SMALL_TANK_BLOCK), RecipeHelpers.of((ItemLike)ToolsContent.JETPACK_ELYTRA), RecipeHelpers.of((ItemLike)ItemContent.ION_THRUSTER), "exoboostedelytraalt");
    }

    private void addDecorative(RecipeOutput exporter) {
        this.offerInsulatedCableRecipe(exporter, new ItemStack((ItemLike)BlockContent.CEILING_LIGHT.asItem(), 6), RecipeHelpers.of((ItemLike)Items.GLOWSTONE_DUST), RecipeHelpers.of(TagContent.STEEL_INGOTS), "ceilightlight");
        this.offerTwoComponentRecipe(exporter, BlockContent.CEILING_LIGHT_HANGING.asItem(), RecipeHelpers.of(TagUtils.cItemTag("chains")), RecipeHelpers.of((ItemLike)BlockContent.CEILING_LIGHT.asItem()), "hanginglight");
        this.offerLeverRecipe(exporter, BlockContent.TECH_BUTTON.asItem(), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), RecipeHelpers.of(TagContent.STEEL_INGOTS), "techbutton");
        this.offerLeverRecipe(exporter, BlockContent.TECH_LEVER.asItem(), RecipeHelpers.of(TagContent.CARBON_FIBRE), RecipeHelpers.of(TagContent.STEEL_INGOTS), "techlever");
        this.offerDoorRecipe(exporter, BlockContent.TECH_DOOR.asItem(), RecipeHelpers.of(TagContent.STEEL_INGOTS), "techdoor");
        this.offerRotatedCableRecipe(exporter, new ItemStack((ItemLike)BlockContent.METAL_BEAM_BLOCK.asItem(), 6), RecipeHelpers.of(TagContent.CARBON_FIBRE), RecipeHelpers.of(TagContent.STEEL_INGOTS), "metalbeams");
        this.offerInsulatedCableRecipe(exporter, new ItemStack((ItemLike)BlockContent.METAL_GIRDER_BLOCK.asItem(), 6), RecipeHelpers.of(TagContent.CARBON_FIBRE), RecipeHelpers.of(TagContent.STEEL_INGOTS), "metalgirder");
        this.offerMachinePlatingRecipe(exporter, BlockContent.INDUSTRIAL_GLASS_BLOCK.asItem(), RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of(TagUtils.cItemTag("glass_blocks")), RecipeHelpers.of(TagContent.MACHINE_PLATING), 4, "industrialglass");
        this.offerSlabRecipe(exporter, BlockContent.MACHINE_PLATING_SLAB.asItem(), RecipeHelpers.of((ItemLike)BlockContent.MACHINE_PLATING_BLOCK.asItem()), "machine");
        this.offerStairsRecipe(exporter, BlockContent.MACHINE_PLATING_STAIRS.asItem(), RecipeHelpers.of((ItemLike)BlockContent.MACHINE_PLATING_BLOCK.asItem()), "machine");
        this.offerPressurePlateRecipe(exporter, BlockContent.MACHINE_PLATING_PRESSURE_PLATE.asItem(), RecipeHelpers.of((ItemLike)BlockContent.MACHINE_PLATING_BLOCK.asItem()), "machine");
        this.offerSlabRecipe(exporter, BlockContent.IRON_PLATING_SLAB.asItem(), RecipeHelpers.of((ItemLike)BlockContent.IRON_PLATING_BLOCK.asItem()), "iron");
        this.offerStairsRecipe(exporter, BlockContent.IRON_PLATING_STAIRS.asItem(), RecipeHelpers.of((ItemLike)BlockContent.IRON_PLATING_BLOCK.asItem()), "iron");
        this.offerPressurePlateRecipe(exporter, BlockContent.IRON_PLATING_PRESSURE_PLATE.asItem(), RecipeHelpers.of((ItemLike)BlockContent.IRON_PLATING_BLOCK.asItem()), "iron");
        this.offerSlabRecipe(exporter, BlockContent.NICKEL_PLATING_SLAB.asItem(), RecipeHelpers.of((ItemLike)BlockContent.NICKEL_PLATING_BLOCK.asItem()), "nickel");
        this.offerStairsRecipe(exporter, BlockContent.NICKEL_PLATING_STAIRS.asItem(), RecipeHelpers.of((ItemLike)BlockContent.NICKEL_PLATING_BLOCK.asItem()), "nickel");
        this.offerPressurePlateRecipe(exporter, BlockContent.NICKEL_PLATING_PRESSURE_PLATE.asItem(), RecipeHelpers.of((ItemLike)BlockContent.NICKEL_PLATING_BLOCK.asItem()), "nickel");
    }

    private void addMachines(RecipeOutput exporter) {
        this.offerGeneratorRecipe(exporter, BlockContent.BASIC_GENERATOR_BLOCK.asItem(), RecipeHelpers.of(TagUtils.cItemTag("player_workstations/furnaces")), RecipeHelpers.of((ItemLike)ItemContent.MAGNETIC_COIL), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), RecipeHelpers.of(TagContent.NICKEL_INGOTS), "basicgen");
        this.offerGeneratorRecipe(exporter, BlockContent.PULVERIZER_BLOCK.asItem(), RecipeHelpers.of(TagUtils.cItemTag("storage_blocks/copper")), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagContent.NICKEL_INGOTS), RecipeHelpers.of(TagContent.STEEL_INGOTS), "pulverizer");
        this.offerGeneratorRecipe(exporter, BlockContent.PULVERIZER_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagContent.NICKEL_INGOTS), RecipeHelpers.of(TagContent.STEEL_INGOTS), "pulverizeralt");
        this.offerFurnaceRecipe(exporter, BlockContent.POWERED_FURNACE_BLOCK.asItem(), RecipeHelpers.of(TagUtils.cItemTag("player_workstations/furnaces")), RecipeHelpers.of((ItemLike)ItemContent.MAGNETIC_COIL), RecipeHelpers.of(TagContent.SILICON), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), "electricfurnace");
        this.offerFurnaceRecipe(exporter, BlockContent.POWERED_FURNACE_BLOCK.asItem(), RecipeHelpers.of(TagUtils.cItemTag("player_workstations/furnaces")), RecipeHelpers.of((ItemLike)ItemContent.MAGNETIC_COIL), RecipeHelpers.of(TagContent.PLATINUM_INGOTS), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), "electricfurnacealt");
        this.offerFurnaceRecipe(exporter, BlockContent.ASSEMBLER_BLOCK.asItem(), RecipeHelpers.of((ItemLike)Blocks.BLAST_FURNACE.asItem()), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)Items.CRAFTER), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), "assembler");
        this.offerFurnaceRecipe(exporter, BlockContent.ASSEMBLER_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)Items.CRAFTER), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), "assembleralt");
        this.offerGeneratorRecipe(exporter, BlockContent.FOUNDRY_BLOCK.asItem(), RecipeHelpers.of((ItemLike)Blocks.CAULDRON.asItem()), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), "foundry");
        this.offerParticleMotorRecipe(exporter, BlockContent.REFINERY_BLOCK.asItem(), RecipeHelpers.of((ItemLike)BlockContent.REFINERY_MODULE_BLOCK.asItem()), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)Items.CAULDRON), RecipeHelpers.of(TagUtils.cItemTag("ingots/steel")), "refinery");
        this.offerGeneratorRecipe(exporter, BlockContent.REFINERY_MODULE_BLOCK.asItem(), RecipeHelpers.of((ItemLike)BlockContent.SMALL_TANK_BLOCK.asItem()), RecipeHelpers.of((ItemLike)Items.SLIME_BALL), RecipeHelpers.of((ItemLike)BlockContent.METAL_BEAM_BLOCK), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), "refinerymodule");
        this.offerGeneratorRecipe(exporter, BlockContent.REFINERY_MODULE_BLOCK.asItem(), RecipeHelpers.of((ItemLike)BlockContent.SMALL_TANK_BLOCK.asItem()), RecipeHelpers.of((ItemLike)ItemContent.SILICON), RecipeHelpers.of((ItemLike)BlockContent.METAL_BEAM_BLOCK), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), "refinerymodulealt");
        this.offerGeneratorRecipe(exporter, BlockContent.COOLER_BLOCK.asItem(), RecipeHelpers.of((ItemLike)Blocks.CAULDRON.asItem()), RecipeHelpers.of((ItemLike)Blocks.ICE.asItem()), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagUtils.cItemTag("ingots/iron")), "cooler");
        this.offerFurnaceRecipe(exporter, BlockContent.CENTRIFUGE_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of((ItemLike)Items.GLASS_BOTTLE), "centrifuge");
        this.offerFurnaceRecipe(exporter, BlockContent.CENTRIFUGE_BLOCK.asItem(), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagUtils.cItemTag("storage_blocks/iron")), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)Items.GLASS_BOTTLE), "centrifugealt");
        this.offerAtomicForgeRecipe(exporter, BlockContent.LASER_ARM_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.ENDERIC_LENS), RecipeHelpers.of(TagContent.CARBON_FIBRE), "laserarm");
        this.offerGeneratorRecipe(exporter, BlockContent.FRAGMENT_FORGE_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)ItemContent.FLUX_GATE), RecipeHelpers.of(TagContent.PLASTIC_PLATES), "crusher");
        this.offerAtomicForgeRecipe(exporter, BlockContent.ATOMIC_FORGE_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of(TagContent.PLASTIC_PLATES), RecipeHelpers.of((ItemLike)ItemContent.ENDERIC_COMPOUND), RecipeHelpers.of((ItemLike)ItemContent.DURATIUM_INGOT), RecipeHelpers.of((ItemLike)ItemContent.FLUX_GATE), "atomicforge");
        this.offerGeneratorRecipe(exporter, BlockContent.BIO_GENERATOR_BLOCK.asItem(), RecipeHelpers.of((ItemLike)BlockContent.BASIC_GENERATOR_BLOCK.asItem()), RecipeHelpers.of((ItemLike)ItemContent.MAGNETIC_COIL), RecipeHelpers.of((ItemLike)ItemContent.FLUX_GATE), RecipeHelpers.of((ItemLike)ItemContent.BIOSTEEL_INGOT), "biogen");
        this.offerGeneratorRecipe(exporter, BlockContent.LAVA_GENERATOR_BLOCK.asItem(), RecipeHelpers.of((ItemLike)BlockContent.BASIC_GENERATOR_BLOCK.asItem()), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MAGNETIC_COIL), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), "lavagen");
        this.offerGeneratorRecipe(exporter, BlockContent.STEAM_ENGINE_BLOCK.asItem(), RecipeHelpers.of((ItemLike)BlockContent.BASIC_GENERATOR_BLOCK.asItem()), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), RecipeHelpers.of((ItemLike)ItemContent.MAGNETIC_COIL), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), "steamgen");
        this.offerGeneratorRecipe(exporter, BlockContent.FUEL_GENERATOR_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)BlockContent.BASIC_GENERATOR_BLOCK), RecipeHelpers.of((ItemLike)ItemContent.ENDERIC_LENS), RecipeHelpers.of(TagContent.STEEL_INGOTS), "fuelgen");
        this.offerGeneratorRecipe(exporter, BlockContent.BIG_SOLAR_PANEL_BLOCK.asItem(), RecipeHelpers.of((ItemLike)BlockContent.BASIC_GENERATOR_BLOCK.asItem()), RecipeHelpers.of((ItemLike)ItemContent.FLUX_GATE), RecipeHelpers.of((ItemLike)ItemContent.ADVANCED_BATTERY), RecipeHelpers.of((ItemLike)ItemContent.FLUXITE), "solar");
        this.offerAtomicForgeRecipe(exporter, BlockContent.CHARGER_BLOCK.asItem(), RecipeHelpers.of(TagUtils.cItemTag("chests/wooden")), RecipeHelpers.of((ItemLike)BlockContent.ENERGY_PIPE), RecipeHelpers.of(TagUtils.cItemTag("storage_blocks/redstone")), RecipeHelpers.of((ItemLike)Items.DISPENSER), RecipeHelpers.of(TagContent.STEEL_INGOTS), "charger");
        this.offerAtomicForgeRecipe(exporter, BlockContent.CHARGER_BLOCK.asItem(), RecipeHelpers.of(TagUtils.cItemTag("chests/wooden")), RecipeHelpers.of((ItemLike)BlockContent.ENERGY_PIPE), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), RecipeHelpers.of((ItemLike)Items.DISPENSER), RecipeHelpers.of(TagContent.STEEL_INGOTS), "chargeralt");
        this.offerAtomicForgeRecipe(exporter, BlockContent.SMALL_STORAGE_BLOCK.asItem(), RecipeHelpers.of((ItemLike)ItemContent.BASIC_BATTERY), RecipeHelpers.of(TagContent.SILICON), RecipeHelpers.of((ItemLike)ItemContent.MAGNETIC_COIL), RecipeHelpers.of(TagContent.NICKEL_INGOTS), RecipeHelpers.of(TagContent.NICKEL_INGOTS), "smallstorage");
        this.offerAtomicForgeRecipe(exporter, BlockContent.LARGE_STORAGE_BLOCK.asItem(), RecipeHelpers.of((ItemLike)ItemContent.ADVANCED_BATTERY), RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.DUBIOS_CONTAINER), RecipeHelpers.of((ItemLike)ItemContent.FLUX_GATE), RecipeHelpers.of((ItemLike)ItemContent.MAGNETIC_COIL), "bigstorage");
        this.offerAtomicForgeRecipe(exporter, ItemContent.UNSTABLE_CONTAINER, RecipeHelpers.of((ItemLike)ItemContent.FLUXITE), RecipeHelpers.of((ItemLike)ItemContent.DURATIUM_INGOT), RecipeHelpers.of((ItemLike)BlockContent.LARGE_STORAGE_BLOCK), RecipeHelpers.of((ItemLike)ItemContent.FLUX_GATE), RecipeHelpers.of((ItemLike)ItemContent.SUPER_AI_CHIP), "unstablecontainer");
        this.offerTankRecipe(exporter, BlockContent.SMALL_TANK_BLOCK.asItem(), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), RecipeHelpers.of(TagUtils.cItemTag("glass_blocks")), RecipeHelpers.of((ItemLike)BlockContent.FLUID_PIPE.asItem()), "stank");
        this.offerGeneratorRecipe(exporter, BlockContent.PUMP_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of(TagContent.SILICON), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), "pump");
        this.offerFurnaceRecipe(exporter, BlockContent.PLACER_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), RecipeHelpers.of((ItemLike)BlockContent.MACHINE_FRAME_BLOCK.asItem()), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), "placer");
        this.offerAtomicForgeRecipe(exporter, BlockContent.DESTROYER_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)BlockContent.PULVERIZER_BLOCK), RecipeHelpers.of((ItemLike)BlockContent.LASER_ARM_BLOCK), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), "destroyer");
        this.offerFurnaceRecipe(exporter, BlockContent.FERTILIZER_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagContent.SILICON), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), "fertilizer");
        this.offerGeneratorRecipe(exporter, BlockContent.TREEFELLER_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)Items.IRON_AXE), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), "treefeller");
        this.offerTankRecipe(exporter, BlockContent.PIPE_BOOSTER_BLOCK.asItem(), RecipeHelpers.of((ItemLike)BlockContent.ITEM_PIPE), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)BlockContent.FLUID_PIPE), "booster");
        this.offerMachineFrameRecipe(exporter, BlockContent.MACHINE_FRAME_BLOCK.asItem(), RecipeHelpers.of((ItemLike)Items.IRON_BARS), RecipeHelpers.of(TagContent.NICKEL_INGOTS), 16, "frame");
        this.offerCableRecipe(exporter, new ItemStack((ItemLike)BlockContent.ENERGY_PIPE.asItem(), 6), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), "energy");
        this.offerInsulatedCableRecipe(exporter, new ItemStack((ItemLike)BlockContent.ITEM_PIPE.asItem(), 6), RecipeHelpers.of(TagContent.NICKEL_INGOTS), RecipeHelpers.of((TagKey<Item>)ItemTags.PLANKS), "item");
        this.offerGeneratorRecipe(exporter, BlockContent.ITEM_FILTER_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((TagKey<Item>)ItemTags.PLANKS), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), RecipeHelpers.of((TagKey<Item>)ItemTags.PLANKS), "itemfilter");
        this.offerInsulatedCableRecipe(exporter, new ItemStack((ItemLike)BlockContent.FLUID_PIPE.asItem(), 6), RecipeHelpers.of(TagContent.SILICON), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), "fluidpipe");
        this.offerFramedCableRecipe(exporter, new ItemStack((ItemLike)BlockContent.FRAMED_ENERGY_PIPE, 8), RecipeHelpers.of((ItemLike)BlockContent.ENERGY_PIPE), "energy");
        this.offerCableFromFrameRecipe(exporter, new ItemStack((ItemLike)BlockContent.ENERGY_PIPE, 1), RecipeHelpers.of((ItemLike)BlockContent.FRAMED_ENERGY_PIPE), "energy");
        this.offerFramedCableRecipe(exporter, new ItemStack((ItemLike)BlockContent.FRAMED_SUPERCONDUCTOR, 8), RecipeHelpers.of((ItemLike)BlockContent.SUPERCONDUCTOR.asItem()), "superconductor");
        this.offerCableFromFrameRecipe(exporter, new ItemStack((ItemLike)BlockContent.SUPERCONDUCTOR.asItem(), 1), RecipeHelpers.of((ItemLike)BlockContent.FRAMED_SUPERCONDUCTOR), "superconductor");
        this.offerFramedCableRecipe(exporter, new ItemStack((ItemLike)BlockContent.FRAMED_FLUID_PIPE, 8), RecipeHelpers.of((ItemLike)BlockContent.FLUID_PIPE), "fluid");
        this.offerCableFromFrameRecipe(exporter, new ItemStack((ItemLike)BlockContent.FLUID_PIPE, 1), RecipeHelpers.of((ItemLike)BlockContent.FRAMED_FLUID_PIPE), "fluid");
        this.offerFramedCableRecipe(exporter, new ItemStack((ItemLike)BlockContent.FRAMED_ITEM_PIPE, 8), RecipeHelpers.of((ItemLike)BlockContent.ITEM_PIPE), "item");
        this.offerCableFromFrameRecipe(exporter, new ItemStack((ItemLike)BlockContent.ITEM_PIPE, 1), RecipeHelpers.of((ItemLike)BlockContent.FRAMED_ITEM_PIPE), "item");
        this.offerTankRecipe(exporter, BlockContent.TRANSPARENT_ITEM_PIPE.asItem(), 6, RecipeHelpers.of((TagKey<Item>)ItemTags.PLANKS), RecipeHelpers.of(TagContent.NICKEL_INGOTS), RecipeHelpers.of(TagUtils.cItemTag("glass_blocks")), "transparentitem");
        this.offerMachineCoreRecipe(exporter, BlockContent.TRANSPARENT_ITEM_PIPE.asItem(), 8, RecipeHelpers.of((ItemLike)BlockContent.ITEM_PIPE), RecipeHelpers.of(TagUtils.cItemTag("glass_blocks")), "totransparent");
        this.offerMachineCoreRecipe(exporter, BlockContent.ITEM_PIPE.asItem(), 8, RecipeHelpers.of((ItemLike)BlockContent.TRANSPARENT_ITEM_PIPE), RecipeHelpers.of((TagKey<Item>)ItemTags.PLANKS), "fromtransparent");
        this.offerCableDuctRecipe(exporter, new ItemStack((ItemLike)BlockContent.ENERGY_PIPE_DUCT_BLOCK, 4), RecipeHelpers.of((ItemLike)BlockContent.ENERGY_PIPE), "energy");
        this.offerCableFromDuctRecipe(exporter, new ItemStack((ItemLike)BlockContent.ENERGY_PIPE, 1), RecipeHelpers.of((ItemLike)BlockContent.ENERGY_PIPE_DUCT_BLOCK), "energy");
        this.offerCableDuctRecipe(exporter, new ItemStack((ItemLike)BlockContent.SUPERCONDUCTOR_DUCT_BLOCK, 4), RecipeHelpers.of((ItemLike)BlockContent.SUPERCONDUCTOR.asItem()), "superconductor");
        this.offerCableFromDuctRecipe(exporter, new ItemStack((ItemLike)BlockContent.SUPERCONDUCTOR.asItem(), 1), RecipeHelpers.of((ItemLike)BlockContent.SUPERCONDUCTOR_DUCT_BLOCK), "superconductor");
        this.offerCableDuctRecipe(exporter, new ItemStack((ItemLike)BlockContent.FLUID_PIPE_DUCT_BLOCK, 4), RecipeHelpers.of((ItemLike)BlockContent.FLUID_PIPE), "fluid");
        this.offerCableFromDuctRecipe(exporter, new ItemStack((ItemLike)BlockContent.FLUID_PIPE, 1), RecipeHelpers.of((ItemLike)BlockContent.FLUID_PIPE_DUCT_BLOCK), "fluid");
        this.offerCableDuctRecipe(exporter, new ItemStack((ItemLike)BlockContent.ITEM_PIPE_DUCT_BLOCK, 4), RecipeHelpers.of((ItemLike)BlockContent.ITEM_PIPE), "item");
        this.offerCableFromDuctRecipe(exporter, new ItemStack((ItemLike)BlockContent.ITEM_PIPE, 1), RecipeHelpers.of((ItemLike)BlockContent.ITEM_PIPE_DUCT_BLOCK), "item");
        this.offerAtomicForgeRecipe(exporter, BlockContent.DEEP_DRILL_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)ItemContent.HEISENBERG_COMPENSATOR), RecipeHelpers.of((ItemLike)ItemContent.OVERCHARGED_CRYSTAL), RecipeHelpers.of((ItemLike)ItemContent.DURATIUM_INGOT), "deepdrill");
        this.offerAtomicForgeRecipe(exporter, BlockContent.DRONE_PORT_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)BlockContent.SUPERCONDUCTOR.asItem()), RecipeHelpers.of((ItemLike)ItemContent.UNHOLY_INTELLIGENCE), RecipeHelpers.of((ItemLike)ItemContent.ADVANCED_COMPUTING_ENGINE), "droneport");
        this.offerAtomicForgeRecipe(exporter, BlockContent.DRONE_PORT_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)BlockContent.SUPERCONDUCTOR.asItem()), RecipeHelpers.of((ItemLike)ItemContent.SUPER_AI_CHIP), RecipeHelpers.of((ItemLike)ItemContent.ADVANCED_COMPUTING_ENGINE), "droneportalt");
        this.offerFurnaceRecipe(exporter, BlockContent.ENCHANTMENT_CATALYST_BLOCK.asItem(), RecipeHelpers.of((ItemLike)Items.ENCHANTING_TABLE), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), RecipeHelpers.of(TagUtils.cItemTag("obsidians/normal")), RecipeHelpers.of((ItemLike)ItemContent.UNHOLY_INTELLIGENCE), RecipeHelpers.of((ItemLike)ItemContent.FLUXITE), "catalyst");
        this.offerFurnaceRecipe(exporter, BlockContent.ENCHANTMENT_CATALYST_BLOCK.asItem(), RecipeHelpers.of((ItemLike)Items.ENCHANTING_TABLE), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), RecipeHelpers.of(TagUtils.cItemTag("obsidians/normal")), RecipeHelpers.of((ItemLike)ItemContent.SUPER_AI_CHIP), RecipeHelpers.of((ItemLike)ItemContent.FLUXITE), "catalyst_alt");
        this.offerGeneratorRecipe(exporter, BlockContent.ENCHANTER_BLOCK.asItem(), RecipeHelpers.of((ItemLike)ItemContent.DURATIUM_INGOT), RecipeHelpers.of((ItemLike)ItemContent.ENERGITE_INGOT), RecipeHelpers.of((ItemLike)BlockContent.ENCHANTMENT_CATALYST_BLOCK.asItem()), RecipeHelpers.of((ItemLike)Items.BOOK), "enchanter");
        this.offerTankRecipe(exporter, BlockContent.SPAWNER_CONTROLLER_BLOCK.asItem(), RecipeHelpers.of((ItemLike)BlockContent.SPAWNER_CAGE_BLOCK), RecipeHelpers.of((ItemLike)Blocks.RESPAWN_ANCHOR), RecipeHelpers.of((ItemLike)BlockContent.ENCHANTMENT_CATALYST_BLOCK), "spawner");
        this.offerInsulatedCableRecipe(exporter, new ItemStack((ItemLike)BlockContent.SPAWNER_CAGE_BLOCK, 2), RecipeHelpers.of(TagContent.PLASTIC_PLATES), RecipeHelpers.of((ItemLike)Items.IRON_BARS), "cage");
        this.offerMachineFrameRecipe(exporter, BlockContent.WITHER_CROP_BLOCK.asItem(), RecipeHelpers.of((ItemLike)Items.WITHER_ROSE), RecipeHelpers.of((TagKey<Item>)ItemTags.FLOWERS), 1, "witherrose");
        this.offerParticleMotorRecipe(exporter, BlockContent.ACCELERATOR_MOTOR.asItem(), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of((ItemLike)BlockContent.SUPERCONDUCTOR.asItem()), RecipeHelpers.of((ItemLike)ItemContent.DURATIUM_INGOT), RecipeHelpers.of((ItemLike)ItemContent.ION_THRUSTER), "particlemotor");
        this.offerDrillRecipe(exporter, BlockContent.ACCELERATOR_RING.asItem(), RecipeHelpers.of((ItemLike)BlockContent.INDUSTRIAL_GLASS_BLOCK.asItem()), RecipeHelpers.of((ItemLike)BlockContent.SUPERCONDUCTOR.asItem()), RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of((ItemLike)Items.REDSTONE_TORCH), "acceleratorring");
        this.offerGeneratorRecipe(exporter, BlockContent.ACCELERATOR_CONTROLLER.asItem(), RecipeHelpers.of((ItemLike)BlockContent.ACCELERATOR_MOTOR.asItem()), RecipeHelpers.of((ItemLike)ItemContent.FLUX_GATE), RecipeHelpers.of((ItemLike)Items.DROPPER), RecipeHelpers.of((ItemLike)ItemContent.DURATIUM_INGOT), "particlecontroller");
        this.offerTwoComponentRecipe(exporter, BlockContent.ACCELERATOR_SENSOR.asItem(), RecipeHelpers.of((ItemLike)BlockContent.ACCELERATOR_RING.asItem()), RecipeHelpers.of((ItemLike)Items.OBSERVER), "particlesensor");
        this.offerTankRecipe(exporter, BlockContent.PARTICLE_COLLECTOR_BLOCK.asItem(), RecipeHelpers.of((ItemLike)BlockContent.SUPERCONDUCTOR.asItem()), RecipeHelpers.of((ItemLike)BlockContent.BIG_SOLAR_PANEL_BLOCK.asItem()), RecipeHelpers.of((ItemLike)ItemContent.HEISENBERG_COMPENSATOR), "particlecollector");
        this.offerGeneratorRecipe(exporter, BlockContent.MACHINE_SPEED_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MAGNETIC_COIL), RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of(TagContent.PLASTIC_PLATES), "addon/speed");
        this.offerAtomicForgeRecipe(exporter, BlockContent.MACHINE_PROCESSING_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.SUPER_AI_CHIP), RecipeHelpers.of((ItemLike)ItemContent.FLUX_GATE), RecipeHelpers.of(TagContent.PLATINUM_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), "addon/processing");
        this.offerAtomicForgeRecipe(exporter, BlockContent.MACHINE_PROCESSING_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.UNHOLY_INTELLIGENCE), RecipeHelpers.of((ItemLike)Items.COMPARATOR), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), "addon/processingalt");
        this.offerAtomicForgeRecipe(exporter, BlockContent.MACHINE_ULTIMATE_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.HEISENBERG_COMPENSATOR), RecipeHelpers.of((ItemLike)BlockContent.MACHINE_SPEED_ADDON), RecipeHelpers.of((ItemLike)BlockContent.MACHINE_EFFICIENCY_ADDON), RecipeHelpers.of((ItemLike)ItemContent.OVERCHARGED_CRYSTAL), "addon/ultimate");
        this.offerGeneratorRecipe(exporter, BlockContent.MACHINE_EFFICIENCY_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of(TagContent.CARBON_FIBRE), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of(TagContent.PLASTIC_PLATES), "addon/eff");
        this.offerGeneratorRecipe(exporter, BlockContent.MACHINE_CAPACITOR_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.ENERGITE_INGOT), RecipeHelpers.of((ItemLike)ItemContent.MAGNETIC_COIL), RecipeHelpers.of(TagContent.PLASTIC_PLATES), "addon/capacitor");
        this.offerGeneratorRecipe(exporter, BlockContent.MACHINE_ACCEPTOR_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.ENERGITE_INGOT), RecipeHelpers.of(TagContent.PLASTIC_PLATES), "addon/acceptor");
        this.offerGeneratorRecipe(exporter, BlockContent.MACHINE_YIELD_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.ENDERIC_LENS), RecipeHelpers.of(TagContent.PLASTIC_PLATES), "addon/yield");
        this.offerGeneratorRecipe(exporter, BlockContent.MACHINE_FLUID_ADDON.asItem(), RecipeHelpers.of(TagContent.SILICON), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of((ItemLike)BlockContent.FLUID_PIPE), RecipeHelpers.of(TagContent.CARBON_FIBRE), "addon/fluid");
        this.offerGeneratorRecipe(exporter, BlockContent.MACHINE_INVENTORY_PROXY_ADDON.asItem(), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagUtils.cItemTag("chests")), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), RecipeHelpers.of(TagContent.CARBON_FIBRE), "addon/invproxy");
        this.offerGeneratorRecipe(exporter, BlockContent.CROP_FILTER_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), RecipeHelpers.of(TagContent.CARBON_FIBRE), "addon/cropfilter");
        this.offerGeneratorRecipe(exporter, BlockContent.QUARRY_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)Items.DIAMOND_PICKAXE), RecipeHelpers.of(TagContent.PLASTIC_PLATES), "addon/quarry");
        this.offerGeneratorRecipe(exporter, BlockContent.MACHINE_HUNTER_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)Items.IRON_SWORD), RecipeHelpers.of(TagContent.PLASTIC_PLATES), "_hunter");
        this.offerGeneratorRecipe(exporter, BlockContent.STEAM_BOILER_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), RecipeHelpers.of((ItemLike)BlockContent.FLUID_PIPE), "addon/steamboiler");
        this.offerGeneratorRecipe(exporter, BlockContent.STEAM_BOILER_ADDON.asItem(), RecipeHelpers.of(TagContent.SILICON), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), RecipeHelpers.of((ItemLike)BlockContent.FLUID_PIPE), RecipeHelpers.of(TagContent.COAL_DUSTS), "addon/steamboileralt");
        this.offerGeneratorRecipe(exporter, BlockContent.MACHINE_REDSTONE_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)Items.REPEATER), RecipeHelpers.of((ItemLike)Items.COMPARATOR), RecipeHelpers.of(TagUtils.cItemTag("dusts/redstone")), "addon/redstone");
        this.offerGeneratorRecipe(exporter, BlockContent.MACHINE_SILK_TOUCH_ADDON.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((TagKey<Item>)ItemTags.WOOL), RecipeHelpers.of((ItemLike)Items.DIAMOND_PICKAXE), RecipeHelpers.of(TagContent.PLASTIC_PLATES), "addon/silktouch");
        this.offerTwoComponentRecipe(exporter, BlockContent.CAPACITOR_ADDON_EXTENDER.asItem(), RecipeHelpers.of((ItemLike)BlockContent.MACHINE_EXTENDER.asItem()), RecipeHelpers.of((ItemLike)BlockContent.MACHINE_CAPACITOR_ADDON), "addon/capextender");
        this.offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_1.asItem(), RecipeHelpers.of((TagKey<Item>)ItemTags.PLANKS), RecipeHelpers.of((ItemLike)Items.CRAFTING_TABLE), "core1");
        this.offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_2.asItem(), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), RecipeHelpers.of(TagUtils.cItemTag("gems/lapis")), "core2");
        this.offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_2.asItem(), RecipeHelpers.of(TagUtils.cItemTag("ingots/iron")), RecipeHelpers.of(TagUtils.cItemTag("gems/lapis")), "core2alt");
        this.offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_3.asItem(), RecipeHelpers.of(TagContent.CARBON_FIBRE), RecipeHelpers.of(TagUtils.cItemTag("dusts/redstone")), "core3");
        this.offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_3.asItem(), RecipeHelpers.of(TagContent.NICKEL_INGOTS), RecipeHelpers.of(TagUtils.cItemTag("dusts/redstone")), "core3alt");
        this.offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_4.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.ENDERIC_COMPOUND), "core4");
        this.offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_5.asItem(), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), RecipeHelpers.of((ItemLike)ItemContent.ADVANCED_COMPUTING_ENGINE), "core5");
        this.offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_6.asItem(), RecipeHelpers.of((ItemLike)ItemContent.DURATIUM_INGOT), RecipeHelpers.of((ItemLike)ItemContent.DUBIOS_CONTAINER), "core6");
        this.offerMachineCoreRecipe(exporter, BlockContent.MACHINE_CORE_7.asItem(), RecipeHelpers.of((ItemLike)ItemContent.PROMETHEUM_INGOT), RecipeHelpers.of((ItemLike)BlockContent.SUPERCONDUCTOR.asItem()), "core7");
        this.offerMachinePlatingRecipe(exporter, BlockContent.MACHINE_EXTENDER.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)BlockContent.MACHINE_CORE_2.asItem()), RecipeHelpers.of((ItemLike)ItemContent.DURATIUM_INGOT), 1, "extender");
        this.offerAtomicForgeRecipe(exporter, BlockContent.AUGMENT_APPLICATION_BLOCK.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of((ItemLike)Items.CHEST), RecipeHelpers.of(TagContent.CARBON_FIBRE), RecipeHelpers.of((ItemLike)ItemContent.DUBIOS_CONTAINER), "augment/applicator");
        this.offerGeneratorRecipe(exporter, BlockContent.SIMPLE_AUGMENT_STATION.asItem(), RecipeHelpers.of((ItemLike)Items.BREWING_STAND), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of(TagUtils.cItemTag("storage_blocks/redstone")), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), "augment/basic");
        this.offerGeneratorRecipe(exporter, BlockContent.ADVANCED_AUGMENT_STATION.asItem(), RecipeHelpers.of((ItemLike)BlockContent.CENTRIFUGE_BLOCK), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.FLUX_GATE), RecipeHelpers.of((ItemLike)ItemContent.DURATIUM_INGOT), "augment/advanced");
        this.offerGeneratorRecipe(exporter, BlockContent.ARCANE_AUGMENT_STATION.asItem(), RecipeHelpers.of((ItemLike)Items.ENDER_EYE), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of((ItemLike)ItemContent.ENDERIC_LENS), RecipeHelpers.of((ItemLike)ItemContent.OVERCHARGED_CRYSTAL), "augment/arcane");
    }

    private void addComponents(RecipeOutput exporter) {
        CentrifugeRecipeBuilder.build().input(TagContent.COAL_DUSTS).result(ItemContent.CARBON_FIBRE_STRANDS).timeMultiplier(0.5f).export(exporter, "carbon");
        this.offerManualAlloyRecipe(exporter, ItemContent.STEEL_INGOT, RecipeHelpers.of(TagUtils.cItemTag("ingots/iron")), RecipeHelpers.of((TagKey<Item>)ItemTags.COALS), "steel");
        this.offerManualAlloyRecipe(exporter, ItemContent.ELECTRUM_INGOT, RecipeHelpers.of(TagUtils.cItemTag("ingots/gold")), RecipeHelpers.of(TagUtils.cItemTag("dusts/redstone")), "electrum");
        this.offerManualAlloyRecipe(exporter, ItemContent.ADAMANT_INGOT, RecipeHelpers.of(TagContent.NICKEL_INGOTS), RecipeHelpers.of(TagUtils.cItemTag("gems/diamond")), "adamant");
        PulverizerRecipeBuilder.build().input(TagUtils.cItemTag("ender_pearls")).result(ItemContent.ENDERIC_COMPOUND, 8).export(exporter, "pearl_enderic");
        GrinderRecipeBuilder.build().input(TagUtils.cItemTag("ender_pearls")).result(ItemContent.ENDERIC_COMPOUND, 12).export(exporter, "pearl_enderic");
        GrinderRecipeBuilder.build().input((ItemLike)Blocks.END_STONE).result(ItemContent.ENDERIC_COMPOUND).export(exporter, "stone_enderic");
        this.offerBeadsRecipe(exporter, ItemContent.CLAY_CATALYST_BEADS, 8, RecipeHelpers.of((ItemLike)Items.CLAY_BALL), RecipeHelpers.of((TagKey<Item>)ItemTags.SAND), RecipeHelpers.of((ItemLike)Items.REDSTONE), "claybeads");
        AssemblerRecipeBuilder.build().input((ItemLike)Items.CLAY_BALL).input((ItemLike)Items.CLAY_BALL).input((TagKey<Item>)ItemTags.SAND).input((ItemLike)Items.REDSTONE).result(ItemContent.CLAY_CATALYST_BEADS, 32).timeMultiplier(1.0f).export(exporter, "claybeads");
        this.offerInsulatedCableRecipe(exporter, new ItemStack((ItemLike)ItemContent.MAGNETIC_COIL, 4), RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of(TagContent.NICKEL_INGOTS), "magnet");
        AssemblerRecipeBuilder.build().input(TagContent.STEEL_INGOTS).input(TagContent.NICKEL_INGOTS).input(TagContent.NICKEL_INGOTS).input(TagUtils.cItemTag("ingots/copper")).result(ItemContent.MAGNETIC_COIL, 6).timeMultiplier(0.4f).export(exporter, "magnet");
        this.offerMotorRecipe(exporter, ItemContent.MOTOR, RecipeHelpers.of(TagContent.NICKEL_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.MAGNETIC_COIL), RecipeHelpers.of(TagContent.STEEL_INGOTS), "motorcraft");
        AssemblerRecipeBuilder.build().input(TagContent.NICKEL_INGOTS).input(TagContent.STEEL_INGOTS).input((ItemLike)ItemContent.MAGNETIC_COIL).input((ItemLike)ItemContent.MAGNETIC_COIL).result(ItemContent.MOTOR, 2).timeMultiplier(0.4f).export(exporter, "motor");
        this.offerMachinePlatingRecipe(exporter, BlockContent.MACHINE_PLATING_BLOCK.asItem(), RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of((ItemLike)Blocks.STONE.asItem()), RecipeHelpers.of(TagUtils.cItemTag("ingots/copper")), 2, "plating");
        AssemblerRecipeBuilder.build().input(TagContent.STEEL_INGOTS).input(TagContent.STEEL_INGOTS).input(TagUtils.cItemTag("ingots/copper")).input(TagContent.PLASTIC_PLATES).result(BlockContent.MACHINE_PLATING_BLOCK.asItem(), 8).timeMultiplier(0.8f).export(exporter, "plating");
        this.offerMachinePlatingRecipe(exporter, BlockContent.IRON_PLATING_BLOCK.asItem(), RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of((ItemLike)Blocks.STONE.asItem()), RecipeHelpers.of(TagUtils.cItemTag("ingots/iron")), 2, "iron");
        AssemblerRecipeBuilder.build().input(TagContent.STEEL_INGOTS).input(TagContent.STEEL_INGOTS).input(TagUtils.cItemTag("ingots/iron")).input(TagContent.PLASTIC_PLATES).result(BlockContent.IRON_PLATING_BLOCK.asItem(), 8).timeMultiplier(0.8f).export(exporter, "platingiron");
        this.offerMachinePlatingRecipe(exporter, BlockContent.NICKEL_PLATING_BLOCK.asItem(), RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of((ItemLike)Blocks.STONE.asItem()), RecipeHelpers.of(TagContent.NICKEL_INGOTS), 2, "nickel");
        AssemblerRecipeBuilder.build().input(TagContent.STEEL_INGOTS).input(TagContent.STEEL_INGOTS).input(TagContent.NICKEL_INGOTS).input(TagContent.PLASTIC_PLATES).result(BlockContent.NICKEL_PLATING_BLOCK.asItem(), 8).timeMultiplier(0.8f).export(exporter, "platingnickel");
        this.offerMachinePlatingRecipe(exporter, BlockContent.CARBON_PLATING_BLOCK.asItem(), RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of((ItemLike)Blocks.STONE.asItem()), RecipeHelpers.of((ItemLike)ItemContent.REINFORCED_CARBON_SHEET), 2, "carbon");
        AssemblerRecipeBuilder.build().input(TagContent.STEEL_INGOTS).input(TagContent.STEEL_INGOTS).input((ItemLike)ItemContent.REINFORCED_CARBON_SHEET).input(TagContent.PLASTIC_PLATES).result(BlockContent.CARBON_PLATING_BLOCK.asItem(), 8).timeMultiplier(0.8f).export(exporter, "platingcarbon");
        this.offerMotorRecipe(exporter, ItemContent.BASIC_BATTERY, RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of(TagContent.PLASTIC_PLATES), "manualbattery");
        AssemblerRecipeBuilder.build().input(TagContent.PLASTIC_PLATES).input(TagContent.ELECTRUM_INGOTS).input(TagContent.ELECTRUM_INGOTS).input(TagContent.STEEL_INGOTS).result(ItemContent.BASIC_BATTERY).timeMultiplier(0.4f).export(exporter, "battery");
        AssemblerRecipeBuilder.build().input(TagContent.PLASTIC_PLATES).input((ItemLike)ItemContent.FLUXITE).input((ItemLike)ItemContent.FLUXITE).input(TagContent.STEEL_INGOTS).result(ItemContent.BASIC_BATTERY, 2).timeMultiplier(0.8f).export(exporter, "batterybetter");
        this.offerManualAlloyRecipe(exporter, ItemContent.RAW_SILICON, RecipeHelpers.of(TagContent.QUARTZ_DUSTS), RecipeHelpers.of((TagKey<Item>)ItemTags.SAND), 3, "rawsilicon");
        OritechRecipeGenerator.oreSmelting(exporter, List.of(ItemContent.RAW_SILICON), RecipeCategory.MISC, (ItemLike)ItemContent.SILICON, 0.5f, 60, "siliconfurnace");
        OritechRecipeGenerator.twoByTwoPacker((RecipeOutput)exporter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ItemContent.PACKED_WHEAT, (ItemLike)Items.WHEAT);
        CentrifugeFluidRecipeBuilder.build().input((ItemLike)ItemContent.PACKED_WHEAT).result(ItemContent.RAW_BIOPOLYMER).fluidInput((Fluid)Fluids.WATER, 0.25f).export(exporter, "biopolymer");
        CentrifugeFluidRecipeBuilder.build().input((ItemLike)ItemContent.SOLID_BIOFUEL).result(ItemContent.RAW_BIOPOLYMER).fluidInput((Fluid)Fluids.WATER, 0.25f).export(exporter, "biopolymer_biomass");
        CentrifugeFluidRecipeBuilder.build().input(TagContent.BIOMASS_BLOCK).result(ItemContent.RAW_BIOPOLYMER).fluidInput((Fluid)Fluids.WATER, 0.25f).export(exporter, "biopolymer_bioblock");
        CentrifugeFluidRecipeBuilder.build().input((TagKey<Item>)ItemTags.SAND).result(ItemContent.POLYMER_RESIN).fluidInput(TagUtils.cFluidTag("biodiesel"), 0.1f).time(100).export(exporter, "polymerresin");
        CentrifugeFluidRecipeBuilder.build().input((ItemLike)ItemContent.RAW_BIOPOLYMER).result(ItemContent.PLASTIC_SHEET, 1).fluidInput((Fluid)Fluids.WATER, 0.5f).time(120).export(exporter, "plasticoil");
        CentrifugeFluidRecipeBuilder.build().input((ItemLike)ItemContent.RAW_BIOPOLYMER).result(ItemContent.PLASTIC_SHEET, 2).fluidInput((Fluid)FluidContent.STILL_MINERAL_SLURRY.get(), 0.25f).time(120).export(exporter, "plasticoilbetter");
        CentrifugeFluidRecipeBuilder.build().input((ItemLike)ItemContent.POLYMER_RESIN).result(ItemContent.PLASTIC_SHEET, 2).fluidInput((Fluid)Fluids.WATER, 0.5f).time(40).export(exporter, "plasticbio");
        CentrifugeFluidRecipeBuilder.build().input((ItemLike)ItemContent.POLYMER_RESIN).result(ItemContent.PLASTIC_SHEET, 4).fluidInput((Fluid)FluidContent.STILL_MINERAL_SLURRY.get(), 0.25f).time(40).export(exporter, "plasticbiobetter");
        OritechRecipeGenerator.oreSmelting(exporter, List.of(ItemContent.POLYMER_RESIN), RecipeCategory.MISC, (ItemLike)ItemContent.PLASTIC_SHEET, 0.5f, 10, "plastic_manual");
        OritechRecipeGenerator.oreBlasting(exporter, List.of(ItemContent.POLYMER_RESIN), RecipeCategory.MISC, (ItemLike)ItemContent.PLASTIC_SHEET, 0.5f, 10, "plastic_manual_blast");
        AssemblerRecipeBuilder.build().input(TagContent.PLASTIC_PLATES).input(TagContent.CARBON_FIBRE).input(TagContent.ELECTRUM_INGOTS).input(TagUtils.cItemTag("dusts/redstone")).result(ItemContent.PROCESSING_UNIT).timeMultiplier(0.8f).export(exporter, "processingunit");
        AssemblerRecipeBuilder.build().input((ItemLike)ItemContent.ADAMANT_INGOT).input(TagContent.CARBON_FIBRE).input((ItemLike)ItemContent.ENDERIC_COMPOUND).input((ItemLike)ItemContent.ENDERIC_COMPOUND).result(ItemContent.ENDERIC_LENS).timeMultiplier(1.2f).export(exporter, "enderlens");
        AssemblerRecipeBuilder.build().input((ItemLike)ItemContent.PROCESSING_UNIT).input((ItemLike)ItemContent.FLUXITE).input((ItemLike)ItemContent.FLUXITE).input(TagContent.PLATINUM_INGOTS).result(ItemContent.FLUX_GATE).timeMultiplier(1.2f).export(exporter, "fluxgate");
        AtomicForgeRecipeBuilder.build().input(TagContent.CARBON_FIBRE).input(TagContent.SILICON).input(TagContent.SILICON).result(ItemContent.SILICON_WAFER).time(5).export(exporter, "wafer");
        AtomicForgeRecipeBuilder.build().input((ItemLike)ItemContent.PROCESSING_UNIT).input((ItemLike)ItemContent.SILICON_WAFER).input((ItemLike)ItemContent.SILICON_WAFER).result(ItemContent.ADVANCED_COMPUTING_ENGINE).time(5).export(exporter, "advcomputer");
        AtomicForgeRecipeBuilder.build().input((ItemLike)ItemContent.DURATIUM_INGOT).input((ItemLike)ItemContent.ADVANCED_COMPUTING_ENGINE).input((ItemLike)ItemContent.ADVANCED_COMPUTING_ENGINE).result(ItemContent.SUPER_AI_CHIP).time(50).export(exporter, "aicomputer");
        this.offerMotorRecipe(exporter, ItemContent.DUBIOS_CONTAINER, RecipeHelpers.of(TagContent.PLASTIC_PLATES), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), RecipeHelpers.of((ItemLike)ItemContent.ENDERIC_COMPOUND), "dubios");
        this.offerMotorRecipe(exporter, ItemContent.ADVANCED_BATTERY, RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of((ItemLike)ItemContent.ENERGITE_INGOT), RecipeHelpers.of(TagContent.STEEL_INGOTS), "advbattery");
        AssemblerRecipeBuilder.build().input((ItemLike)ItemContent.REINFORCED_CARBON_SHEET).input((ItemLike)ItemContent.REINFORCED_CARBON_SHEET).input((ItemLike)ItemContent.ADVANCED_BATTERY).input((ItemLike)ItemContent.FLUX_GATE).result(ItemContent.ION_THRUSTER, 2).timeMultiplier(2.0f).export(exporter, "ionthruster");
        FoundryRecipeBuilder.build().input((ItemLike)ItemContent.RAW_BIOPOLYMER).input(TagUtils.cItemTag("ingots/iron")).result(ItemContent.BIOSTEEL_INGOT).export(exporter, "biosteel");
        AtomicForgeRecipeBuilder.build().input((ItemLike)ItemContent.SUPER_AI_CHIP).input((ItemLike)ItemContent.ADAMANT_INGOT).input((ItemLike)ItemContent.ADAMANT_INGOT).result(ItemContent.HEISENBERG_COMPENSATOR).time(60).export(exporter, "compensator");
        AtomicForgeRecipeBuilder.build().input((ItemLike)ItemContent.UNHOLY_INTELLIGENCE).input((ItemLike)ItemContent.ADAMANT_INGOT).input((ItemLike)ItemContent.ADAMANT_INGOT).result(ItemContent.HEISENBERG_COMPENSATOR).time(60).export(exporter, "compensatoralt");
        this.offerMotorRecipe(exporter, ItemContent.OVERCHARGED_CRYSTAL, RecipeHelpers.of((ItemLike)Items.AMETHYST_BLOCK), RecipeHelpers.of((ItemLike)ItemContent.ADVANCED_BATTERY), RecipeHelpers.of((ItemLike)BlockContent.SUPERCONDUCTOR.asItem()), "overchargedcrystal");
        AssemblerRecipeBuilder.build().input((ItemLike)ItemContent.FLUX_GATE).input(TagContent.ELECTRUM_INGOTS).input((ItemLike)ItemContent.DUBIOS_CONTAINER).input((ItemLike)ItemContent.ENERGITE_INGOT).result(BlockContent.SUPERCONDUCTOR.asItem(), 4).timeMultiplier(1.6f).export(exporter, "superconductor");
        AtomicForgeRecipeBuilder.build().input((ItemLike)ItemContent.HEISENBERG_COMPENSATOR).input((ItemLike)ItemContent.OVERCHARGED_CRYSTAL).input((ItemLike)ItemContent.OVERCHARGED_CRYSTAL).result(ItemContent.PROMETHEUM_INGOT).time(240).export(exporter, "prometheum");
        CoolerRecipeBuilder.build().fluidInput((Fluid)Fluids.WATER).result(Items.ICE, 3).export(exporter, "ice");
        CoolerRecipeBuilder.build().fluidInput((Fluid)FluidContent.STILL_STEAM.get()).result(Items.SNOW_BLOCK, 3).export(exporter, "snow");
        CoolerRecipeBuilder.build().fluidInput((Fluid)Fluids.LAVA).result(Items.OBSIDIAN, 2).export(exporter, "obsidian");
    }

    private void addCompactingRecipes(RecipeOutput exporter) {
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.STEEL_BLOCK, (ItemLike)ItemContent.STEEL_INGOT, RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of(TagUtils.getStorageBlockTag("steel")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.ENERGITE_BLOCK, (ItemLike)ItemContent.ENERGITE_INGOT, RecipeHelpers.of(TagUtils.getIngotTag("energite")), RecipeHelpers.of(TagUtils.getStorageBlockTag("energite")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.NICKEL_BLOCK, (ItemLike)ItemContent.NICKEL_INGOT, RecipeHelpers.of(TagUtils.getIngotTag("nickel")), RecipeHelpers.of(TagUtils.getStorageBlockTag("nickel")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.BIOSTEEL_BLOCK, (ItemLike)ItemContent.BIOSTEEL_INGOT, RecipeHelpers.of((ItemLike)ItemContent.BIOSTEEL_INGOT), RecipeHelpers.of(TagUtils.getStorageBlockTag("biosteel")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.PLATINUM_BLOCK, (ItemLike)ItemContent.PLATINUM_INGOT, RecipeHelpers.of(TagUtils.getIngotTag("platinum")), RecipeHelpers.of(TagUtils.getStorageBlockTag("platinum")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.ADAMANT_BLOCK, (ItemLike)ItemContent.ADAMANT_INGOT, RecipeHelpers.of(TagUtils.getIngotTag("adamant")), RecipeHelpers.of(TagUtils.getStorageBlockTag("adamant")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.ELECTRUM_BLOCK, (ItemLike)ItemContent.ELECTRUM_INGOT, RecipeHelpers.of(TagUtils.getIngotTag("electrum")), RecipeHelpers.of(TagUtils.getStorageBlockTag("electrum")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.DURATIUM_BLOCK, (ItemLike)ItemContent.DURATIUM_INGOT, RecipeHelpers.of(TagUtils.getIngotTag("duratium")), RecipeHelpers.of(TagUtils.getStorageBlockTag("duratium")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.BIOMASS_BLOCK, (ItemLike)ItemContent.BIOMASS, RecipeHelpers.of((ItemLike)ItemContent.BIOMASS), RecipeHelpers.of(TagUtils.getStorageBlockTag("biomass")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.PLASTIC_BLOCK, (ItemLike)ItemContent.PLASTIC_SHEET, RecipeHelpers.of(TagContent.PLASTIC_PLATES), RecipeHelpers.of(TagUtils.getStorageBlockTag("plastic")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.FLUXITE_BLOCK, (ItemLike)ItemContent.FLUXITE, RecipeHelpers.of((ItemLike)ItemContent.FLUXITE), RecipeHelpers.of(TagUtils.getStorageBlockTag("fluxite")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.SILICON_BLOCK, (ItemLike)ItemContent.SILICON, RecipeHelpers.of(TagContent.SILICON), RecipeHelpers.of(TagUtils.getStorageBlockTag("silicon")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.RAW_NICKEL_BLOCK, (ItemLike)ItemContent.RAW_NICKEL, RecipeHelpers.of(TagContent.NICKEL_RAW_MATERIALS), RecipeHelpers.of(TagUtils.getStorageBlockTag("raw_nickel")));
        this.addCompactingRecipe(exporter, (ItemLike)BlockContent.RAW_PLATINUM_BLOCK, (ItemLike)ItemContent.RAW_PLATINUM, RecipeHelpers.of(TagContent.PLATINUM_RAW_MATERIALS), RecipeHelpers.of(TagUtils.getStorageBlockTag("raw_platinum")));
    }

    public static void oreSmelting(RecipeOutput exporter, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float experience, int cookingTime, String group) {
        OritechRecipeGenerator.oreCooking(exporter, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, inputs, category, output, experience, cookingTime, group, "_from_smelting");
    }

    public static void oreBlasting(RecipeOutput exporter, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float experience, int cookingTime, String group) {
        OritechRecipeGenerator.oreCooking(exporter, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, inputs, category, output, experience, cookingTime, group, "_from_blasting");
    }

    public static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput exporter, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> recipeFactory, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float experience, int cookingTime, String group, String suffix) {
        for (ItemLike itemConvertible : inputs) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemConvertible}), (RecipeCategory)category, (ItemLike)output, (float)experience, (int)cookingTime, serializer, recipeFactory).group(group).unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)itemConvertible), OritechRecipeGenerator.has((ItemLike)itemConvertible)).save(exporter, Oritech.id(OritechRecipeGenerator.getItemName((ItemLike)output) + suffix + "_" + OritechRecipeGenerator.getItemName((ItemLike)itemConvertible)));
        }
    }

    private void addOreChains(RecipeOutput exporter) {
        OritechRecipeGenerator.oreSmelting(exporter, List.of(ItemContent.RAW_NICKEL), RecipeCategory.MISC, (ItemLike)ItemContent.NICKEL_INGOT, 1.0f, 200, "nickelsmelting");
        OritechRecipeGenerator.oreSmelting(exporter, List.of(ItemContent.RAW_PLATINUM), RecipeCategory.MISC, (ItemLike)ItemContent.PLATINUM_INGOT, 1.0f, 200, "platinumsmelting");
        OritechRecipeGenerator.oreBlasting(exporter, List.of(ItemContent.RAW_NICKEL), RecipeCategory.MISC, (ItemLike)ItemContent.NICKEL_INGOT, 1.0f, 100, "nickelblasting");
        OritechRecipeGenerator.oreBlasting(exporter, List.of(ItemContent.RAW_PLATINUM), RecipeCategory.MISC, (ItemLike)ItemContent.PLATINUM_INGOT, 1.0f, 100, "platinumblasting");
        MetalProcessingChainBuilder.build("iron").ore((TagKey<Item>)ItemTags.IRON_ORES).rawOre(TagUtils.cItemTag("raw_materials/iron"), Items.RAW_IRON).rawOreByproduct(ItemContent.RAW_NICKEL).ingot(TagUtils.cItemTag("ingots/iron"), Items.IRON_INGOT).nugget(TagUtils.cItemTag("nuggets/iron"), Items.IRON_NUGGET).clump(TagContent.IRON_CLUMPS, ItemContent.IRON_CLUMP).smallClump(ItemContent.SMALL_IRON_CLUMP).clumpByproduct(ItemContent.SMALL_NICKEL_CLUMP).dust(ItemContent.IRON_DUST).smallDust(ItemContent.SMALL_IRON_DUST).dustByproduct(ItemContent.SMALL_NICKEL_DUST).gem(ItemContent.IRON_GEM).gemCatalyst(ItemContent.FLUXITE).vanillaProcessing().skipCompacting().export(exporter);
        MetalProcessingChainBuilder.build("copper").ore((TagKey<Item>)ItemTags.COPPER_ORES).rawOre(TagUtils.cItemTag("raw_materials/copper"), Items.RAW_COPPER).rawOreByproduct(Items.RAW_GOLD).ingot(TagUtils.cItemTag("ingots/copper"), Items.COPPER_INGOT).nugget(TagContent.COPPER_NUGGETS, ItemContent.COPPER_NUGGET).clump(TagContent.COPPER_CLUMPS, ItemContent.COPPER_CLUMP).smallClump(ItemContent.SMALL_COPPER_CLUMP).clumpByproduct(ItemContent.SMALL_GOLD_CLUMP).dust(ItemContent.COPPER_DUST).smallDust(ItemContent.SMALL_COPPER_DUST).dustByproduct(ItemContent.SMALL_GOLD_DUST).gem(ItemContent.COPPER_GEM).gemCatalyst(ItemContent.FLUXITE).vanillaProcessing().skipCompacting().export(exporter);
        MetalProcessingChainBuilder.build("gold").ore((TagKey<Item>)ItemTags.GOLD_ORES).rawOre(TagUtils.cItemTag("raw_materials/gold"), Items.RAW_GOLD).rawOreByproduct(Items.RAW_COPPER).ingot(TagUtils.cItemTag("ingots/gold"), Items.GOLD_INGOT).nugget(TagUtils.cItemTag("nuggets/gold"), Items.GOLD_NUGGET).clump(TagContent.GOLD_CLUMPS, ItemContent.GOLD_CLUMP).smallClump(ItemContent.SMALL_GOLD_CLUMP).clumpByproduct(ItemContent.SMALL_COPPER_CLUMP).dust(ItemContent.GOLD_DUST).smallDust(ItemContent.SMALL_GOLD_DUST).dustByproduct(ItemContent.SMALL_COPPER_DUST).gem(ItemContent.GOLD_GEM).gemCatalyst(ItemContent.FLUXITE).vanillaProcessing().skipCompacting().export(exporter);
        MetalProcessingChainBuilder.build("nickel").ore(TagContent.NICKEL_ORES).rawOre(TagContent.NICKEL_RAW_MATERIALS, ItemContent.RAW_NICKEL).rawOreByproduct(ItemContent.RAW_PLATINUM).ingot(TagContent.NICKEL_INGOTS, ItemContent.NICKEL_INGOT).nugget(TagContent.NICKEL_NUGGETS, ItemContent.NICKEL_NUGGET).clump(TagContent.NICKEL_CLUMPS, ItemContent.NICKEL_CLUMP).smallClump(ItemContent.SMALL_NICKEL_CLUMP).clumpByproduct(ItemContent.SMALL_PLATINUM_CLUMP).dust(ItemContent.NICKEL_DUST).smallDust(ItemContent.SMALL_NICKEL_DUST).dustByproduct(ItemContent.SMALL_PLATINUM_DUST).byproductAmount(2).gem(ItemContent.NICKEL_GEM).gemCatalyst(ItemContent.FLUXITE).vanillaProcessing().export(exporter);
        MetalProcessingChainBuilder.build("platinum").ore(TagContent.PLATINUM_ORES).rawOre(TagContent.PLATINUM_RAW_MATERIALS, ItemContent.RAW_PLATINUM).rawOreByproduct(ItemContent.FLUXITE).ingot(TagContent.PLATINUM_INGOTS, ItemContent.PLATINUM_INGOT).nugget(TagContent.PLATINUM_NUGGETS, ItemContent.PLATINUM_NUGGET).clump(TagContent.PLATINUM_CLUMPS, ItemContent.PLATINUM_CLUMP).smallClump(ItemContent.SMALL_PLATINUM_CLUMP).clumpByproduct(ItemContent.FLUXITE).dust(ItemContent.PLATINUM_DUST).smallDust(ItemContent.SMALL_PLATINUM_DUST).dustByproduct(ItemContent.FLUXITE).byproductAmount(1).gem(ItemContent.PLATINUM_GEM).gemCatalyst(ItemContent.FLUXITE).timeMultiplier(1.5f).vanillaProcessing().export(exporter);
    }

    private void addAlloys(RecipeOutput exporter) {
        FoundryRecipeBuilder.build().input(TagContent.PLATINUM_INGOTS).input(TagUtils.cItemTag("ingots/netherite")).result(ItemContent.DURATIUM_INGOT).export(exporter, "duratium");
        FoundryRecipeBuilder.build().input(TagUtils.cItemTag("ingots/gold")).input(TagUtils.cItemTag("dusts/redstone")).result(ItemContent.ELECTRUM_INGOT).export(exporter, "electrum");
        FoundryRecipeBuilder.build().input(TagUtils.cItemTag("gems/diamond")).input(TagContent.NICKEL_INGOTS).result(ItemContent.ADAMANT_INGOT).export(exporter, "adamant");
        FoundryRecipeBuilder.build().input(TagContent.NICKEL_INGOTS).input((ItemLike)ItemContent.FLUXITE).result(ItemContent.ENERGITE_INGOT).export(exporter, "energite");
        FoundryRecipeBuilder.build().input(TagUtils.cItemTag("ingots/iron")).input(TagContent.COAL_DUSTS).result(ItemContent.STEEL_INGOT).timeMultiplier(0.3333f).export(exporter, "steel");
        AtomicForgeRecipeBuilder.build().input(TagContent.PLATINUM_INGOTS).input((ItemLike)ItemContent.REINFORCED_CARBON_SHEET).input((ItemLike)ItemContent.REINFORCED_CARBON_SHEET).result(ItemContent.DURATIUM_INGOT).export(exporter, "duratium");
    }

    private void addParticleCollisions(RecipeOutput exporter) {
        ParticleCollisionRecipeBuilder.build().input(TagContent.COAL_DUSTS).input(TagContent.COAL_DUSTS).result(Items.DIAMOND).time(500).export(exporter, "diamond");
        ParticleCollisionRecipeBuilder.build().input((ItemLike)ItemContent.FLUXITE).input((ItemLike)ItemContent.ENERGITE_DUST).result(ItemContent.OVERCHARGED_CRYSTAL).time(5000).export(exporter, "overcharged_crystal");
        ParticleCollisionRecipeBuilder.build().input(TagContent.GOLD_DUSTS).input(TagContent.GOLD_DUSTS).result(ItemContent.PLATINUM_DUST).time(500).export(exporter, "platinum_dust");
        ParticleCollisionRecipeBuilder.build().input(TagUtils.cItemTag("dusts/redstone")).input((ItemLike)Items.ROTTEN_FLESH).result(ItemContent.ENDERIC_COMPOUND).time(500).export(exporter, "enderic_compound");
        ParticleCollisionRecipeBuilder.build().input(TagContent.ELECTRUM_DUSTS).input(TagUtils.cItemTag("dusts/redstone")).result(ItemContent.FLUXITE).time(1000).export(exporter, "fluxite");
        ParticleCollisionRecipeBuilder.build().input((ItemLike)ItemContent.ADAMANT_DUST).input((ItemLike)Items.NETHERRACK).result(Items.NETHERITE_SCRAP).time(2500).export(exporter, "netherite");
        ParticleCollisionRecipeBuilder.build().input(TagUtils.cItemTag("feathers")).input((ItemLike)Items.SADDLE).result(Items.ELYTRA).time(10000).export(exporter, "elytra");
        ParticleCollisionRecipeBuilder.build().input((ItemLike)ItemContent.OVERCHARGED_CRYSTAL).input(TagUtils.cItemTag("ingots/netherite")).result(Items.NETHER_STAR).time(15000).export(exporter, "nether_star");
        ParticleCollisionRecipeBuilder.build().input(TagUtils.cItemTag("ender_pearls")).input(TagUtils.cItemTag("gems/amethyst")).result(Items.ECHO_SHARD).time(1000).export(exporter, "echo_shard");
        ParticleCollisionRecipeBuilder.build().input((ItemLike)Items.REINFORCED_DEEPSLATE).input((ItemLike)ItemContent.DURATIUM_DUST).result(Items.HEAVY_CORE).time(8000).export(exporter, "heavy_core");
    }

    private void addDusts(RecipeOutput exporter) {
        RecipeHelpers.addDustRecipe(exporter, RecipeHelpers.of((ItemLike)ItemContent.BIOSTEEL_INGOT), ItemContent.BIOSTEEL_DUST, ItemContent.BIOSTEEL_INGOT, "biosteel");
        RecipeHelpers.addDustRecipe(exporter, RecipeHelpers.of((ItemLike)ItemContent.DURATIUM_INGOT), ItemContent.DURATIUM_DUST, ItemContent.DURATIUM_INGOT, "duratium");
        RecipeHelpers.addDustRecipe(exporter, RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), ItemContent.ELECTRUM_DUST, ItemContent.ELECTRUM_INGOT, "electrum");
        RecipeHelpers.addDustRecipe(exporter, RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), ItemContent.ADAMANT_DUST, ItemContent.ADAMANT_INGOT, "adamant");
        RecipeHelpers.addDustRecipe(exporter, RecipeHelpers.of((ItemLike)ItemContent.ENERGITE_INGOT), ItemContent.ENERGITE_DUST, ItemContent.ENERGITE_INGOT, "energite");
        RecipeHelpers.addDustRecipe(exporter, RecipeHelpers.of(TagContent.STEEL_INGOTS), ItemContent.STEEL_DUST, ItemContent.STEEL_INGOT, "steel");
        RecipeHelpers.addDustRecipe(exporter, RecipeHelpers.of((TagKey<Item>)ItemTags.COALS), ItemContent.COAL_DUST, "coal");
        RecipeHelpers.addDustRecipe(exporter, RecipeHelpers.of(TagUtils.cItemTag("gems/quartz")), ItemContent.QUARTZ_DUST, "quartz");
        GrinderRecipeBuilder.build().input((TagKey<Item>)ItemTags.COAL_ORES).result(Items.COAL, 3).export(exporter, "coalore");
        PulverizerRecipeBuilder.build().input((TagKey<Item>)ItemTags.COAL_ORES).result(Items.COAL, 2).export(exporter, "coalore");
        GrinderRecipeBuilder.build().input((TagKey<Item>)ItemTags.REDSTONE_ORES).result(Items.REDSTONE, 12).export(exporter, "redstoneore");
        PulverizerRecipeBuilder.build().input((TagKey<Item>)ItemTags.REDSTONE_ORES).result(Items.REDSTONE, 8).export(exporter, "redstoneore");
        GrinderRecipeBuilder.build().input((TagKey<Item>)ItemTags.DIAMOND_ORES).result(Items.DIAMOND, 2).export(exporter, "diamondore");
        PulverizerRecipeBuilder.build().input((TagKey<Item>)ItemTags.DIAMOND_ORES).result(Items.DIAMOND).export(exporter, "diamondore");
        GrinderRecipeBuilder.build().input((ItemLike)Blocks.NETHER_QUARTZ_ORE).result(Items.QUARTZ, 3).export(exporter, "quartzore");
        PulverizerRecipeBuilder.build().input((ItemLike)Blocks.NETHER_QUARTZ_ORE).result(Items.QUARTZ, 2).export(exporter, "quartzore");
        GrinderRecipeBuilder.build().input((ItemLike)Blocks.GLOWSTONE).result(Items.GLOWSTONE_DUST, 4).export(exporter, "glowstoneore");
        PulverizerRecipeBuilder.build().input((ItemLike)Blocks.GLOWSTONE).result(Items.GLOWSTONE_DUST, 3).export(exporter, "glowstoneore");
        GrinderRecipeBuilder.build().input((TagKey<Item>)ItemTags.LAPIS_ORES).result(Items.LAPIS_LAZULI, 8).export(exporter, "lapisore");
        PulverizerRecipeBuilder.build().input((TagKey<Item>)ItemTags.LAPIS_ORES).result(Items.LAPIS_LAZULI, 6).export(exporter, "lapisore");
        GrinderRecipeBuilder.build().input((ItemLike)Items.BONE).result(Items.BONE_MEAL, 8).export(exporter, "bone");
        PulverizerRecipeBuilder.build().input((ItemLike)Items.BONE).result(Items.BONE_MEAL, 6).export(exporter, "bone");
        GrinderRecipeBuilder.build().input((ItemLike)Items.BLAZE_ROD).result(Items.BLAZE_POWDER, 4).export(exporter, "blaze");
        PulverizerRecipeBuilder.build().input((ItemLike)Items.BLAZE_ROD).result(Items.BLAZE_POWDER, 3).export(exporter, "blaze");
        GrinderRecipeBuilder.build().input((TagKey<Item>)ItemTags.WOOL).result(Items.STRING, 4).export(exporter, "string");
        PulverizerRecipeBuilder.build().input((TagKey<Item>)ItemTags.WOOL).result(Items.STRING, 3).export(exporter, "string");
        GrinderRecipeBuilder.build().input((ItemLike)Items.ANCIENT_DEBRIS).result(Items.NETHERITE_SCRAP, 2).export(exporter, "netheritescrap");
    }

    private void addUraniumProcessing(RecipeOutput exporter) {
        CentrifugeRecipeBuilder.build().input(TagUtils.cItemTag("dusts/redstone")).result(ItemContent.SMALL_URANIUM_DUST).export(exporter, "redstoneuran");
        GrinderRecipeBuilder.build().input((ItemLike)BlockContent.DEEPSLATE_URANIUM_ORE).result(ItemContent.RAW_URANIUM, 3).result(ItemContent.SMALL_PLUTONIUM_DUST).export(exporter, "uraniumore");
        PulverizerRecipeBuilder.build().input((ItemLike)BlockContent.DEEPSLATE_URANIUM_ORE).result(ItemContent.RAW_URANIUM, 2).export(exporter, "uraniumore");
        GrinderRecipeBuilder.build().input((ItemLike)BlockContent.URANIUM_CRYSTAL).result(ItemContent.RAW_URANIUM, 5).result(ItemContent.SMALL_PLUTONIUM_DUST).export(exporter, "uraniumcrystal");
        PulverizerRecipeBuilder.build().input((ItemLike)BlockContent.URANIUM_CRYSTAL).result(ItemContent.RAW_URANIUM, 4).export(exporter, "uraniumcrystal");
        GrinderRecipeBuilder.build().input(TagContent.URANIUM_RAW_MATERIALS).result(ItemContent.URANIUM_DUST, 2).result(ItemContent.SMALL_PLUTONIUM_DUST).export(exporter, "uranium");
        PulverizerRecipeBuilder.build().input(TagContent.URANIUM_RAW_MATERIALS).result(ItemContent.URANIUM_DUST, 2).export(exporter, "uranium");
        AtomicForgeRecipeBuilder.build().input(TagContent.COPPER_DUSTS).input(TagContent.URANIUM_RAW_MATERIALS).input(TagContent.URANIUM_RAW_MATERIALS).result(ItemContent.URANIUM_GEM).time(5).export(exporter, "urandust");
        AtomicForgeRecipeBuilder.build().input(TagContent.COPPER_DUSTS).input(TagContent.URANIUM_DUSTS).input(TagContent.URANIUM_DUSTS).result(ItemContent.URANIUM_GEM).time(5).export(exporter, "urandustgem");
        AssemblerRecipeBuilder.build().input((ItemLike)ItemContent.URANIUM_GEM).input((ItemLike)ItemContent.URANIUM_GEM).input(TagContent.PLASTIC_PLATES).input(TagContent.NICKEL_INGOTS).result(ItemContent.URANIUM_PELLET, 2).timeMultiplier(0.8f).export(exporter, "uranpelletbasic");
        AssemblerRecipeBuilder.build().input((ItemLike)ItemContent.URANIUM_GEM).input((ItemLike)ItemContent.URANIUM_GEM).input(TagContent.PLASTIC_PLATES).input((ItemLike)ItemContent.ADAMANT_INGOT).result(ItemContent.URANIUM_PELLET, 3).timeMultiplier(0.8f).export(exporter, "uranpelletbetter");
        AssemblerRecipeBuilder.build().input((ItemLike)ItemContent.URANIUM_GEM).input((ItemLike)ItemContent.URANIUM_GEM).input(TagContent.PLASTIC_PLATES).input((ItemLike)ItemContent.DURATIUM_INGOT).result(ItemContent.URANIUM_PELLET, 4).timeMultiplier(0.8f).export(exporter, "uranpelletult");
        AssemblerRecipeBuilder.build().input((ItemLike)ItemContent.PLUTONIUM_DUST).input((ItemLike)ItemContent.PLUTONIUM_DUST).input(TagContent.PLASTIC_PLATES).input(TagContent.NICKEL_INGOTS).result(ItemContent.PLUTONIUM_PELLET, 2).timeMultiplier(0.8f).export(exporter, "plutoniumpelletbasic");
        AssemblerRecipeBuilder.build().input((ItemLike)ItemContent.PLUTONIUM_DUST).input((ItemLike)ItemContent.PLUTONIUM_DUST).input(TagContent.PLASTIC_PLATES).input((ItemLike)ItemContent.ADAMANT_INGOT).result(ItemContent.PLUTONIUM_PELLET, 3).timeMultiplier(0.8f).export(exporter, "plutoniumpelletbetter");
        AssemblerRecipeBuilder.build().input((ItemLike)ItemContent.PLUTONIUM_DUST).input((ItemLike)ItemContent.PLUTONIUM_DUST).input(TagContent.PLASTIC_PLATES).input((ItemLike)ItemContent.DURATIUM_INGOT).result(ItemContent.PLUTONIUM_PELLET, 4).timeMultiplier(0.8f).export(exporter, "plutoniumpelletult");
        this.addCompactingRecipe(exporter, (ItemLike)ItemContent.URANIUM_DUST, (ItemLike)ItemContent.SMALL_URANIUM_DUST, RecipeHelpers.of((ItemLike)ItemContent.SMALL_URANIUM_DUST), RecipeHelpers.of(TagContent.URANIUM_DUSTS));
        this.addCompactingRecipe(exporter, (ItemLike)ItemContent.PLUTONIUM_DUST, (ItemLike)ItemContent.SMALL_PLUTONIUM_DUST, RecipeHelpers.of((ItemLike)ItemContent.SMALL_PLUTONIUM_DUST), RecipeHelpers.of(TagContent.PLUTONIUM_DUSTS));
        ParticleCollisionRecipeBuilder.build().input(TagContent.URANIUM_DUSTS).input((ItemLike)ItemContent.FLUXITE).result(ItemContent.PLUTONIUM_DUST).time(2500).export(exporter, "plutonium");
        this.addCompactingRecipe(exporter, (ItemLike)ItemContent.URANIUM_PELLET, (ItemLike)ItemContent.SMALL_URANIUM_PELLET, RecipeHelpers.of((ItemLike)ItemContent.SMALL_URANIUM_PELLET), RecipeHelpers.of((ItemLike)ItemContent.URANIUM_PELLET));
        this.addCompactingRecipe(exporter, (ItemLike)ItemContent.PLUTONIUM_PELLET, (ItemLike)ItemContent.SMALL_PLUTONIUM_PELLET, RecipeHelpers.of((ItemLike)ItemContent.SMALL_PLUTONIUM_PELLET), RecipeHelpers.of((ItemLike)ItemContent.PLUTONIUM_PELLET));
    }

    private void addAugmentRecipes(RecipeOutput exporter) {
        ResourceLocation SIMPLE_AUGMENT_STATION_ID = BuiltInRegistries.BLOCK.getKey((Object)BlockContent.SIMPLE_AUGMENT_STATION);
        ResourceLocation ADVANCED_AUGMENT_STATION_ID = BuiltInRegistries.BLOCK.getKey((Object)BlockContent.ADVANCED_AUGMENT_STATION);
        ResourceLocation ARCANE_AUGMENT_STATION_ID = BuiltInRegistries.BLOCK.getKey((Object)BlockContent.ARCANE_AUGMENT_STATION);
        AugmentRecipeBuilder.build().researchCost(TagContent.MACHINE_PLATING, 64).researchCost(TagContent.COAL_DUSTS, 32).researchCost((ItemLike)ItemContent.BIOSTEEL_INGOT, 8).applyCost(TagContent.STEEL_INGOTS, 8).applyCost(TagUtils.cItemTag("ingots/iron"), 16).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(5).uiY(70).time(400).rfCost(10000000L).modifierDefinition((Holder<Attribute>)Attributes.MAX_HEALTH, 6.0f, AttributeModifier.Operation.ADD_VALUE).export(exporter, "hpboost");
        AugmentRecipeBuilder.build().researchCost(TagContent.CARBON_FIBRE, 32).researchCost((ItemLike)ItemContent.BIOSTEEL_INGOT, 16).researchCost(TagUtils.cItemTag("gems/diamond"), 4).applyCost(TagContent.CARBON_FIBRE, 8).applyCost((ItemLike)ItemContent.DURATIUM_INGOT, 4).requirement(Oritech.id("augment/armor")).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(80).uiY(70).time(800).rfCost(50000000L).modifierDefinition((Holder<Attribute>)Attributes.MAX_HEALTH, 4.0f, AttributeModifier.Operation.ADD_VALUE).export(exporter, "hpboostmore");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.ENERGITE_INGOT, 64).researchCost((ItemLike)ItemContent.REINFORCED_CARBON_SHEET, 32).researchCost((ItemLike)Items.NETHER_STAR).applyCost((ItemLike)ItemContent.DURATIUM_DUST, 64).applyCost(TagUtils.cItemTag("storage_blocks/redstone"), 64).requirement(Oritech.id("augment/ultimatearmor")).requiredStation(ADVANCED_AUGMENT_STATION_ID).uiX(165).uiY(70).time(1600).rfCost(200000000L).modifierDefinition((Holder<Attribute>)Attributes.MAX_HEALTH, 10.0f, AttributeModifier.Operation.ADD_VALUE).export(exporter, "hpboostultra");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.ADAMANT_INGOT, 64).researchCost((ItemLike)Items.NETHER_STAR, 8).researchCost((ItemLike)ItemContent.URANIUM_PELLET, 64).researchCost((ItemLike)BlockContent.FLUXITE_BLOCK, 64).applyCost((ItemLike)ItemContent.ADAMANT_INGOT, 32).applyCost((ItemLike)ItemContent.OVERCHARGED_CRYSTAL).applyCost((ItemLike)ItemContent.FLUXITE, 64).requirement(Oritech.id("augment/hpboostultra")).requirement(Oritech.id("augment/gravity")).requiredStation(ADVANCED_AUGMENT_STATION_ID).uiX(205).uiY(40).time(2400).rfCost(500000000L).modifierDefinition((Holder<Attribute>)Attributes.MAX_HEALTH, 10.0f, AttributeModifier.Operation.ADD_VALUE).export(exporter, "hpboostultimate");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.MOTOR, 32).researchCost((ItemLike)ItemContent.BIOSTEEL_INGOT, 64).researchCost(TagUtils.cItemTag("dusts/redstone"), 32).applyCost((ItemLike)ItemContent.MOTOR, 16).applyCost(TagUtils.cItemTag("ingots/iron"), 32).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(5).uiY(30).time(600).rfCost(30000000L).modifierDefinition((Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.25f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).export(exporter, "speedboost");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.ENERGITE_INGOT, 64).researchCost((ItemLike)ItemContent.ION_THRUSTER, 32).researchCost((ItemLike)ItemContent.FLUX_GATE, 16).applyCost((ItemLike)ItemContent.MAGNETIC_COIL, 32).applyCost((ItemLike)ItemContent.OVERCHARGED_CRYSTAL).applyCost(TagContent.ELECTRUM_DUSTS, 64).requirement(Oritech.id("augment/speedboost")).requirement(Oritech.id("augment/armor")).requiredStation(ADVANCED_AUGMENT_STATION_ID).uiX(55).uiY(50).time(1800).rfCost(350000000L).modifierDefinition((Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.25f, AttributeModifier.Operation.ADD_VALUE).toggleable(true).export(exporter, "superspeedboost");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.MOTOR, 32).researchCost(TagContent.STEEL_INGOTS, 64).researchCost(TagUtils.cItemTag("storage_blocks/iron"), 16).applyCost((ItemLike)ItemContent.MOTOR, 16).applyCost(TagUtils.cItemTag("ingots/iron"), 64).requirement(Oritech.id("augment/superspeedboost")).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(80).uiY(50).time(800).rfCost(75000000L).modifierDefinition((Holder<Attribute>)Attributes.STEP_HEIGHT, 0.6f, AttributeModifier.Operation.ADD_VALUE).toggleable().export(exporter, "stepassist");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.SILICON_WAFER, 64).researchCost((ItemLike)ItemContent.PROCESSING_UNIT, 32).researchCost(TagUtils.cItemTag("storage_blocks/gold"), 16).applyCost(TagContent.SILICON, 32).applyCost(TagUtils.cItemTag("storage_blocks/redstone"), 32).requirement(Oritech.id("augment/hpboost")).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(30).uiY(90).time(400).rfCost(50000000L).modifierDefinition((Holder<Attribute>)Attributes.SCALE, -0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).toggleable().export(exporter, "dwarf");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.RAW_BIOPOLYMER, 64).researchCost((ItemLike)ItemContent.SMALL_URANIUM_DUST, 4).researchCost(TagContent.BIOMATTER, 64).applyCost((ItemLike)ItemContent.RAW_BIOPOLYMER, 32).applyCost(TagUtils.cItemTag("ingots/iron"), 64).requirement(Oritech.id("augment/dwarf")).requirement(Oritech.id("augment/armor")).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(55).uiY(90).time(1600).rfCost(300000000L).modifierDefinition((Holder<Attribute>)Attributes.SCALE, 1.0f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).toggleable().export(exporter, "giant");
        AugmentRecipeBuilder.build().researchCost(TagContent.STEEL_INGOTS, 64).researchCost((ItemLike)ItemContent.DURATIUM_INGOT, 8).researchCost(TagUtils.cItemTag("gems/diamond"), 16).applyCost((ItemLike)ItemContent.DURATIUM_INGOT, 4).applyCost(TagUtils.cItemTag("ingots/iron"), 32).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(30).uiY(50).time(800).rfCost(80000000L).modifierDefinition((Holder<Attribute>)Attributes.ARMOR, 4.0f, AttributeModifier.Operation.ADD_VALUE).export(exporter, "armor");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.ENERGITE_INGOT, 64).researchCost((ItemLike)ItemContent.MAGNETIC_COIL, 32).researchCost(TagUtils.cItemTag("gems/diamond"), 32).applyCost((ItemLike)ItemContent.MAGNETIC_COIL, 16).applyCost((ItemLike)ItemContent.OVERCHARGED_CRYSTAL).applyCost((ItemLike)ItemContent.DURATIUM_INGOT, 8).requirement(Oritech.id("augment/autofeeder")).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(105).uiY(50).time(1600).rfCost(280000000L).modifierDefinition((Holder<Attribute>)Attributes.ARMOR, 6.0f, AttributeModifier.Operation.ADD_VALUE).export(exporter, "betterarmor");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.FLUXITE, 64).researchCost((ItemLike)ItemContent.HEISENBERG_COMPENSATOR, 32).researchCost((ItemLike)ItemContent.PLUTONIUM_PELLET, 64).researchCost((ItemLike)Items.NETHER_STAR, 8).applyCost((ItemLike)BlockContent.FLUXITE_BLOCK, 32).applyCost((ItemLike)ItemContent.OVERCHARGED_CRYSTAL).applyCost(TagUtils.cItemTag("obsidians/normal"), 16).requirement(Oritech.id("augment/betterarmor")).requiredStation(ADVANCED_AUGMENT_STATION_ID).uiX(155).uiY(50).time(2400).rfCost(500000000L).modifierDefinition((Holder<Attribute>)Attributes.ARMOR, 8.0f, AttributeModifier.Operation.ADD_VALUE).export(exporter, "ultimatearmor");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.MAGNETIC_COIL, 64).researchCost(TagContent.ELECTRUM_INGOTS, 48).researchCost(TagUtils.cItemTag("storage_blocks/redstone"), 32).applyCost((ItemLike)ItemContent.MAGNETIC_COIL, 32).applyCost(TagUtils.cItemTag("storage_blocks/iron"), 64).requirement(Oritech.id("augment/blockreach")).requiredStation(ADVANCED_AUGMENT_STATION_ID).uiX(140).uiY(70).time(1600).rfCost(150000000L).modifierDefinition((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).export(exporter, "weaponreach");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.MOTOR, 64).researchCost(TagContent.STEEL_INGOTS, 48).researchCost(TagUtils.cItemTag("storage_blocks/copper"), 32).applyCost((ItemLike)ItemContent.MOTOR, 32).applyCost(TagUtils.cItemTag("ingots/copper"), 64).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(115).uiY(90).time(900).rfCost(100000000L).modifierDefinition((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).export(exporter, "blockreach");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.ENDERIC_LENS, 64).researchCost(TagUtils.cItemTag("ender_pearls"), 16).researchCost(TagUtils.cItemTag("storage_blocks/diamond"), 16).applyCost((ItemLike)ItemContent.ENDERIC_LENS, 32).applyCost(TagUtils.cItemTag("obsidians/normal"), 64).requirement(Oritech.id("augment/blockreach")).requiredStation(ADVANCED_AUGMENT_STATION_ID).uiX(140).uiY(90).time(800).rfCost(200000000L).modifierDefinition((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, 1.0f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).toggleable().export(exporter, "farblockreach");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.MAGNETIC_COIL, 48).researchCost((ItemLike)Items.QUARTZ_BLOCK, 64).researchCost((ItemLike)ItemContent.BASIC_BATTERY, 32).applyCost((ItemLike)Items.QUARTZ_BLOCK, 16).applyCost(TagUtils.cItemTag("ingots/iron"), 32).requirement(Oritech.id("augment/attackdamage")).requirement(Oritech.id("augment/speedboost")).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(30).uiY(10).time(1200).rfCost(100000000L).modifierDefinition((Holder<Attribute>)Attributes.BLOCK_BREAK_SPEED, 1.0f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).export(exporter, "miningspeed");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.ENERGITE_INGOT, 64).researchCost((ItemLike)ItemContent.FLUX_GATE, 48).researchCost((ItemLike)ItemContent.DURATIUM_INGOT, 64).applyCost((ItemLike)ItemContent.ENERGITE_INGOT, 32).applyCost(TagUtils.cItemTag("storage_blocks/redstone"), 64).requirement(Oritech.id("augment/miningspeed")).requirement(Oritech.id("augment/superspeedboost")).requiredStation(ADVANCED_AUGMENT_STATION_ID).uiX(80).uiY(10).time(2400).rfCost(450000000L).modifierDefinition((Holder<Attribute>)Attributes.BLOCK_BREAK_SPEED, 1.0f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).toggleable().export(exporter, "superminingspeed");
        AugmentRecipeBuilder.build().researchCost(TagContent.STEEL_INGOTS, 64).researchCost(TagUtils.cItemTag("gems/diamond"), 48).researchCost((ItemLike)ItemContent.FLUXITE, 32).applyCost(TagContent.STEEL_INGOTS, 16).applyCost((ItemLike)ItemContent.DURATIUM_INGOT, 4).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(5).uiY(10).time(1600).rfCost(150000000L).modifierDefinition((Holder<Attribute>)Attributes.ATTACK_DAMAGE, 4.0f, AttributeModifier.Operation.ADD_VALUE).export(exporter, "attackdamage");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.ENDERIC_COMPOUND, 64).researchCost((ItemLike)ItemContent.FLUXITE, 64).researchCost(TagUtils.cItemTag("rods/blaze"), 32).applyCost((ItemLike)ItemContent.ENDERIC_COMPOUND, 32).applyCost(TagUtils.cItemTag("storage_blocks/gold"), 32).requirement(Oritech.id("augment/hpboostultra")).requirement(Oritech.id("augment/ultimatearmor")).requiredStation(ARCANE_AUGMENT_STATION_ID).uiX(180).uiY(50).time(2800).rfCost(500000000L).modifierDefinition((Holder<Attribute>)Attributes.ATTACK_DAMAGE, 6.0f, AttributeModifier.Operation.ADD_VALUE).export(exporter, "superattackdamage");
        AugmentRecipeBuilder.build().researchCost(TagContent.ELECTRUM_INGOTS, 64).researchCost(TagUtils.cItemTag("storage_blocks/lapis"), 32).researchCost(TagUtils.cItemTag("storage_blocks/gold"), 24).applyCost(TagUtils.cItemTag("storage_blocks/lapis"), 24).applyCost(TagUtils.cItemTag("storage_blocks/redstone"), 24).requiredStation(ARCANE_AUGMENT_STATION_ID).uiX(55).uiY(30).time(1800).rfCost(200000000L).modifierDefinition((Holder<Attribute>)Attributes.LUCK, 5.0f, AttributeModifier.Operation.ADD_VALUE).export(exporter, "luck");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.MAGNETIC_COIL, 64).researchCost((ItemLike)ItemContent.FLUXITE, 48).researchCost((ItemLike)Items.PHANTOM_MEMBRANE, 8).applyCost((ItemLike)ItemContent.MAGNETIC_COIL, 32).applyCost(TagUtils.cItemTag("storage_blocks/iron"), 16).requirement(Oritech.id("augment/flight")).requiredStation(ARCANE_AUGMENT_STATION_ID).uiX(180).uiY(10).time(2200).rfCost(400000000L).modifierDefinition((Holder<Attribute>)Attributes.GRAVITY, -0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).toggleable().export(exporter, "gravity");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.ION_THRUSTER, 64).researchCost((ItemLike)Items.WIND_CHARGE, 16).researchCost((ItemLike)ItemContent.PROMETHEUM_INGOT, 16).researchCost((ItemLike)ItemContent.PLUTONIUM_PELLET, 32).applyCost((ItemLike)ItemContent.FLUX_GATE, 32).applyCost((ItemLike)ItemContent.PLUTONIUM_PELLET, 8).requirement(Oritech.id("augment/betterarmor")).requirement(Oritech.id("augment/portal")).requiredStation(ARCANE_AUGMENT_STATION_ID).uiX(155).uiY(30).time(3600).rfCost(500000000L).customAugmentDefinition(CustomAugmentsCollection.flight.id).toggleable().export(exporter, "flight");
        AugmentRecipeBuilder.build().researchCost((ItemLike)Items.ENDER_EYE, 32).researchCost((ItemLike)ItemContent.ENDERIC_LENS, 8).researchCost(TagUtils.cItemTag("gems/diamond"), 8).applyCost((ItemLike)ItemContent.ENDERIC_LENS, 32).applyCost((ItemLike)Items.GLOWSTONE, 64).requirement(Oritech.id("augment/orefinder")).requiredStation(ARCANE_AUGMENT_STATION_ID).uiX(155).uiY(10).time(3200).rfCost(100000000L).effectDefinition((Holder<MobEffect>)MobEffects.INVISIBILITY, 0).toggleable().export(exporter, "cloak");
        AugmentRecipeBuilder.build().researchCost(TagUtils.cItemTag("ender_pearls"), 16).researchCost(TagUtils.cItemTag("obsidians/normal"), 48).researchCost((ItemLike)ItemContent.UNHOLY_INTELLIGENCE).researchCost((ItemLike)ItemContent.ADAMANT_INGOT, 32).applyCost(TagUtils.cItemTag("ender_pearls"), 8).applyCost(TagUtils.cItemTag("obsidians/crying"), 32).requiredStation(ARCANE_AUGMENT_STATION_ID).uiX(130).uiY(30).time(3000).rfCost(250000000L).customAugmentDefinition(CustomAugmentsCollection.portal.id).toggleable().export(exporter, "portal");
        AugmentRecipeBuilder.build().researchCost(TagUtils.cItemTag("ingots/gold"), 64).researchCost((ItemLike)ItemContent.ENDERIC_LENS, 48).researchCost((ItemLike)Items.GLOWSTONE, 64).applyCost((ItemLike)ItemContent.ENDERIC_LENS, 4).applyCost((ItemLike)Items.GLOWSTONE, 8).applyCost((ItemLike)Items.REDSTONE_LAMP, 8).requiredStation(ADVANCED_AUGMENT_STATION_ID).uiX(105).uiY(30).time(2400).rfCost(50000000L).effectDefinition((Holder<MobEffect>)MobEffects.NIGHT_VISION, 0).toggleable().export(exporter, "nightvision");
        AugmentRecipeBuilder.build().researchCost((ItemLike)Items.PRISMARINE_CRYSTALS, 64).researchCost((ItemLike)ItemContent.BIOSTEEL_INGOT, 48).researchCost((ItemLike)Items.HEART_OF_THE_SEA).applyCost((ItemLike)ItemContent.BIOSTEEL_INGOT, 32).applyCost((TagKey<Item>)ItemTags.FISHES).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(5).uiY(90).time(800).rfCost(50000000L).effectDefinition((Holder<MobEffect>)MobEffects.WATER_BREATHING, 0).export(exporter, "waterbreath");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.PROCESSING_UNIT, 64).researchCost(TagContent.BIOMATTER, 48).researchCost((ItemLike)Items.GOLDEN_CARROT, 64).applyCost(TagContent.BIOMATTER, 32).applyCost((ItemLike)BlockContent.ITEM_PIPE, 64).applyCost((ItemLike)Items.HOPPER, 8).requirement(Oritech.id("augment/armor")).requirement(Oritech.id("augment/hpboostmore")).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(90).uiY(90).time(500).rfCost(30000000L).customAugmentDefinition(CustomAugmentsCollection.feeder.id).toggleable().export(exporter, "autofeeder");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.MAGNETIC_COIL, 64).researchCost((ItemLike)ItemContent.ENERGITE_INGOT, 48).researchCost((ItemLike)Items.LODESTONE, 2).applyCost((ItemLike)ItemContent.MAGNETIC_COIL, 32).applyCost(TagUtils.cItemTag("ingots/copper"), 64).requirement(Oritech.id("augment/superminingspeed")).requiredStation(SIMPLE_AUGMENT_STATION_ID).uiX(105).uiY(10).time(2400).rfCost(400000000L).customAugmentDefinition(CustomAugmentsCollection.magnet.id).toggleable().export(exporter, "magnet");
        AugmentRecipeBuilder.build().researchCost((ItemLike)ItemContent.ENDERIC_LENS, 32).researchCost((ItemLike)Items.SPYGLASS, 1).researchCost((ItemLike)ItemContent.OVERCHARGED_CRYSTAL).researchCost((ItemLike)ItemContent.PROMETHEUM_INGOT, 2).researchCost((ItemLike)Items.SCULK_SENSOR, 1).applyCost((ItemLike)ItemContent.ENDERIC_LENS, 32).applyCost((ItemLike)Items.REDSTONE_TORCH, 64).requirement(Oritech.id("augment/nightvision")).requirement(Oritech.id("augment/magnet")).requiredStation(ARCANE_AUGMENT_STATION_ID).uiX(130).uiY(10).time(3200).rfCost(200000000L).customAugmentDefinition(CustomAugmentsCollection.oreFinder.id).toggleable().export(exporter, "orefinder");
    }

    private void addReactorBlocks(RecipeOutput exporter) {
        this.offerRodRecipe(exporter, BlockContent.REACTOR_ROD.asItem(), RecipeHelpers.of(TagContent.PLASTIC_PLATES), RecipeHelpers.of((ItemLike)ItemContent.ENERGITE_INGOT), "singlerod");
        this.offerRodCombinationRecipe(exporter, BlockContent.REACTOR_DOUBLE_ROD.asItem(), RecipeHelpers.of((ItemLike)BlockContent.REACTOR_REFLECTOR), RecipeHelpers.of((ItemLike)BlockContent.REACTOR_ROD), "doublerod");
        this.offerRodCombinationRecipe(exporter, BlockContent.REACTOR_QUAD_ROD.asItem(), RecipeHelpers.of((ItemLike)BlockContent.REACTOR_REFLECTOR), RecipeHelpers.of((ItemLike)BlockContent.REACTOR_DOUBLE_ROD), "quadrod");
        this.offerMachinePlatingRecipe(exporter, BlockContent.REACTOR_WALL.asItem(), RecipeHelpers.of(TagContent.MACHINE_PLATING), RecipeHelpers.of(TagContent.STEEL_INGOTS), RecipeHelpers.of(TagContent.NICKEL_INGOTS), 4, "reactorplatingcrafting");
        AssemblerRecipeBuilder.build().input(TagContent.MACHINE_PLATING).input(TagContent.MACHINE_PLATING).input(TagContent.STEEL_INGOTS).input(TagContent.NICKEL_INGOTS).result(BlockContent.REACTOR_WALL.asItem(), 3).timeMultiplier(0.8f).export(exporter, "reactorplatingalt");
        this.offerMachinePlatingRecipe(exporter, BlockContent.REACTOR_REFLECTOR.asItem(), RecipeHelpers.of((ItemLike)BlockContent.REACTOR_WALL), RecipeHelpers.of((ItemLike)ItemContent.ADAMANT_INGOT), RecipeHelpers.of((ItemLike)ItemContent.DURATIUM_INGOT), 1, "reflector");
        this.offerRodCombinationRecipe(exporter, BlockContent.REACTOR_CONTROLLER.asItem(), RecipeHelpers.of((ItemLike)BlockContent.REACTOR_WALL), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), "controller");
        this.offerParticleMotorRecipe(exporter, BlockContent.REACTOR_ENERGY_PORT.asItem(), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of((ItemLike)BlockContent.ENERGY_PIPE), RecipeHelpers.of((ItemLike)BlockContent.REACTOR_WALL), RecipeHelpers.of(TagUtils.cItemTag("ingots/iron")), "energyport");
        this.offerParticleMotorRecipe(exporter, BlockContent.REACTOR_REDSTONE_PORT.asItem(), RecipeHelpers.of((ItemLike)ItemContent.PROCESSING_UNIT), RecipeHelpers.of((ItemLike)Items.REPEATER), RecipeHelpers.of((ItemLike)BlockContent.REACTOR_WALL), RecipeHelpers.of((ItemLike)Items.REDSTONE_TORCH), "redstoneport");
        this.offerParticleMotorRecipe(exporter, BlockContent.REACTOR_FUEL_PORT.asItem(), RecipeHelpers.of((ItemLike)BlockContent.ITEM_PIPE), RecipeHelpers.of((ItemLike)Items.HOPPER), RecipeHelpers.of((ItemLike)BlockContent.REACTOR_WALL), RecipeHelpers.of(TagUtils.cItemTag("chests")), "fuelport");
        this.offerParticleMotorRecipe(exporter, BlockContent.REACTOR_ABSORBER_PORT.asItem(), RecipeHelpers.of((ItemLike)BlockContent.ITEM_PIPE), RecipeHelpers.of((ItemLike)Items.HOPPER), RecipeHelpers.of((ItemLike)BlockContent.REACTOR_WALL), RecipeHelpers.of((ItemLike)Blocks.ICE), "absorberport");
        this.offerBatteryRecipe(exporter, BlockContent.REACTOR_CONDENSER.asItem(), RecipeHelpers.of((ItemLike)Items.ICE), RecipeHelpers.of(TagUtils.cItemTag("glass_blocks")), RecipeHelpers.of(TagContent.STEEL_INGOTS), "condenser");
        this.offerStarRecipe(exporter, BlockContent.REACTOR_VENT.asItem(), RecipeHelpers.of((ItemLike)ItemContent.MOTOR), RecipeHelpers.of(TagContent.CARBON_FIBRE), "reactorvent");
        this.offerStarRecipe(exporter, BlockContent.REACTOR_HEAT_PIPE.asItem(), RecipeHelpers.of(TagContent.ELECTRUM_INGOTS), RecipeHelpers.of(TagUtils.cItemTag("ingots/gold")), "reactorheatpipe");
        this.offerMachinePlatingRecipe(exporter, BlockContent.LOW_YIELD_NUKE.asItem(), RecipeHelpers.of((ItemLike)ItemContent.DUBIOS_CONTAINER), RecipeHelpers.of((ItemLike)ItemContent.URANIUM_PELLET), RecipeHelpers.of((ItemLike)Items.TNT), 1, "nuke");
        this.offerMachinePlatingRecipe(exporter, BlockContent.NUKE.asItem(), RecipeHelpers.of((ItemLike)ItemContent.HEISENBERG_COMPENSATOR), RecipeHelpers.of((ItemLike)ItemContent.PLUTONIUM_PELLET), RecipeHelpers.of((ItemLike)Items.TNT), 1, "nukebetter");
    }

    private void addReactorFuels(RecipeOutput exporter) {
        ReactorGeneratorRecipeBuilder.build().input((ItemLike)ItemContent.SMALL_URANIUM_PELLET).time(400).export(exporter, "smallpellet");
        ReactorGeneratorRecipeBuilder.build().input((ItemLike)ItemContent.URANIUM_PELLET).time(4000).export(exporter, "pellet");
        ReactorGeneratorRecipeBuilder.build().input((ItemLike)ItemContent.SMALL_PLUTONIUM_PELLET).time(4000).export(exporter, "smallplutoniumpellet");
        ReactorGeneratorRecipeBuilder.build().input((ItemLike)ItemContent.PLUTONIUM_PELLET).time(40000).export(exporter, "plutoniumpellet");
    }

    private void addLaserTransformations(RecipeOutput exporter) {
        LaserRecipeBuilder.build().input((ItemLike)Items.AMETHYST_CLUSTER).result(ItemContent.FLUXITE).export(exporter, "fluxite");
        LaserRecipeBuilder.build().input((ItemLike)BlockContent.URANIUM_CRYSTAL).result(ItemContent.PLUTONIUM_DUST).export(exporter, "plutoniumdust");
    }

    private void addCompactingRecipe(RecipeOutput exporter, ItemLike resBlock, ItemLike resItem, Ingredient itemIng, Ingredient blockIng) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)resItem, (int)9).requires(blockIng).unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)resBlock), OritechRecipeGenerator.has((ItemLike)resBlock)).save(exporter, Oritech.id(RecipeProvider.getSimpleRecipeName((ItemLike)resBlock) + "blockinv"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)resBlock).define(Character.valueOf('#'), itemIng).pattern("###").pattern("###").pattern("###").unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)resItem), OritechRecipeGenerator.has((ItemLike)resItem)).save(exporter, Oritech.id(RecipeProvider.getSimpleRecipeName((ItemLike)resBlock) + "block"));
    }

    public void offerCableRecipe(RecipeOutput exporter, ItemStack output, Ingredient input, String suffix) {
        Item item = output.getItem();
        this.createCableRecipe(RecipeCategory.MISC, output.getItem(), output.getCount(), input).unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)item), OritechRecipeGenerator.has((ItemLike)item)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerInsulatedCableRecipe(RecipeOutput exporter, ItemStack output, Ingredient input, Ingredient insulation, String suffix) {
        Item item = output.getItem();
        RecipeHelpers.createInsulatedCableRecipe(RecipeCategory.MISC, output.getItem(), output.getCount(), input, insulation).unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)item), OritechRecipeGenerator.has((ItemLike)item)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerRotatedCableRecipe(RecipeOutput exporter, ItemStack output, Ingredient input, Ingredient insulation, String suffix) {
        Item item = output.getItem();
        RecipeHelpers.createRotatedCableRecipe(RecipeCategory.MISC, output.getItem(), output.getCount(), input, insulation).unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)item), OritechRecipeGenerator.has((ItemLike)item)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerFramedCableRecipe(RecipeOutput exporter, ItemStack output, Ingredient input, String suffix) {
        Item item = output.getItem();
        this.createFramedCableRecipe(RecipeCategory.MISC, output.getItem(), output.getCount(), input).unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)item), OritechRecipeGenerator.has((ItemLike)item)).save(exporter, Oritech.id("crafting/frame_" + suffix));
    }

    public void offerCableFromFrameRecipe(RecipeOutput exporter, ItemStack output, Ingredient frame, String suffix) {
        Item item = output.getItem();
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)output.getCount()).requires(frame).unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)item), OritechRecipeGenerator.has((ItemLike)item)).save(exporter, Oritech.id("crafting/unframe_" + suffix));
    }

    public void offerCableDuctRecipe(RecipeOutput exporter, ItemStack output, Ingredient input, String suffix) {
        Item item = output.getItem();
        this.createCableDuctRecipe(RecipeCategory.MISC, item, output.getCount(), input).unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)item), OritechRecipeGenerator.has((ItemLike)item)).save(exporter, Oritech.id("crafting/duct_" + suffix));
    }

    public void offerCableFromDuctRecipe(RecipeOutput exporter, ItemStack output, Ingredient duct, String suffix) {
        Item item = output.getItem();
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)output.getCount()).requires(duct).unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)item), OritechRecipeGenerator.has((ItemLike)item)).save(exporter, Oritech.id("crafting/unduct_" + suffix));
    }

    public RecipeBuilder createCableRecipe(RecipeCategory category, Item output, int count, Ingredient input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)output, (int)count).define(Character.valueOf('#'), input).pattern("   ").pattern("###");
    }

    public RecipeBuilder createFramedCableRecipe(RecipeCategory category, Item output, int count, Ingredient input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)output, (int)count).define(Character.valueOf('c'), input).define(Character.valueOf('p'), Ingredient.of(TagContent.MACHINE_PLATING)).pattern("ccc").pattern("cpc").pattern("ccc");
    }

    public RecipeBuilder createCableDuctRecipe(RecipeCategory category, Item output, int count, Ingredient input) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)output, (int)count).define(Character.valueOf('c'), input).define(Character.valueOf('p'), Ingredient.of(TagContent.MACHINE_PLATING)).define(Character.valueOf('s'), RecipeHelpers.of((ItemLike)Blocks.STONE)).pattern("csc").pattern("sps").pattern("csc");
    }

    public void offerMotorRecipe(RecipeOutput exporter, Item output, Ingredient shaft, Ingredient core, Ingredient wall, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('s'), shaft).define(Character.valueOf('c'), core).define(Character.valueOf('w'), wall).pattern(" s ").pattern("wcw").pattern("wcw");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("motor/" + suffix));
    }

    public void offerManualAlloyRecipe(RecipeOutput exporter, Item output, Ingredient A, Ingredient B, String suffix) {
        this.offerManualAlloyRecipe(exporter, output, A, B, 1, suffix);
    }

    public void offerManualAlloyRecipe(RecipeOutput exporter, Item output, Ingredient A, Ingredient B, int count, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).define(Character.valueOf('a'), A).define(Character.valueOf('b'), B).pattern("aa ").pattern("bb ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/alloy/" + suffix));
    }

    public void offerGeneratorRecipe(RecipeOutput exporter, Item output, Ingredient base, Ingredient sides, Ingredient core, Ingredient frame, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('s'), sides).define(Character.valueOf('c'), core).define(Character.valueOf('f'), frame).define(Character.valueOf('b'), base).pattern("fff").pattern("fcf").pattern("sbs");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerFurnaceRecipe(RecipeOutput exporter, Item output, Ingredient bottom, Ingredient botSides, Ingredient middleSides, Ingredient core, Ingredient top, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('s'), botSides).define(Character.valueOf('c'), core).define(Character.valueOf('f'), top).define(Character.valueOf('b'), bottom).define(Character.valueOf('m'), middleSides).pattern("fff").pattern("mcm").pattern("sbs");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerAtomicForgeRecipe(RecipeOutput exporter, Item output, Ingredient base, Ingredient middleSides, Ingredient core, Ingredient top, Ingredient frame, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('s'), top).define(Character.valueOf('c'), core).define(Character.valueOf('f'), frame).define(Character.valueOf('b'), base).define(Character.valueOf('m'), middleSides).pattern("fsf").pattern("mcm").pattern("bbb");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerBatteryRecipe(RecipeOutput exporter, Item output, Ingredient inner, Ingredient sides, Ingredient top, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('t'), top).define(Character.valueOf('c'), inner).define(Character.valueOf('f'), sides).pattern(" t ").pattern("fcf").pattern("fcf");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerMachineFrameRecipe(RecipeOutput exporter, Item output, Ingredient base, Ingredient alt, int count, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).define(Character.valueOf('s'), base).define(Character.valueOf('c'), alt).pattern(" s ").pattern("csc").pattern(" s ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerMachineCoreRecipe(RecipeOutput exporter, Item output, Ingredient base, Ingredient alt, String suffix) {
        this.offerMachineCoreRecipe(exporter, output, 1, base, alt, suffix);
    }

    public void offerMachineCoreRecipe(RecipeOutput exporter, Item output, int count, Ingredient base, Ingredient alt, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).define(Character.valueOf('s'), base).define(Character.valueOf('c'), alt).pattern("sss").pattern("scs").pattern("sss");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerManualFluidApplication(RecipeOutput exporter, Item output, Ingredient fluid, Ingredient base, String suffix) {
        this.offerManualFluidApplication(exporter, output, 1, fluid, base, suffix);
    }

    public void offerManualFluidApplication(RecipeOutput exporter, Item output, int count, Ingredient fluid, Ingredient base, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).define(Character.valueOf('f'), fluid).define(Character.valueOf('b'), base).pattern("bb ").pattern("bf ").pattern("   ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerBeadsRecipe(RecipeOutput exporter, Item output, int count, Ingredient fluid, Ingredient base, Ingredient catalyst, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).define(Character.valueOf('f'), fluid).define(Character.valueOf('b'), base).define(Character.valueOf('c'), catalyst).pattern("bb ").pattern("cf ").pattern("   ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerDrillRecipe(RecipeOutput exporter, Item output, Ingredient doubleBase, Ingredient motor, Ingredient outer, Ingredient head, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('s'), doubleBase).define(Character.valueOf('m'), motor).define(Character.valueOf('a'), outer).define(Character.valueOf('e'), head).pattern(" a ").pattern("aea").pattern("mss");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerWrenchRecipe(RecipeOutput exporter, Item output, Ingredient A, Ingredient B, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('a'), A).define(Character.valueOf('b'), B).pattern(" a ").pattern(" ba").pattern("a  ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerChainsawRecipe(RecipeOutput exporter, Item output, Ingredient core, Ingredient motor, Ingredient center, Ingredient head, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('s'), core).define(Character.valueOf('m'), motor).define(Character.valueOf('a'), center).define(Character.valueOf('e'), head).pattern("aa ").pattern("ae ").pattern("mss");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerAxeRecipe(RecipeOutput exporter, Item output, Ingredient plating, Ingredient core, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('p'), plating).define(Character.valueOf('c'), core).pattern("pp ").pattern("pc ").pattern(" c ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerPickaxeRecipe(RecipeOutput exporter, Item output, Ingredient plating, Ingredient core, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('p'), plating).define(Character.valueOf('c'), core).pattern("ppp").pattern(" c ").pattern(" c ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerHelmetRecipe(RecipeOutput exporter, Item output, Ingredient plating, Ingredient core, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('p'), plating).define(Character.valueOf('c'), core).pattern("ppp").pattern("pcp").pattern("   ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerChestplateRecipe(RecipeOutput exporter, Item output, Ingredient plating, Ingredient core, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('p'), plating).define(Character.valueOf('c'), core).pattern("p p").pattern("ppp").pattern("pcp");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerLegsRecipe(RecipeOutput exporter, Item output, Ingredient plating, Ingredient core, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('p'), plating).define(Character.valueOf('c'), core).pattern("ppp").pattern("pcp").pattern("p p");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerFeetRecipe(RecipeOutput exporter, Item output, Ingredient plating, Ingredient core, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('p'), plating).define(Character.valueOf('c'), core).pattern("   ").pattern("p p").pattern("c c");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerRodRecipe(RecipeOutput exporter, Item output, Ingredient cap, Ingredient rod, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('c'), cap).define(Character.valueOf('r'), rod).pattern(" c ").pattern(" r ").pattern(" r ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerRodCombinationRecipe(RecipeOutput exporter, Item output, Ingredient cap, Ingredient rod, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('c'), cap).define(Character.valueOf('r'), rod).pattern("   ").pattern("rcr").pattern("   ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerStarRecipe(RecipeOutput exporter, Item output, Ingredient inner, Ingredient outer, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('c'), inner).define(Character.valueOf('o'), outer).pattern(" o ").pattern("oco").pattern(" o ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerTankRecipe(RecipeOutput exporter, Item output, Ingredient plating, Ingredient core, Ingredient sides, String suffix) {
        this.offerTankRecipe(exporter, output, 1, plating, core, sides, suffix);
    }

    public void offerTankRecipe(RecipeOutput exporter, Item output, int count, Ingredient plating, Ingredient core, Ingredient sides, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).define(Character.valueOf('p'), plating).define(Character.valueOf('s'), sides).define(Character.valueOf('c'), core).pattern("ppp").pattern("scs").pattern("ppp");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerTwoComponentRecipe(RecipeOutput exporter, Item output, Ingredient A, Ingredient B, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('a'), A).define(Character.valueOf('b'), B).pattern("ab ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerLeverRecipe(RecipeOutput exporter, Item output, Ingredient A, Ingredient B, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('a'), A).define(Character.valueOf('b'), B).pattern("a  ").pattern("b  ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerParticleMotorRecipe(RecipeOutput exporter, Item output, Ingredient rail, Ingredient top, Ingredient baseInner, Ingredient baseOuter, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('r'), rail).define(Character.valueOf('t'), top).define(Character.valueOf('i'), baseInner).define(Character.valueOf('o'), baseOuter).pattern(" t ").pattern("rrr").pattern("oio");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerMachinePlatingRecipe(RecipeOutput exporter, Item output, Ingredient side, Ingredient edge, Ingredient core, int count, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output, (int)count).define(Character.valueOf('a'), side).define(Character.valueOf('e'), edge).define(Character.valueOf('c'), core).pattern("eae").pattern("aca").pattern("eae");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerDoorRecipe(RecipeOutput exporter, Item output, Ingredient A, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output, (int)1).define(Character.valueOf('a'), A).pattern("aa ").pattern("aa ").pattern("aa ");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/" + suffix));
    }

    public void offerSlabRecipe(RecipeOutput exporter, Item output, Ingredient A, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)6).define(Character.valueOf('a'), A).pattern("aaa");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/slab/" + suffix));
    }

    public void offerStairsRecipe(RecipeOutput exporter, Item output, Ingredient A, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).define(Character.valueOf('a'), A).pattern("a  ").pattern("aa ").pattern("aaa");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/stairs/" + suffix));
    }

    public void offerPressurePlateRecipe(RecipeOutput exporter, Item output, Ingredient A, String suffix) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)output, (int)1).define(Character.valueOf('a'), A).pattern("aa");
        builder.unlockedBy(OritechRecipeGenerator.getHasName((ItemLike)output), OritechRecipeGenerator.has((ItemLike)output)).save(exporter, Oritech.id("crafting/pressureplate/" + suffix));
    }
}

