/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.decorative;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallMountedLight
extends FaceAttachedHorizontalDirectionalBlock {
    protected VoxelShape NORTH_WALL_SHAPE;
    protected VoxelShape SOUTH_WALL_SHAPE;
    protected VoxelShape WEST_WALL_SHAPE;
    protected VoxelShape EAST_WALL_SHAPE;
    protected VoxelShape FLOOR_Z_AXIS_SHAPE;
    protected VoxelShape FLOOR_X_AXIS_SHAPE;
    protected VoxelShape CEILING_Z_AXIS_SHAPE;
    protected VoxelShape CEILING_X_AXIS_SHAPE;

    public WallMountedLight(BlockBehaviour.Properties settings, int height) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FACE, (Comparable)AttachFace.FLOOR));
        this.SOUTH_WALL_SHAPE = Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)height);
        this.NORTH_WALL_SHAPE = Block.box((double)5.0, (double)0.0, (double)(16 - height), (double)11.0, (double)16.0, (double)16.0);
        this.WEST_WALL_SHAPE = Block.box((double)(16 - height), (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
        this.EAST_WALL_SHAPE = Block.box((double)0.0, (double)0.0, (double)5.0, (double)height, (double)16.0, (double)11.0);
        this.FLOOR_Z_AXIS_SHAPE = Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)height, (double)16.0);
        this.FLOOR_X_AXIS_SHAPE = Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)height, (double)11.0);
        this.CEILING_Z_AXIS_SHAPE = Block.box((double)5.0, (double)(16 - height), (double)0.0, (double)11.0, (double)16.0, (double)16.0);
        this.CEILING_X_AXIS_SHAPE = Block.box((double)0.0, (double)(16 - height), (double)5.0, (double)16.0, (double)16.0, (double)11.0);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((AttachFace)state.getValue((Property)FACE)) {
            case FLOOR: {
                return switch (((Direction)state.getValue((Property)FACING)).getAxis()) {
                    case Direction.Axis.X -> this.FLOOR_X_AXIS_SHAPE;
                    default -> this.FLOOR_Z_AXIS_SHAPE;
                };
            }
            case WALL: {
                return switch ((Direction)state.getValue((Property)FACING)) {
                    case Direction.EAST -> this.EAST_WALL_SHAPE;
                    case Direction.WEST -> this.WEST_WALL_SHAPE;
                    case Direction.SOUTH -> this.SOUTH_WALL_SHAPE;
                    default -> this.NORTH_WALL_SHAPE;
                };
            }
        }
        return switch (((Direction)state.getValue((Property)FACING)).getAxis()) {
            case Direction.Axis.X -> this.CEILING_X_AXIS_SHAPE;
            default -> this.CEILING_Z_AXIS_SHAPE;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{FACE});
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return null;
    }
}

